@extends('layouts.app')

@section('content')
 
    <div class="portlet ">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ProcurementInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th> 
                        <th>@lang('layout.Year')</th> 
                        <th>@lang('layout.Item')</th> 
                        <th>@lang('layout.Measure')</th>
                        <th>@lang('layout.Date')</th>
                    </tr> 
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $getStock->number }}  </td>
                        <td class="hidden-xs"> {{ $getStock->year_name }}  </td>
                        <td class="hidden-xs"> {{ $getStock->name }}  </td>
                        <td class="hidden-xs"> {{ $getStock->measure }}  </td>
                        <td class="hidden-xs"> {{ convertDate($getStock->date) }}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ProcurementDetails')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'closeYearStock.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearStockAll"/>
                           <input type="hidden" name="report_format" value="excel"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="id" value="{{$getStock->inventory_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'closeYearStock.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearStockAll"/>
                           <input type="hidden" name="report_format" value="pdf"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="id" value="{{$getStock->inventory_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                            <th>@lang('layout.SiteName')</th>
                            @if(systemConfig()[4] == 1 )
                            <th>@lang('layout.Code')</th>
                            @endif
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Cost')</th>
                            @if(systemConfig()[9] == 0 )
                            <th>@lang('layout.Length') </th>
                            <th>@lang('layout.Width') </th>
                            <th>@lang('layout.Wing') </th>
                            @endif
                            <th>@lang('layout.ExpireDate') </th>
                            @if(systemConfig()[9] != 0 )
                            <th>@lang('layout.Photo') </th>
                            @endif
                            @if(itemBrand()=="true" && systemConfig()[4] == 1)
                            <th>@lang('layout.Brand')</th>
                            <th>@lang('layout.Price')</th>
                            @endif
                            @if(getShowSuperceedNo()=="true" && systemConfig()[4] == 1)
                            <th>@lang('layout.SuperceedNo')</th>
                            @endif
                            @if(showLocation()=="true" && systemConfig()[4] == 1)
                            <th>@lang('layout.Location')</th>
                            @endif
                            @if(getOtherMeasure()=="true" && systemConfig()[4] == 1)
                            <th>@lang('layout.OMeasureValue') 1</th>
                            <th>@lang('layout.OMeasureValue') 2</th>
                            @endif
                            <th>@lang('layout.Description')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
        $('#sales').DataTable({
            ajax:'{{route("closeYearStock.show",$getStock->inventory_id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                { data: 'site', name: 'inventory_sites.name' },
                @if(systemConfig()[4] == 1 )
                { data: 'code', name: 'code' },
                @endif
                { data: 'qut_in', name: 'close_year_stocks.qut_in' },
                { data: 'measure', name: 'measure_units.name' },
                { data: 'cost', name: 'close_year_stocks.cost' },
                @if(systemConfig()[9] == 0 )
                { data: 'lengths', name: 'close_year_stocks.lengths' },
                { data: 'widths', name: 'close_year_stocks.widths' },
                { data: 'khada', name: 'close_year_stocks.khada' },
                @endif
                { data: 'expire_date', name: 'close_year_stocks.expire_date' },
                @if(systemConfig()[9] == 1 )
                { data: 'image', name: 'close_year_stocks.image' },
                @endif
                @if(itemBrand()=="true" && systemConfig()[4] == 1)
                { data: 'brand', name: 'inventory_brand.name' },
                { data: 'price', name: 'close_year_stocks.price' },
                @endif
                @if(getShowSuperceedNo()=="true" && systemConfig()[4] == 1)
                { data: 'superceed', name: 'close_year_stocks.superceed' },
                @endif
                @if(showLocation()=="true" && systemConfig()[4] == 1)
                { data: 'location', name: 'close_year_stocks.location' },
                @endif
                @if(getOtherMeasure()=="true" && systemConfig()[4] == 1)
                { data: 'other_measure', name: 'close_year_stocks.other_measure' },
                { data: 'other_measure2', name: 'close_year_stocks.other_measure2' },
                @endif
                { data: 'description', name: 'close_year_stocks.description' }
        ]
        });

    });
</script>


@endpush 