@extends('layouts.app')
@section('style')

<style>
	
	#table_content thead th {
    background-color: rgb(84, 199, 211);
    color: #ffffff;
    font-size: 14px;
}
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->

<!-- END PAGE BAR -->
<div class="row">

	<div class="portlet light bg-inverse">
		<div class="portlet-title">
			<div class="caption">
				<i class="icon-equalizer font-green-haze"></i>
				<span class="caption-subject font-green-haze bold uppercase">@lang('layout.OpeningCode')</span>
			</div>
		</div>
		<div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
			<!-- BEGIN FORM-->
			{{Form::open(['route' => 'closeYearStock.store','method' => 'POST','id' => 'inventory-form','files'=> true])}}
			<div class="form-body">

				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex = "1" label="name"  :options="{{ json_encode($closeYear) }}" v-model="closeYear" disabled="" ></v-select>
							<input type="hidden" name="closeYear_id" v-validate="'required'" data-vv-as="@lang('layout.CloseYear')" :value="(closeYear)?closeYear.id:null">
							<span class="required">@{{ errors.first('closeYear_id') }}</span>
						</div>
					</div>
				</div>  

				<!--/row-->
				<div class="row" style="overflow-x: scroll; overflow-y: scroll; height:600px;">
					<!-- begin payments -->
					<table id="table_content" class="table table-bordered table-advance table-hover">
						<thead>
							<tr>
								<th class="text-center" style="min-width: 8px;"> # </th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Item')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Site')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Code')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.OnHand')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Cost')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Default_Rate')</th>
								@if(systemConfig()[4] != 0 )
								@if(systemConfig()[9] != 0 )
								<th class="text-center" style="min-width: 160px;">@lang('layout.Photo')</th>
								<th v-show="showWhat('expire_date')=='yes'" class="text-center" style="min-width: 160px;">@lang('layout.ExpireDate')</th>
								@endif
								@if(systemConfig()[9] != 0 )
								<th class="text-center" style="min-width: 160px;">@lang('layout.Wing')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Width')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Length')</th>
								@endif
								@if(itemBrand()=="true")
								<th class="text-center" style="min-width: 160px;">@lang('layout.Brand')</th>
								<th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
								@endif
								@if(getShowSuperceedNo()=="true")
								<th class="text-center" style="min-width: 160px;">@lang('layout.SuperceedNo')</th>
								@endif
								@if(showLocation()=="true")
								<th class="text-center" style="min-width: 160px;">@lang('layout.Location')</th>
								@endif
								<th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 160px">@lang('layout.OMeasureValue') 1
                                </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 160px">@lang('layout.OMeasureValue') 2
                                </th>
								@endif
								<th></th>

							</tr>
						</thead>
						<tbody>
							<tr v-for="(service,index) in services">
								<td>@{{index+1}}</td>
								<td class="highlight">
									<v-select v-model="service.inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.SelectItem') " label="name" @click.native="addNew(index)" @keyup.native="addNew(index)"></v-select>
									<input type="hidden" :name="'id['+index+']'" :value="(service.inventory)?service.inventory.id:null">
									<input type="hidden" :name="'m_type['+index+']'" :value="(service.inventory)?service.inventory.m_type:null">
								</td>
								<td class="highlight">
									<v-select placeholder="@lang('layout.SelectSite') " label="site_name" :options="sites" @click.native="addNew(index)" @keyup.native="addNew(index)" v-model="service.site"></v-select>
									<input type="hidden" :name="'site_id['+index+']'" :value="(service.site)?service.site.site_id:null">
								</td>
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'code['+index+']'" :value="(service.item.code)?service.item.code:null" ref="code" type="text" class="form-control" placeholder="@lang('layout.Code')" />
								</td>
								<td>
									<input :value="(service.inventory)?service.inventory.measure:null" class="form-control" placeholder="@lang('layout.Measure')" readonly />
								</td>
								<td>
									<input :name="'qut_in['+index+']'" :value="(service.item.qut_in)?service.item.qut_in:null" ref="qut_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.OnHand')" />
								</td>
								<td>
									<input :name="'cost_in['+index+']'" :value="(service.item.cost_in)?service.item.cost_in:null" ref="cost_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Cost')" />
								</td>
								<td>
									<input :name="'price_in['+index+']'" :value="(service.item.price_in)?service.item.price_in:null" ref="price_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Default_Rate')" />
								</td>
								@if(systemConfig()[4] != 0 )
								@if(systemConfig()[9] != 0 )
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'image['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')" />
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" type="hidden" :name="'last_image['+index+']'" v-model="(service.item==null)?null:service.item.image" />
								</td>
								<td v-show="showWhat('expire_date')=='yes'">
									<date_picker :name="'expire_date['+index+']'" :value="(service.item.expire_date)?service.item.expire_date:null" placeholder="@lang('layout.ExpireDate')"></date_picker>
								</td>
								@endif
								@if(systemConfig()[9] != 0 )
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'khada['+index+']'" :value="(service.item.khada)?service.item.khada:null" ref="khada" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Wing')" />
								</td>
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'widths['+index+']'" :value="(service.item.widths)?service.item.widths:null" ref="widths" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Width')" />
								</td>
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'lengths['+index+']'" :value="(service.item.lengths)?service.item.lengths:null" ref="lengths" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Length')" />
								</td>
								@endif
								@if(itemBrand()=="true")
								<td>
									<v-select v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="service.item.selectedBrand"></v-select>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" type="hidden" :name="'brand_id['+index+']'" :value="(service.item.selectedBrand)?service.item.selectedBrand.id:null">
								</td>
								
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'description['+index+']'" type="text" v-model="service.item.description" class="form-control" placeholder="@lang('layout.Description')">
								</td>
								@endif
								@if(getShowSuperceedNo()=="true")
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'superceed['+index+']'" type="text" v-model="service.item.superceed" class="form-control" placeholder="@lang('layout.SuperceedNo')">
								</td>
								@endif
								@if(showLocation()=="true")
								<td>
									<input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" :name="'location['+index+']'" type="text" v-model="service.item.location" class="form-control" placeholder="@lang('layout.Location')">
								</td>
								@endif
								<td v-show="showWhat('other_measure')=='yes'">
                                        <input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" type="number" :name="'other_measure['+index+']'"
                                        class="form-control input-style" placeholder="@lang('layout.OMeasureValue') 1" v-model.number="(service.item==null)?null:service.item.other_measure">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input v-show="(((service.inventory)?service.inventory.m_type:null) == 'material')" type="number" :name="'other_measure2['+index+']'"
                                    class="form-control input-style" placeholder="@lang('layout.OMeasureValue') 2" v-model.number="(service.item==null)?null:service.item.other_measure2">
                                </td>
								@endif
								<td>
									<span v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
							</tr>
						</tbody>
					</table>
					<br />
					<br />
					<br />
				</div>
				<div class="row">
					<button type="button" @click="addNew(100000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
				</div>

			</div>

			<div class="col-xs-12 col-sm-10 col-md-11 text-center">
				<button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
				<a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
			</div>
			{{Form::close()}}
			<!-- END FORM-->
		</div>
	</div>
</div>

@endsection
@push('scripts')


<script>

@if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif

	Vue.component('modal', {
		template: '#vendor-template'
	})

	Vue.component('modal', {
		template: '#modal-template'

	})

	Vue.component('v-select', VueSelect.VueSelect)

	let vu = new Vue({
		el: '#item-service',
		data: {
			category: null,
			brand:{!! json_encode($brand) !!},
            selectedBrand:null,
			closeYear: {!!json_encode($selectYear) !!},
            site:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            cost: 1,
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            temp_items: [],
            selectedMetric: {},
            senddata: {},
            open_stock_data:{!!json_encode($opening)!!},
			services: [],
		},
		computed: {

			isError: function() {
				var isError = false;
				if (this.cost > 0) {
					isError = true;
				}
				return isError;
			},
			description: function(createElement) {
				this.total = this.cost * this.noHand
			},
			result: function() {
				var total = 0
				var cost = this.cost;

				this.services.forEach(function(item) {
					total += (item.item.qut_in) ? (Number.parseFloat(item.item.qut_in) * ((Number.parseFloat(item.item.cost_in) > 0) ? Number.parseFloat(item.item.cost_in) : 0)) : 0;
				})
				return total;

				// return this.cost * this.onHand;
			},
			onHand: function() {

				var total = 0
				this.services.forEach(function(item) {
					total += (item.item.qut_in) ? (Number.parseFloat(item.item.qut_in)) : 0;
				})
				// console.log('hh',this.services);
				return total;
			}


		},



		mounted: function() {
			// initialize the selected item
			for (var i = 0; i < this.open_stock_data.length; i++) {
				this.open_stock_data[i].selectedBrand = _.find({!!json_encode($brand) !!}, (o) => o.id == this.open_stock_data[i]['brand_id']);
				this.services.push({
					inventory: this.open_stock_data[i],
					item: this.open_stock_data[i],
					site: this.open_stock_data[i]
				});

			}

			// console.log('hh',this.services[0].item);

		},

		methods: {

			handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },

			onItemSearch: _.debounce((search, loading) => {
				// 
				loading(true);

				axios.get("{{route('callMethod.search')}}", {
						params: {
							method_name: 'itemSearchNameBoot',
							keyword: search,
						}
					})
					.then(function(response) {
						vu.temp_items = [];
						if (response.data.length > 0) {
							vu.temp_items = response.data;
							console.log(132, response.data);
						}
						loading(false);
					})
					.catch(function(error) {
						console.log(error);
					})
			}, getDebounceTime()),

			setData: function() {



			},

			setRate() {
				for (var i = 0; i < this.services.length; i++) {
					this.services[i].item.code = this.$refs.code[i].value;
					if (this.$refs.widths) {
						// console.log('eee');
						this.services[i].item.lengths = this.$refs.lengths[i].value;
						this.services[i].item.widths = this.$refs.widths[i].value;
						this.services[i].item.khada = this.$refs.khada[i].value;
					}
					if (this.$refs.cost_in) {
						// this.services[i].item.expire_date = this.$refs.expire_date[i].value;
						this.services[i].item.cost_in = this.$refs.cost_in[i].value;
						this.services[i].item.price_in = this.$refs.price_in[i].value;
					}
					this.services[i].item.qut_in = this.$refs.qut_in[i].value;

				}


			},

			// generic function for adding item to list
			addNew(index) {
				this.setRate();

				if (this.services[index + 1] == undefined) {
					this.services.push({
						item: {
							name: null,
							site: null,
							id: 0,
							inventory_site_id: null,
							main_stocks_id: null,
							m_stocks_in_id: null,
							code: null,
							lengths: null,
							widths: null,
							khada: null,
							// expire_date:null,
							qut_in: null,
							cost_in: null,
							price_in: null,
							m_type: null,
							selectedBrand: null
						},
					});

				}


			},
			// delete item from list
			deleteItem(index) {
				this.setRate();
				this.services.splice(index, 1);

			}


		}



	});

	vu.setData();
</script>


@endpush