@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.InvetoryList');
?>
@section('content')


<h3 class="table-caption" style="text-align: center;">@lang('layout.InvetoryList')</h3>

<table class="main-table">
  <thead>
    <tr class="bg">
      <th> @lang('layout.Record') </th>
      <th>@lang('layout.Number')</th>
      <th>@lang('layout.Year')</th>
      <th>@lang('layout.Item')</th>
      <th>@lang('layout.SiteName')</th>
      @if(systemConfig()[4] == 1 )
      @if($exportType == 'details' )
      <th>@lang('layout.Code')</th>
      @else
      <th>@lang('layout.TotalCode')</th>
      @endif
      @endif
      <th>@lang('layout.Quantity')</th>
      <th>@lang('layout.Measure')</th>
      <th>@lang('layout.Cost')</th>
      <th>@lang('layout.Date')</th>
      @if(getOtherMeasure()=="true" && systemConfig()[4] == 1)
      <th>@lang('layout.OMeasureValue') 1</th>
      <th>@lang('layout.OMeasureValue') 2</th>
      @endif
      @if(systemConfig()[9] == 0 )
      @if($exportType == 'details' )
      <th>@lang('layout.Length') </th>
      <th>@lang('layout.Width') </th>
      <th>@lang('layout.Wing') </th>
      @endif
      @endif
      <th>@lang('layout.ExpireDate') </th>
      @if(itemBrand()=="true" && systemConfig()[4] == 1)
      @if($exportType == 'details' )
      <th>@lang('layout.Brand')</th>
      <th>@lang('layout.Location')</th>
      <th>@lang('layout.SuperceedNo')</th>
      <th>@lang('layout.Price')</th>
      @endif
      @endif
      @if(systemConfig()[4] == 1)
      @if($exportType == 'details' )
      <th>@lang('layout.Description')</th>
      @endif
      @endif
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 1;
    ?>
    @foreach($data AS $record)
    <tr>
      <td class="center">{{ $count++ }}</td>
      <td class="center">{{$record->number}}</td>
      <td class="center">{{$record->year_name}}</td>
      <td class="center">{{$record->name}}</td>
      <td class="center">{{$record->site}}</td>
      @if(systemConfig()[4] == 1 )
      @if($exportType == 'details' )
      <td class="center">{{$record->code}}</td>
      @else
      <td class="center">{{$record->total_code}}</td>
      @endif
      @endif
      <td class="center">{{$record->qut_in}}</td>
      <td class="center">{{$record->measure}}</td>
      <td class="center">{{$record->cost}}</td>
      <td class="center">{{convertDate($record->date)}}</td>
      @if(getOtherMeasure()=="true" && systemConfig()[4] == 1)
      <td class="center">{{$record->other_measure}}</td>
      <td class="center">{{$record->other_measure2}}</td>
      @endif
      @if(systemConfig()[9] == 0 )
      @if($exportType == 'details' )
      <td class="center">{{$record->lengths}}</td>
      <td class="center">{{$record->widths}}</td>
      <td class="center">{{$record->khada}}</td>
      @endif
      @endif
      <td class="center">{{convertDate($record->expire_date)}}</td>
      @if(itemBrand()=="true" && systemConfig()[4] == 1)
      @if($exportType == 'details' )
      <td class="center">{{$record->brand}}</td>
      <td class="center">{{$record->location}}</td>
      <td class="center">{{$record->superceed}}</td>
      <td class="center">{{$record->price}}</td>
      @endif
      @endif
      @if(systemConfig()[4] == 1)
      @if($exportType == 'details' )
      <td class="center">{{$record->description}}</td>
      @endif
      @endif
    </tr>
    @endforeach
  </tbody>
</table>
<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection