@extends('layouts.app')

@section('content')
 
    <div class="portlet ">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ProcurementInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                            <th>@lang('layout.Year')</th> 
                            <th>@lang('layout.Member')</th> 
                            <th>@lang('layout.Phone')</th>
                            <th>@lang('layout.Date')</th>
                    </tr> 
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $getStatement->year_name }}  </td>
                        <td class="hidden-xs"> {{ $getStatement->name }}  </td>
                        <td class="hidden-xs"> {{ $getStatement->phone }}  </td>
                        <td class="hidden-xs"> {{ convertDate($getStatement->date) }}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ProcurementDetails')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'closeYearMemberStatement.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearMemberStatementAll"/>
                           <input type="hidden" name="report_format" value="excel"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="member_id" value="{{$getStatement->member_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'closeYearMemberStatement.report','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="closeYearMemberStatementAll"/>
                           <input type="hidden" name="report_format" value="pdf"/>
                           <input type="hidden" name="exportType" value="details"/>
                           <input type="hidden" name="member_id" value="{{$getStatement->member_id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Type')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
        $('#sales').DataTable({
            ajax:'{{route("closeYearMemberStatement.show",$getStatement->member_id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                { data: 'account_name', name: 'accounts.name' },
                { data: 'currency', name: 'close_year_member_statements.currency' },
                { data: 'rate', name: 'close_year_member_statements.rate' },
                { data: 'amount', name: 'close_year_member_statements.amount' },
                { data: 'type', name: 'close_year_member_statements.type' }
        ]
        });

    });
</script>


@endpush 