@extends('layouts.app')
@section('style')

<style>
	#table_content thead th {
		background-color: rgb(84, 199, 211);
		color: #ffffff;
		font-size: 14px;
	}
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->

<!-- END PAGE BAR -->
<div class="row">

	<div class="portlet light bg-inverse">
		<div class="portlet-title">
			<div class="caption">
				<i class="icon-equalizer font-green-haze"></i>
				<span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberStatement')</span>
			</div>
		</div>
		<div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
			<!-- BEGIN FORM-->
			{{Form::open(['route' => 'closeYearMemberStatement.store','method' => 'POST','id' => 'statement-form','files'=> true])}}
			<div class="form-body">

				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.CloseYear')</label>
							<v-select placeholder="@lang('layout.CloseYear')" tabindex="1" label="name" :options="{{ json_encode($closeYear) }}" v-model="closeYear" disabled></v-select>
							<input type="hidden" name="closeYear_id" v-validate="'required'" data-vv-as="@lang('layout.CloseYear')" :value="(closeYear)?closeYear.id:null">
							<span class="required">@{{ errors.first('closeYear_id') }}</span>
						</div>
					</div>
					<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
						<div class="form-group">
							<label class="control-label">@lang('layout.Currency')</label>
							<input class="form-control" :value="(closeYear)?closeYear.base_currency:null" readonly>
						</div>
					</div>
				</div>

				<!--/row-->
				<div class="row" style="overflow-x: scroll; overflow-y: scroll; height:600px;">
					<!-- begin payments -->
					<table id="table_content" class="table table-bordered table-advance table-hover">
						<thead>
							<tr>
								<th class="text-center"> # </th>
								<th class="text-center">@lang('layout.Name')</th>
								<th class="text-center">@lang('layout.Phone')</th>
								<th class="text-center">@lang('layout.Address')</th>
								<th width="50%">
									<center class="center"> @lang('layout.Balance')
										<table id="table_content" class="table table-bordered table-advance" style="width:100%">
											<tr class="">
												<th width="10%">
													<div class="center"> @lang('layout.Currency') </div>
												</th>
												<th width="10%">
													<div class="center"> @lang('layout.Rate') </div>
												</th>
												<th width="25%">
													<div class="center"> @lang('layout.Receivable') </div>
												</th>
												<th width="25%">
													<div class="center"> @lang('layout.Payable') </div>
												</th>
												<th width="30%">
													<div class="center"> @lang('layout.Balance') </div>
												</th>
											</tr>
										</table>
									</center>
								</th>

							</tr>
						</thead>
						<tbody>
							<?php
							$index = 0;
							$count = 0;
							?>
							@foreach($data AS $key=>$value)
							<tr>
								<input type="hidden" name="member_id[{{$index}}]" value="{{$value['member_id']}}" />
								<td>{{++$count}}</td>
								<td>{{$key}}</td>
								<td>{{$value['Phone']}}</td>
								<td>{{$value['Address']}}</td>
								<td width="60%">
									<table id="table_content" class="table table-bordered table-advance" style="width:100%">
										@foreach($value['Currency'] AS $key1=>$row)
										<tr>
											<td width="10%">
												<input  name="currency[{{$index}}][{{$key1}}]" value="{{$key1}}" class="form-control" placeholder="@lang('layout.Currency')" readonly />
											</td>
											<td width="14%">
												<input  name="rate[{{$index}}][{{$key1}}]" value="{{$row['rate']}}" class="form-control" placeholder="@lang('layout.Rate')" />
											</td>
											<td width="22%">
												<input value="{{myRound($row['Receivable'])}}" class="form-control" placeholder="@lang('layout.Receivable')" readonly />
											</td>
											<td width="22%">
												<input value="{{myRound($row['Payable'])}}" class="form-control" placeholder="@lang('layout.Payable')" readonly />
											</td>
											<td width="30%">
												<?php
												$result1 = SumToNumber($row['Payable'], $row['Receivable']);
												$p1 = $result1['a'];
												$r1 = $result1['b'];
												?>
												@if($r1 !=0)
												<div class="input-group">
													<input name="amount[{{$index}}][{{$key1}}]" value="{{round($r1,precision())}}" class="form-control" placeholder="@lang('layout.Receivable')" />
													<input type="hidden" name="receivable_id[{{$index}}][{{$key1}}]" value="{{$value['receivable_id']}}" />
													<span class="input-group-addon">
														@lang('layout.Receivable')
													</span>
												</div>

												@elseif($p1 !=0)
												<div class="input-group">
													<input name="amount[{{$index}}][{{$key1}}]" value="{{round($p1,precision())}}" class="form-control" placeholder="@lang('layout.Payable')" />
													<input type="hidden" name="payable_id[{{$index}}][{{$key1}}]" value="{{$value['payable_id']}}" />
													<span class="input-group-addon">
														@lang('layout.Payable')
													</span>
												</div>
												@endif
											</td>
										</tr>
										@endforeach
									</table>
								</td>
							</tr>
							<?php $index++ ?>
							@endforeach
						</tbody>
					</table>
					<br />
					<br />
					<br />
				</div>
				<!-- <div class="row">
					<button type="button" @click="addNew(100000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
				</div> -->

			</div>
			<br />
			<div class="col-xs-12 col-sm-10 col-md-11 text-center">
				<button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
				<a href="{{route('closeYearMemberStatement.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
			</div>
			{{Form::close()}}
			<!-- END FORM-->
		</div>
	</div>
</div>

@endsection
@push('scripts')


<script>
	@if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif

	Vue.component('modal', {
		template: '#vendor-template'
	})

	Vue.component('modal', {
		template: '#modal-template'

	})

	Vue.component('v-select', VueSelect.VueSelect)

	let vu = new Vue({
		el: '#item-service',
		data: {
			category: null,
			selectedBrand: null,
			closeYear: {!!json_encode($selectYear) !!},
			site: null,
			type: 'inventoryPart',
			cost: 1,
			total: 0,
			errorMessage: '',
			showModal: false,
			fieldErrors: [],
			temp_items: [],
			selectedMetric: {},
			senddata: {},
			data: {!!json_encode($data) !!},
			services: [],
		},
		computed: {

			isError: function() {
				var isError = false;
				if (this.cost > 0) {
					isError = true;
				}
				return isError;
			},
			description: function(createElement) {
				this.total = this.cost * this.noHand
			},
			result: function() {
				var total = 0
				var cost = this.cost;

				return total;

				// return this.cost * this.onHand;
			},
			onHand: function() {

				var total = 0

				console.log('hh', this.services);
				return total;
			}


		},



		mounted: function() {
			// initialize the selected item
			// for (var i = 0; i < this.data.length; i++) {
			// 	this.services.push({
			// 		item: this.data[i]
			// 	});

			// }

			// console.log('hh',this.services);

		},

		methods: {

			handleSubmit(e) {
				this.$validator.validate().then(valid => {
					if (valid) {
						regForm(e.target);
					}
				});
			},

			setData: function() {



			},

			setRate() {
				for (var i = 0; i < this.services.length; i++) {
					// this.services[i].item.code = this.$refs.code[i].value;


				}


			},

			// generic function for adding item to list
			addNew(index) {
				this.setRate();

				if (this.services[index + 1] == undefined) {
					this.services.push({
						item: {
							name: null,
							site: null,
							id: 0,
							inventory_site_id: null,
							main_stocks_id: null,
							m_stocks_in_id: null,
							code: null,
							lengths: null,
							widths: null,
							khada: null,
							// expire_date:null,
							qut_in: null,
							cost_in: null,
							price_in: null,
							m_type: null,
							selectedBrand: null
						},
					});

				}


			},
			// delete item from list
			deleteItem(index) {
				this.setRate();
				this.services.splice(index, 1);

			}


		}



	});

	vu.setData();
</script>


@endpush