@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.MemberStatementList');
?>
@section('content')


<h3 class="table-caption" style="text-align: center;">@lang('layout.MemberStatementList')</h3>

<table class="main-table">
  <thead>
    <tr class="bg">
      <th> @lang('layout.Record') </th>
      <th>@lang('layout.Year')</th> 
      <th>@lang('layout.Member')</th> 
      <th>@lang('layout.Phone')</th>
      <th>@lang('layout.Date')</th>
      
      @if($exportType == 'details' )
      <th>@lang('layout.Account')</th>
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.Rate')</th>
      <th>@lang('layout.Amount')</th>
      <th>@lang('layout.Type')</th>
      @endif
      <th>@lang('layout.Address')</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 1;
    ?>
    @foreach($data AS $record)
    <tr>
      <td class="center">{{ $count++ }}</td>
      <td class="center">{{$record->year_name}}</td>
      <td class="center">{{$record->name}}</td>
      <td class="center">{{$record->phone}}</td>
      <td class="center">{{convertDate($record->date)}}</td>
      
      @if($exportType == 'details' )
      <td class="center">{{$record->account_name}}</td>
      <td class="center">{{$record->currency}}</td>
      <td class="center">{{$record->rate}}</td>
      <td class="center">{{$record->amount}}</td>
      <td class="center">{{__('layout.'.$record->type)}}</td>
      @endif
      <td class="center">{{$record->address1}}</td>
    </tr>
    @endforeach
  </tbody>
</table>
<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection