@extends('layouts.app') 
@section('content') 
<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ChequeDetails')
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa  fa-sort-numeric-asc"></i> @lang('layout.Number')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa  fa-sort-numeric-desc"></i> @lang('layout.ChequeNumber')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-arrows-v"></i> @lang('layout.Type')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-check-square"></i> @lang('layout.Status')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa  fa-user"></i> @lang('layout.Member')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-money"></i> @lang('layout.Amount')
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-exchange"></i> @lang('layout.Rate') 
                        </th>
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-stack-exchange"></i> @lang('layout.TransactionType') 
                        </th> 
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ $cheque->number}} </td>
                        <td class="text-center"> {{ $cheque->ref_no}} </td>
                        <td class="text-center"> {{ __('type.'.$cheque->type) }} </td>
                        <td class="text-center"> 
                            @if($cheque->status == 'on')
                            @lang('layout.NotImplemented')
                            
                            @elseif ($cheque->status == 'cancel')
                                @lang('layout.Canceled')
                            @else
                            @lang('layout.Implemented')
                            @endif
                        </td>
                        <td class="text-center"> {{ $cheque->Member}} </td>
                        <td class="text-center"> {{ convertDate($cheque->date) }} </td>
                        <td class="text-center"> {{$cheque->Account}} </td>
                        <td class="text-center"> {{ myRound($cheque->amount)}} {{ $cheque->currency}} </td>
                        <td class="text-center"> {{myRound($cheque->rate)}} </td>
                        <td class="text-center"> {{ __('layout.'.$cheque->transaction_type) }} </td>
                        
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        @if($cheque->gain_loss_status)
                        <th class="text-center" style="width: 10%;">
                            <i class="fa fa-line-chart"></i> @lang('layout.ProfitAndLost') 
                        </th>
                        @endif
                        <th class="text-center" style="width: 10%;"><i class="fa fa-send-o"></i> @lang('layout.Sender')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-sort-numeric-asc"></i> @lang('layout.SSN') / @lang('layout.PassportNumber')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-user"></i> @lang('layout.FatherName')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-phone-square"></i> @lang('layout.Phone')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-globe"></i> @lang('layout.Address')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-send-o" style="transform: rotate(180deg)"></i> @lang('layout.Reciever')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-sort-numeric-asc"></i> @lang('layout.SSN') / @lang('layout.PassportNumber')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-user"></i> @lang('layout.FatherName')</th>
                        
                        
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        @if($cheque->gain_loss_status)
                        <td class="text-center"> {{myRound($cheque->gain_loss_amount)}}   {{getHomeCurrency()[getCurrencyType()]}} </td>
                        @endif
                        <td class="text-center"> {{$cheque->sender}} </td>
                        <td class="text-center"> {{$cheque->sen_ssn_number}} </td>
                        <td class="text-center"> {{$cheque->sen_father_name}} </td>
                        <td class="text-center"> {{$cheque->sen_phone}} </td>
                        <td class="text-center"> {{$cheque->sen_address}} </td>
                        <td class="text-center"> {{$cheque->reciever}} </td>
                        <td class="text-center"> {{$cheque->rec_ssn_number}} </td>
                        <td class="text-center"> {{$cheque->rec_father_name}} </td>
                        
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-phone-square"></i> @lang('layout.Phone')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-globe"></i> @lang('layout.Address')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-calendar"></i> @lang('layout.DueDate')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-stack-exchange"></i> @lang('layout.MonetarySource')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-stack-exchange"></i> @lang('layout.TransactionType')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-user"></i> @lang('layout.User')</th>
                        <th class="text-center" style="width: 10%;"></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{$cheque->rec_phone}} </td>
                        <td class="text-center"> {{$cheque->rec_address}} </td>
                        <td class="text-center"> {{ convertDate($cheque->due_date) }} </td>
                        <td class="text-center"> {{$cheque->monetary_source}} </td>
                        <td class="text-center"> {{$cheque->trans_type}} </td>
                        <td class="text-center"> {{$cheque->username}} </td>
                        <td class="text-center">  </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Type')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Amount')</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Percentage')  @lang('layout.Commission')</th>
                        @if($cheque->commission_amount2)
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Type') 2</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Amount') 2</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Percentage')  @lang('layout.Commission') 2</th>
                        @endif
                        @if($cheque->commission_amount3)
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Type') 3</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Commission') @lang('layout.Amount') 3</th>
                        <th class="text-center" style="width: 10%;"><i class="fa fa-database"></i> @lang('layout.Percentage')  @lang('layout.Commission') 3</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ __('type.'.$cheque->commission_type) }} </td>
                        <td class="text-center"> {{ myRound($cheque->commission_amount * (($cheque->commiss_expense)? -1:1))}} {{ $cheque->commission_currency}} </td>
                        <td class="text-center"> {{$cheque->comm_percentage_one}} </td>
                        @if($cheque->commission_amount2)
                        <td class="text-center"> {{ __('type.'.$cheque->commission_type2) }} </td>
                        <td class="text-center"> {{ myRound($cheque->commission_amount2 * (($cheque->commiss_expense2)? -1:1))}} {{ $cheque->commission_currency2}} </td>
                        <td class="text-center"> {{$cheque->comm_percentage_two}} </td>
                        @endif
                        @if($cheque->commission_amount3)
                        <td class="text-center"> {{ __('type.'.$cheque->commission_type3) }} </td>
                        <td class="text-center"> {{ myRound($cheque->commission_amount3 * (($cheque->commiss_expense3)? -1:1))}} {{ $cheque->commission_currency3}} </td>
                        <td class="text-center"> {{$cheque->comm_percentage3}} </td>
                        @endif
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center">
                            <i class="fa fa-bars"></i> @lang('layout.Description')
                        </th>
                        <th class="text-center">
                            <i class="fa fa-bars"></i> @lang('layout.Description')1
                        </th>
                        <th class="text-center">
                            <i class="fa fa-bars"></i> @lang('layout.Description')2
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ $cheque->description }} </td>
                        <td class="text-center"> {{ $cheque->description1 }} </td>
                        <td class="text-center"> {{ $cheque->description2 }} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover" id="loan_table" >
                <thead> 
                    <tr>
                        @if(systemConfig()[29] == 1)
                        <th>
                            <i class="fa "></i> @lang('layout.TransactionConfirm')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.Description')
                        </th>   
                        <th>
                            <i class="fa "></i> @lang('layout.Status')
                        </th>  
                        @endif      
                    </tr>
                </thead>
                <tbody>
                <tr>  
                    @if(systemConfig()[29] == 1)
                    @if($cheque->transaction_confirm)
                    <td class="">
                        @lang('layout.yes')
                    </td>
                    @else
                    <td class="">
                        @lang('layout.no')
                    </td>
                    @endif
                    <td class="">
                        {{$cheque->position_description}}
                    </td>
                    <td class="">
                    @if($cheque->position_status == 'accept')
                    @lang('type.accept')
                    @elseif($cheque->position_status == 'true')
                    @lang('type.pending') &nbsp;&nbsp;&nbsp;&nbsp;
                    @if (getPositionCurrencyAmount() > $cheque->dollarAmount)
                    <form action="{{route('cheque.position_status', ['id' => $cheque->id, 'type' => 'accupt'])}}" method="post" class="inline">
                        <input type="hidden" name="_method" value="PATCH" />
                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                        <input type="text" name="position_description" required style="width: 40%;" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                            <input type="radio" value="accupt" required name="type"><span></span> @lang('layout.Accept')
                        </label>
                        &nbsp;&nbsp;
                        <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                            <input type="radio" value="reject" required name="type"><span></span> @lang('layout.Reject')
                        </label>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <button type="button" onclick="regForm(this)" class="btn btn-info " title="{{__('layout.Submit')}}" role="button">{{__('layout.Submit')}}</button>
                        
                    </form>
                    {{-- &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <form action="{{route('cheque.position_status', ['id' => $cheque->id, 'type' => 'false'])}}" method="post" class="inline">
                        <input type="hidden" name="_method" value="PATCH" />
                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                        <input type="text" name="position_description" style="width: 35%;" />
                        <button type="button" onclick="regForm(this)" class="btn btn-warning " title="{{__('type.on')}}" role="button"><span class="fa fa-ban"></button>
                    </form>   --}}
                    @endif
                    @elseif($cheque->position_status == 'reject')
                        @lang('type.Rejected')
                    @elseif($cheque->position_status == 'false')
                        @lang('type.cancel')
                    @endif
                    </td>
                    @endif
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>



<div class="row hidden-print">
    <div class="tabbable tabbable-tabdrop">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab2">
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="portlet-body">
                                    <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="redirect_route" value="cheque.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$cheque->id}}">
                                        <input type="hidden" name="path" value="uploads/cheque">
                                        <input type="hidden" name="table_name" value="cheque">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" rows="8" class="form-control" style="resize: none;"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div>
                                                            <span class="btn default btn-file">
                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>
                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 165px;">
                                                            <img src="" alt=""> </div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10 text-center">
                                            <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.AttachmentTitle')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

@endsection

@push('scripts')

<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("cheque.show",$cheque->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });



    });
</script>
@endpush