@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ChequeEdit')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div> 
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($cheque, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['chequeReciever.update',$cheque->id]]) !!}
                <div class="form-body  col-md-12" id="app" v-cloak>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div v-show="showWhat('member_class')=='yes'" class="col-md-4">
                                    <label class="control-label">@lang('layout.MemberClass') </label>

                                    <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                    <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                    <input  readonly class="form-control" value="{{ __('type.'.$cheque->type) }}">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$cheque->number}}">
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.ChequeNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-md-2"  >
                                    <label class="control-label ">@lang('layout.BranchTransfer')</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="branch_type" v-model="branch_type" value="on">
                                            <span></span>
                                        </span>
                                        <v-select v-if="branch_type" label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                        <input type="hidden" name="company_id" :value="(!selected_company)?null:selected_company.id" >
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4" style="padding: 0px !important;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" disabled :options="currency" @Click.native="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()" >
                                            <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Amount')</label>
                                    <!-- <div class="input-group"> -->
                                        <input type="number" readonly name="amount" class="form-control" v-model="amount" @input="getTranslateToWord(), get_exchange()" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                    </div> -->
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                                <div class="col-md-2" v-if="amount_to_word" >
                                    <label class="control-label">@lang('layout.TotalInLeters'):</label>
                                    <span class="col-md-12">@{{amount_to_word}}</span>
                                </div>

                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                        <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-2" v-if="!(sender && chequeType == 'Send')"  v-show="!(reciever && chequeType == 'Receive')">
                                    <span v-if="chequeType == 'Send'" v-show="false">
                                        @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                    </span>
                                    <span v-else v-show="false">
                                        @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                    </span>
                                    <label class="control-label">@lang('layout.Balance')</label>
                                    <!-- <div class="input-group"> -->
                                        <input class="form-control" disabled :value="balance.toFixed(precision())">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                    </div> -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.BranchName') / @lang('layout.Customer')</label>
                                    <v-select class="vue-select2" v-model="selectedMember" disabled @input="getSummary()" label="name" :options="member" @search="MemberSearch" >
                                    </v-select>
                                    <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-8" style="padding: 0px !important;" >
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Commission')</label>
                                        <div class="input-group">
                                            <input type="number" name="commiss_amount" readonly value="{{$cheque->commission_amount}}" class="form-control">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="select_commiss_currency" v-model="commiss_currency" @Click="setCommSize(selectedCurrency2.code)" >
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                        <select class="form-control" name="commission_type" v-model="commission_type">
                                            <option value="Simple">@lang('type.Simple')</option>
                                            <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                            <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                        </select>
                                    </div>
                                    <div v-if="commiss_currency" class="col-md-3" style="padding: 0px !important;">
                                        <div :class="comcurrency_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency2" label="code" :options="currency" @Click.native="setCommSize(selectedCurrency2.code)"> </v-select>
                                            <input type="hidden" name="commiss_currency" v-bind:value="(selectedCurrency2)?selectedCurrency2.code:null" />
                                        </div>
                                        <div :class="comrate_len" v-if="selectedCurrency2.code != code">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selected_rate2" class="form-control" type="number" step="any" min="0">
                                            <input type="hidden" name="commiss_rate" :value="selected_rate2">
                                        </div>
                                    </div>
                                    <div v-if="commiss_currency" class="col-md-2">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="commiss_account_id" v-model="defaultAccount1">
                                            <option v-for="Account in accountUpdateComm" :value="Account.id">@{{ Account.name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2" v-if="commission_type != 'BelongsToOtherBranch'" >
                                        <label class="control-label">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4" style="padding: 0px !important;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                        <v-select v-model="paymentCurrency" label="code" :options="currency1" @Click.native="setPaymentSize(paymentCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()" :readonly="selectedCurrency.code==paymentCurrency.code">
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <input type="number" v-model="exchange_amount" @input="set_rate()" class="form-control" min="0" step="any">
                                        <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(8)">
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="gain_loss_status" v-model="gain_loss_status">
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label" for="form_control">@lang('layout.TransactionType')</label>
                                    <div class="md-radio-inline">
                                        <div class="md-radio" style="margin-right: 10px;">
                                            <input type="radio" id="radio4" name="transaction_type" value="Local" class="md-radiobtn" @if($cheque->transaction_type == 'Local') checked="" @endif >
                                            <label for="radio4">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.Local') </label>
                                        </div>
                                        <div class="md-radio" style="margin-right: 10px;">
                                            <input type="radio" id="radio5" name="transaction_type" value="Foreign" class="md-radiobtn" @if($cheque->transaction_type == 'Foreign') checked="" @endif >
                                            <label for="radio5">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.Foreign') </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','id'=>'reg_date','autocomplete'=>'off'])}}
                                </div>
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.DueDate')</label>
                                    {{Form::text('due_date',null,['class' => 'form-control date','id'=>'dueDates','autocomplete'=>'off'])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-3" v-if="!sender" >
                                    <label class="control-label">@lang('layout.Sender')</label>
                                    <div class="input-group">
                                        <!-- <span class="input-group-addon">
                                            <input type="checkbox" v-model="sender">
                                            <span></span>
                                        </span> -->
                                        <input type="text" class="form-control " value="{{$cheque->sender}}" autocomplete="off" name="sender">
                                    </div>
                                </div>
                                <div class="col-md-3" v-if="!sender" >
                                    <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                    <input type="text" class="form-control " value="{{$cheque->sen_ssn_number}}" autocomplete="off" name="sen_ssn_number">
                                </div>
                                <div class="col-md-2" v-if="!sender">
                                    <label class="control-label">@lang('layout.FatherName')</label>
                                    <input type="text" class="form-control" value="{{$cheque->sen_father_name}}" autocomplete="off" name="sen_father_name">
                                </div>
                                
                                <div class="col-md-2" v-if="!sender">
                                    <label class="control-label">@lang('layout.Phone')</label>
                                    <input type="text" class="form-control" value="{{$cheque->sen_phone}}" autocomplete="off" name="sen_phone">
                                </div>
                                <div class="col-md-2" v-if="!sender">
                                    <label class="control-label">@lang('layout.Address')</label>
                                    <input type="text" class="form-control" value="{{$cheque->sen_address}}" autocomplete="off" name="sen_address">
                                </div>
                                <div class="col-md-6" v-if="sender" >
                                    <label class="control-label ">@lang('layout.Sender')</label>
                                    <div class="input-group">
                                        <!-- <span class="input-group-addon">
                                            <input type="checkbox" v-model="sender">
                                            <span></span>
                                        </span> -->
                                        <v-select class="vue-select2" disabled v-model="selectedSender" label="name" :options="simple_member" @search="SimpleMemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="sender_id" :value="(!selectedSender)?null:selectedSender.id" >
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3" v-if="!reciever">
                                    <label class="control-label">@lang('layout.Reciever')</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" v-model="reciever">
                                            <span></span>
                                        </span>
                                        <input type="text" class="form-control " value="{{$cheque->reciever}}" autocomplete="off" name="reciever">
                                    </div>
                                </div>
                                <div class="col-md-3" v-if="!reciever" >
                                    <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                    <input type="text" class="form-control " value="{{$cheque->rec_ssn_number}}" autocomplete="off" name="rec_ssn_number">
                                </div>
                                <div class="col-md-2" v-if="!reciever">
                                    <label class="control-label">@lang('layout.FatherName')</label>
                                    <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_father_name}}" name="rec_father_name">
                                </div>
                                
                                <div class="col-md-2" v-if="!reciever">
                                    <label class="control-label">@lang('layout.Phone')</label>
                                    <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_phone}}" name="rec_phone">
                                </div>
                                <div class="col-md-2" v-if="!reciever">
                                    <label class="control-label">@lang('layout.Address')</label>
                                    <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_address}}" name="rec_address">
                                </div>
                                <div class="col-md-6" v-if="reciever" >
                                    <label class="control-label ">@lang('layout.Reciever')</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" v-model="reciever">
                                            <span></span>
                                        </span>
                                        <v-select class="vue-select2" v-model="selectedReciever" label="name" :options="simple_member" @search="SimpleMemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="reciever_id" :value="(!selectedReciever)?null:selectedReciever.id" >
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-8">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div> 
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.MonetarySource')</label>
                                    {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                </div>
                                <div class="col-md-2">
                                    <label class=" control-label">@lang('layout.Implemented')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="status" checked  value="off">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')1</label>
                                    {!! Form::textarea('description1', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div> 
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')2</label>
                                    {!! Form::textarea('description2', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div> 
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="dashboard-stat2" v-if="all_currency && gain_loss_status" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') -- @lang('layout.BaseCurrency') ( {!! getHomeCurrency()["code"] !!} )</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="crr in all_currency">
                                                    <span v-if="selectedCurrency">
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{(crr.rate)}} <input type="hidden" name="today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                    <span v-if="selectedCurrency && paymentCurrency">
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{(crr.rate)}}
                                                        </td>
                                                        <td v-if="paymentCurrency.code == crr.code" v-show="false">
                                                            <input type="hidden" name="ex_today_rate" :value="crr.rate" />
                                                        </td>
                                                    </span>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="dashboard-stat2" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="summ in summary">
                                                    <td>
                                                        @{{ summ.currency }}
                                                    </td>
                                                    <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                    <td>
                                                        @{{format_number(Number(summ.invoice)) }}
                                                    </td>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-8 text-center">
                            <br>
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                            <a href="{{route('cheque.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            <hr />
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect)
        var Banks ={!! $bank!!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        var memberClass = {!! $memberClass !!};
        let all_currency = {!!$currencies!!};
        let income = {!!$income!!};
        let company = {!!$company!!};
        var tree = {!! json_encode(Currency()->getCurrency()) !!};

        let vu = new Vue({
            el: '#app',
            data: {
                company:company,
                selected_company:null,
                branch_type: false,
                all_currency: all_currency,
                selectedCurrency: null,
                paymentCurrency: null,
                summary: [], 
                selectedCurrency2: tree,
                currency:[],
                currency1:[],
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:{!!$cheque->rate!!},
                selected_rate1: 1,
                exchange_amount : null,
                selected_rate2: 1,
                defaultAccount: "{{ $cheque->account_id }}",
                listAccounts: [],
                selectedMember:{!!$selectedMember!!},
                selectedSender: null,
                selectedReciever: null,
                amount_to_word: null,
                newAmount: null,
                amount:{!!$cheque->amount!!},
                Examount:0,
                selectedProject: null,
                project_list: [],
				selectedVehicleRent: null,
                vehicle_rent_list: [],
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                comcurrency_len: 'col-md-12',
                comrate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $cheque->type !!}",
                defaultValue: 0,
                defaultAmount:{!!$cheque->amount!!},
                defaultValue1: "{{ $cheque->commiss_acc_id }}",
                defaultAccount1: "{{ $cheque->commiss_acc_id }}",
                firstAccount: "{{ $cheque->account_id }}",
                ref_no: "{{$cheque->ref_no}}",
                chequeType: '{{$cheque->type}}',
                commission_type: '{{$cheque->commission_type}}',
                income: income,
                selectedIncome: null,
                sender: false,
                reciever: false,
                commiss_currency: false,
                gain_loss_status: false,
                msg: '',
                isError: false,
                payment_type: "{{$cheque->payment_type}}",
                cheque:{!! $cheque !!},
                member:[],
                old_payment_type:"{{$cheque->payment_type}}",
                summary: [],
                memberClass: memberClass,
                selected_class: null,
                simple_member: []
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                    this.defaultValue = test[0].id;

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    }else{
                        this.selectedBank = null;
                    }

                    return test;
                },

                accountUpdateComm() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency2.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                        this.defaultValue1 = test[0].id;
                    } else {
                        this.defaultValue1 = 0;
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue1 && z == 'id') {
                                this.defaultAccount1 = this.defaultValue1;
                                break;
                            }
                        }

                    }
                    return test;
                },

            },
            created() {
                this.checkSelected();
                if(this.cheque)
                {
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.cheque.class_id);

                    if (income && this.cheque.income_id) {
                        this.selectedIncome = _.find(income, (c) => c.id == this.cheque.income_id);
                    }
                    @if($selectedSender)
                    if (income && this.cheque.sender_id) {
                        this.selectedSender = {!! $selectedSender !!};
                        this.sender = true;
                    }
                    @endif
                    @if($selectedReciever)
                    if (income && this.cheque.reciever_id) {
                        this.selectedReciever = {!! $selectedReciever !!};
                        this.reciever = true;
                    }
                    @endif

                    if (this.cheque.branch_company_id) {
                        this.selected_company = _.find(this.company, (c) => c.id == this.cheque.branch_company_id);
                        this.branch_type = true;
                    }
                    if (this.cheque.commiss_currency) {
                        if ("{{ $cheque->commission_currency }}" != this.code) {
                            this.comcurrency_len = 'col-md-6';
                            this.comrate_len = 'col-md-6';
                        }
                        @if($cheque->commiss_rate)
                            this.selected_rate2 = {!!$cheque->commiss_rate!!};
                        @endif
                        this.commiss_currency = true;
                    }
                    if (this.cheque.gain_loss_status) {
                        this.gain_loss_status = true;
                    }
                    if (this.cheque.paymentCurrency) {
                        if ("{{ $cheque->paymentCurrency }}" != this.code) {
                            this.pcurrency_len = 'col-md-6';
                            this.prate_len = 'col-md-6';
                        }
                        @if($cheque->paymentRate)
                            this.selected_rate1 = {!!$cheque->paymentRate!!};
                        @endif
                    }
                }
                defaultValue = "{{ $cheque->account_id }}";

                if ("{{ $cheque->currency }}" == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                }
                else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }

                if(this.selected_rate > 0){
                    this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                }
				
                this.currency = all_currency;
                this.currency1 = all_currency;
                this.getTranslateToWord();
            },
            methods: {

                memberClassChange() {
                    if (vu.selected_class) {
                        vu.member = [];
                        // vu.selectedMember = null;
                        let class_id = vu.selected_class.id;
                    
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember',
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.member = [];
                                vu.member = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.member = [];
                            vu.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                SimpleMemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.simple_member = [];
                            vu.simple_member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                getSummary() {
                    if (vu.selectedMember) {
                        var id = vu.selectedMember.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'memberStatment',
                                    member_id: id,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    vu.summary = response.data;
                                } else {
                                    vu.summary = [];
                                }
                            })
                            .catch(function(error) {
                                vu.summary = [];
                                console.log(error);
                            });
                    }
                },

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getTranslateToWord() {
                    var vu = this;
                    vu.amount_to_word = null;
                    if (vu.amount) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'translateNumberToWord',
                                    amount: vu.amount,
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(132, response.data, vu.amount);
                                    vu.amount_to_word = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }
                },

                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $cheque->currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $cheque->commission_currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency2 = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }

                            if (allCarrencies[x][z] == "{!! $cheque->paymentCurrency !!}") {
                                if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];
                                // transactions.unit as paymentCurrency,
                                // transactions.rate as paymentRate,
                                // this.selected_rate1   = this.paymentCurrency.exchange_rate;

                            }
                        }
                    }

                },
                get_exchange() {
                    if (vu.selected_rate > 0) {
                        vu.exchange_amount = myRound((vu.amount * vu.selected_rate1) / vu.selected_rate);
                    }
                },
                set_rate() {
                    if (vu.paymentCurrency.code == vu.code) {
                        if (vu.exchange_amount > 0 && vu.amount > 0) {
                            vu.selected_rate = myRound((vu.amount) / (vu.exchange_amount));
                        }
                    } else {
                        if (vu.exchange_amount > 0) {
                            vu.selected_rate1 = myRound((vu.exchange_amount) / (vu.amount / vu.selected_rate));
                        }
                    }
                },
                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    } else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                setCommSize(selected_code) {
                    this.selected_rate2 = this.selectedCurrency2.exchange_rate;
                    if (selected_code == this.code) {
                        this.comcurrency_len = 'col-md-12';
                        this.comrate_len = 'col-md-0';
                    } else {
                        this.comcurrency_len = 'col-md-6';
                        this.comrate_len = 'col-md-6';
                    }
                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
            }
        });
    </script>


@endpush
 