@extends('layouts.app')
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ChequeEdit')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div> 
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($cheque, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['cheque.update',$cheque->id]]) !!}
                <div class="form-body  col-md-12" id="app" v-cloak>
                    <div class="row" style="margin-bottom: 20px;padding-bottom: 20px;">
                        <div class="col-lg-9 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-4">
                                    <div v-show="showWhat('member_class')=='yes'">
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <label class="control-label ">@lang('layout.BranchName') / @lang('layout.Customer')</label>
                                    <v-select class="vue-select2" v-model="selectedMember" @input="getSummary()" label="name" :options="member" @search="MemberSearch" >
                                    </v-select>
                                    <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                    <div class="md-radio-inline">
                                        <div class="md-radio">
                                            <input type="radio" id="radio1" name="type" v-model="chequeType" value="Receive" class="md-radiobtn">
                                            <label for="radio1">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('type.Receive') 
                                            </label>
                                        </div>
                                        <div class="md-radio">
                                            <input type="radio" id="radio2" name="type" v-model="chequeType" value="Send" class="md-radiobtn">
                                            <label for="radio2">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('type.Send') 
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$cheque->number}}">
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.ChequeNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-md-4" style="padding: 0px !important;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" :options="currency" @Click.native="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()" :readonly="averageRate">
                                            <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="row" style="padding: 0.5% 1%;">
                                        <div class="row" style="padding: 0.5% 2.5%;">
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Amount') <span style="color: red;">(@{{amount_to_word}})</span></label>
                                                <vue-numeric
                                                    class="form-control"
                                                    v-model="amount"
                                                    :max="99999999999999"
                                                    :currency="selectedCurrency.code"
                                                    :precision="precision()"
                                                    @input="get_exchange(), getTranslateToWord(),calculateCamition(), calculateCamitionTwo()"
                                                >
                                                </vue-numeric>
                                                <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                                <span class="required">@{{ errors.first('amount') }}</span>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Account')</label>
                                                <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                    <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                                    </option>
                                                </select>
                                            </div>
                                            <div class="col-md-4" v-if="!(sender && chequeType == 'Send')"  v-show="!(reciever && chequeType == 'Receive')">
                                                <span v-if="chequeType == 'Send'" v-show="false">
                                                    @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                                </span>
                                                <span v-else v-show="false">
                                                    @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                                </span>
                                                <label class="control-label">@lang('layout.Balance')</label>
                                                <!-- <div class="input-group"> -->
                                                    <input class="form-control" disabled :value="balance.toFixed(precision())">
                                                    <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div> -->
                                            </div>
                                        </div>
                                        <div class="row" style="padding: 0.5% 1%;">
                                            <div class="col-md-4">
                                                <div :class="pcurrency_len">
                                                    <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                                    <v-select v-model="paymentCurrency" label="code" :options="currency1" @Click.native="setPaymentSize(paymentCurrency.code), get_exchange()"> </v-select>
                                                    <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                                </div>
                                                <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                                    <label class="control-label">@lang('layout.Rate') </label>
                                                    <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                        <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()" :readonly="selectedCurrency.code==paymentCurrency.code">
                                                        <input type="hidden" name="rate" :value="selected_rate1">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                                <div class="input-group">
                                                    <vue-numeric
                                                        class="form-control"
                                                        v-model="exchange_amount"
                                                        :max="99999999999999"
                                                        :currency="paymentCurrency.code"
                                                        :precision="precision()"
                                                        @input="calculateCamition(), calculateCamitionTwo()"
                                                        @keyup.native="set_rate()" @click.native="set_rate()" 
                                                    >
                                                    </vue-numeric>
                                                    {{-- <input type="number" v-model="exchange_amount" @input="set_rate()" class="form-control" min="0" step="any"> --}}
                                                    <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(8)">
                                                    <span class="input-group-addon">
                                                        <input type="checkbox" name="gain_loss_status" v-model="gain_loss_status">
                                                        <span></span>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label" for="form_control">@lang('layout.TransactionType')</label>
                                                <div class="md-radio-inline">
                                                    <div class="md-radio" style="margin-right: 10px;">
                                                        <input type="radio" id="radio4" name="transaction_type" value="Local" class="md-radiobtn" @if($cheque->transaction_type == 'Local') checked="" @endif >
                                                        <label for="radio4">
                                                            <span class="inc"></span>
                                                            <span class="check"></span>
                                                            <span class="box"></span> @lang('layout.Local') </label>
                                                    </div>
                                                    <div class="md-radio" style="margin-right: 10px;">
                                                        <input type="radio" id="radio5" name="transaction_type" value="Foreign" class="md-radiobtn" @if($cheque->transaction_type == 'Foreign') checked="" @endif >
                                                        <label for="radio5">
                                                            <span class="inc"></span>
                                                            <span class="check"></span>
                                                            <span class="box"></span> @lang('layout.Foreign') </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" style="padding:0.5% 2.5%;">
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.Date')</label>
                                                {{Form::text('date',null,['class' => 'form-control date','id'=>'reg_date','autocomplete'=>'off'])}}
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label">@lang('layout.DueDate')</label>
                                                {{Form::text('due_date',null,['class' => 'form-control date','id'=>'dueDates','autocomplete'=>'off'])}}
                                            </div>
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.BranchTransfer')</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <input type="checkbox" name="branch_type" v-model="branch_type" value="on">
                                                        <span></span>
                                                    </span>
                                                    <v-select v-if="branch_type" label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                                    <input type="hidden" name="company_id" :value="(!selected_company)?null:selected_company.id" >
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4" v-if="!sender" >
                                            <label class="control-label">@lang('layout.Sender')</label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" v-model="sender">
                                                    <span></span>
                                                </span>
                                                <input type="text" class="form-control " value="{{$cheque->sender}}" autocomplete="off" name="sender">
                                            </div>
                                        </div>
                                        <div class="col-md-4" v-if="!sender" >
                                            <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                            <input type="text" class="form-control " value="{{$cheque->sen_ssn_number}}" autocomplete="off" name="sen_ssn_number">
                                        </div>
                                        <div class="col-md-4" v-if="!sender">
                                            <label class="control-label">@lang('layout.FatherName')</label>
                                            <input type="text" class="form-control" value="{{$cheque->sen_father_name}}" autocomplete="off" name="sen_father_name">
                                        </div>
                                        <div class="col-md-4" v-if="!sender">
                                            <label class="control-label">@lang('layout.Phone')</label>
                                            <input type="text" class="form-control" value="{{$cheque->sen_phone}}" autocomplete="off" name="sen_phone">
                                        </div>
                                        <div class="col-md-4" v-if="!sender">
                                            <label class="control-label">@lang('layout.Address')</label>
                                            <input type="text" class="form-control" value="{{$cheque->sen_address}}" autocomplete="off" name="sen_address">
                                        </div>
                                        <div class="col-md-4" v-if="sender">
                                            <label class="control-label ">@lang('layout.Sender')</label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" v-model="sender">
                                                    <span></span>
                                                </span>
                                                <v-select class="vue-select2" v-model="selectedSender" label="name" :options="simple_member" @search="SimpleMemberSearch" >
                                                </v-select>
                                                <input type="hidden" name="sender_id" :value="(!selectedSender)?null:selectedSender.id" >
                                            </div>
                                        </div>
                                        <div class="col-lg-4" style="padding: 0px !important;">
                                            <div class="col-lg-6">
                                                <label class=" control-label">@lang('layout.Implemented')</label>
                                                <div class="col-md-12 mt-checkbox">
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="status" <?php if($cheque->status == 'off'){echo 'checked';} ?> value="off">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                            @if(systemConfig()[29] == 1)
                                                <div class="col-lg-6">
                                                    <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline"> 
                                                            <input type="checkbox" name="transaction_confirm" v-model="show_transaction_confirm_checked" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                    <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-md-4" v-if="!reciever">
                                            <label class="control-label">@lang('layout.Reciever')</label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" v-model="reciever">
                                                    <span></span>
                                                </span>
                                                <input type="text" class="form-control " value="{{$cheque->reciever}}" autocomplete="off" name="reciever">
                                            </div>
                                        </div>
                                        <div class="col-lg-4" v-if="reciever">
                                            <label class="control-label ">@lang('layout.Reciever')</label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <input type="checkbox" v-model="reciever">
                                                    <span></span>
                                                </span>
                                                <v-select class="vue-select2" v-model="selectedReciever" label="name" :options="simple_member" @search="SimpleMemberSearch" @input="averageRate = false" >
                                                </v-select>
                                                <input type="hidden" name="reciever_id" :value="(!selectedReciever)?null:selectedReciever.id" >
                                            </div>
                                        </div>
                                        <div class="col-lg-4" v-if="!reciever" >
                                            <label class="control-label">@lang('layout.SSN') / @lang('layout.PassportNumber')</label>
                                            <input type="text" class="form-control " value="{{$cheque->rec_ssn_number}}" autocomplete="off" name="rec_ssn_number">
                                        </div>
                                        <div class="col-lg-4" v-if="!reciever">
                                            <label class="control-label">@lang('layout.FatherName')</label>
                                            <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_father_name}}" name="rec_father_name">
                                        </div>  
                                        <div class="col-lg-3" v-if="!reciever">
                                            <label class="control-label">@lang('layout.Phone')</label>
                                            <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_phone}}" name="rec_phone">
                                        </div>
                                        <div class="col-lg-3" v-if="!reciever">
                                            <label class="control-label">@lang('layout.Address')</label>
                                            <input type="text" class="form-control" autocomplete="off" value="{{$cheque->rec_address}}" name="rec_address">
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.MonetarySource')</label>
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.TransactionType')</label>
                                                {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="row" style="padding: 0.5% 1%;">
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Commission') &nbsp;&nbsp;&nbsp; <span class="btn " @click="commission2 = true">@lang('layout.More')....</span></label>
                                        <div class="input-group">
                                            <input type="number" name="commiss_amount" v-model="commission_amount" class="form-control">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="select_commiss_currency" v-model="commiss_currency" @Click="setCommSize(selectedCurrency2.code)" >
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-6" style="margin-top: 5px;">
                                        <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>  
                                        <input type="number" step="any" v-model="camition_percentage" @input="calculateCamition()" class="form-control" autocomplete="off" max="100" name="comm_percentage_one">
                                    </div>
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                        <div class="input-group" style="margin-top: .4em;">
                                            <select class="form-control" name="commission_type" v-model="commission_type">
                                                <option value="Simple">@lang('type.Simple')</option>
                                                <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                                <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                                <option value="FromSenderAccount">@lang('type.FromSenderAccount')</option>
                                            </select>
                                            <span class="input-group-addon" style="padding: 2px 4px;">
                                                <input type="checkbox" name="commiss_expense" v-model="commiss_expense">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency" style="padding: 0px !important;">
                                        <div :class="comcurrency_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency2" label="code" :options="currency" @Click.native="setCommSize(selectedCurrency2.code)"> </v-select>
                                            <input type="hidden" name="commiss_currency" v-bind:value="(selectedCurrency2)?selectedCurrency2.code:null" />
                                        </div>
                                        <div :class="comrate_len" v-if="selectedCurrency2.code != code">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selected_rate2" class="form-control" type="number" step="any" min="0">
                                            <input type="hidden" name="commiss_rate" :value="selected_rate2">
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency && commission_type != 'FromSenderAccount'" >
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="commiss_account_id" v-model="defaultAccount1">
                                            <option v-for="Account in accountUpdateComm" :value="Account.id">@{{ Account.name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type != 'BelongsToOtherBranch' && !commiss_expense" >
                                        <label class="control-label">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type != 'BelongsToOtherBranch' && commiss_expense" >
                                        <label class="control-label">@lang('layout.Expense')</label>
                                        <v-select class="vue-select2" v-model="selectedExpense" label="name" :options="expense">
                                        </v-select>
                                        <input type="hidden" name="expense_id" :value="(!selectedExpense)?null:selectedExpense.id" >
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" v-if="commission2 == true" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-top: 20px;">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Commission') </label>
                                        <div class="input-group">
                                            <input type="number" name="commiss_amount2" v-model="commission_amount2" class="form-control">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="select_commiss_currency2" v-model="commiss_currency2">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-6" style="margin-top: 5px;">
                                        <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                                        <input type="number" step="any" v-model="camition_percentageTwo" @input="calculateCamitionTwo()" class="form-control" autocomplete="off" max="100" name="comm_percentage_two">
                                    </div>
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="commission_type2" v-model="commission_type2">
                                                <option value="Simple">@lang('type.Simple')</option>
                                                <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                                <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                                <option value="FromSenderAccount">@lang('type.FromSenderAccount')</option>
                                            </select>
                                            <span class="input-group-addon" style="padding: 2px 4px;">
                                                <input type="checkbox" name="commiss_expense2" v-model="commiss_expense2">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency2" style="padding: 0px !important;">
                                        <div :class="comcurrency2_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency3" label="code" :options="currency" @Click.native="setCommSize2(selectedCurrency3.code)"> </v-select>
                                            <input type="hidden" name="commiss_currency2" v-bind:value="(selectedCurrency3)?selectedCurrency3.code:null" />
                                        </div>
                                        <div :class="comrate2_len" v-if="selectedCurrency3.code != code">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selected_rate3" class="form-control" type="number" step="any" min="0">
                                            <input type="hidden" name="commiss_rate2" :value="selected_rate3">
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency2 && commission_type2 != 'FromSenderAccount'" >
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="commiss_account2_id" v-model="defaultAccount2">
                                            <option v-for="Account in accountUpdateComm2" :value="Account.id">@{{ Account.name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type2 != 'BelongsToOtherBranch' && !commiss_expense2" >
                                        <label class="control-label">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome2" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income2_id" :value="(!selectedIncome2)?null:selectedIncome2.id" >
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type2 != 'BelongsToOtherBranch' && commiss_expense2" >
                                        <label class="control-label">@lang('layout.Expense')</label>
                                        <v-select class="vue-select2" v-model="selectedExpense2" label="name" :options="expense">
                                        </v-select>
                                        <input type="hidden" name="expense2_id" :value="(!selectedExpense2)?null:selectedExpense2.id" >
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" v-if="commission3 == true" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-top: 20px;">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <label class="control-label">@lang('layout.Commission') </label>
                                        <div class="input-group">
                                            <input type="number" name="commiss_amount3" v-model="commission_amount3" class="form-control">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="select_commiss_currency3" v-model="commiss_currency3">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-6" style="margin-top: 5px;">
                                        <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                                        <input type="number" step="any" v-model="camition_percentage3" @input="calculateCamition3()" class="form-control" autocomplete="off" max="100" name="comm_percentage3">
                                    </div>
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="commission_type3" v-model="commission_type3">
                                                <option value="Simple">@lang('type.Simple')</option>
                                                <option value="ReceiveByOtherBranch">@lang('type.ReceiveByOtherBranch')</option>
                                                <option value="BelongsToOtherBranch">@lang('type.BelongsToOtherBranch')</option>
                                                <option value="FromSenderAccount">@lang('type.FromSenderAccount')</option>
                                            </select>
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="commiss_expense3" v-model="commiss_expense3">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency3" style="padding: 0px !important;">
                                        <div :class="comcurrency3_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency4" label="code" :options="currency" @Click.native="setCommSize3(selectedCurrency4.code)"> </v-select>
                                            <input type="hidden" name="commiss_currency3" v-bind:value="(selectedCurrency4)?selectedCurrency4.code:null" />
                                        </div>
                                        <div :class="comrate3_len" v-if="selectedCurrency4.code != code">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selected_rate4" class="form-control" type="number" step="any" min="0">
                                            <input type="hidden" name="commiss_rate3" :value="selected_rate4">
                                        </div>
                                    </div>
                                    <div class="col-lg-12" v-if="commiss_currency3 && commission_type3 != 'FromSenderAccount'" >
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="commiss_account3_id" v-model="defaultAccount3">
                                            <option v-for="Account in accountUpdateComm3" :value="Account.id">@{{ Account.name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type3 != 'BelongsToOtherBranch' && !commiss_expense3" >
                                        <label class="control-label">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome3" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income3_id" :value="(!selectedIncome3)?null:selectedIncome3.id" >
                                    </div>
                                    <div class="col-lg-12" v-if="commission_type3 != 'BelongsToOtherBranch' && commiss_expense3" >
                                        <label class="control-label">@lang('layout.Expense')</label>
                                        <v-select class="vue-select2" v-model="selectedExpense3" label="name" :options="expense">
                                        </v-select>
                                        <input type="hidden" name="expense3_id" :value="(!selectedExpense3)?null:selectedExpense3.id" >
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-top: 20px; padding-bottom: 20px;">
                                <div class="col-lg-12">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div> 
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')1</label>
                                        {!! Form::textarea('description1', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div> 
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')2</label>
                                        {!! Form::textarea('description2', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div>
                                </div> 
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; margin-top: 20px; padding-bottom: 20px;">
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="all_currency && gain_loss_status" style="margin-bottom: 10px; padding-bottom: 5px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);">
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') -- @lang('layout.BaseCurrency') ( {!! getHomeCurrency()["code"] !!} )</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="crr in all_currency">
                                                        <span v-if="selectedCurrency">
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{(crr.rate)}} <input type="hidden" name="today_rate" :value="crr.rate" />
                                                            </td>
                                                        </span>
                                                        <span v-if="selectedCurrency && paymentCurrency">
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{(crr.rate)}}
                                                            </td>
                                                            <td v-if="paymentCurrency.code == crr.code" v-show="false">
                                                                <input type="hidden" name="ex_today_rate" :value="crr.rate" />
                                                            </td>
                                                        </span>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);" >
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                    <th class="text-center" style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                    <th class="text-center" style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                                    <th class="text-center" style="background-color: #add8e6;">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="summ in summary">
                                                        <td class="text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                        <br/>
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th style="background-color: #add8e6;text-align: center;" v-if="selectedMember.risk_step">
                                                        @lang('layout.RiskStep')
                                                    </th>
                                                    <th v-if="selectedMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                    <th v-if="selectedMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                    <th v-if="selectedMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                </tr>
                                            </thead>
                                        </table>    
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                                <br>
                                <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                                <a href="{{route('cheque.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                <hr />
                            </div>
                        </div>
                    </div>

                    
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')

    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);

        var Banks ={!! $bank!!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        var two = {!! json_encode(getHomeCurrency()) !!};
        var memberClass = {!! $memberClass !!};
        let all_currency = {!!$currencies!!};
        let income = {!!$income!!};
        let expense = {!!$expense!!};
        let company = {!!$company!!};
        let cheque = {!!json_encode($cheque)!!};
        var tree = {!! json_encode(getHomeCurrency()) !!};

        let vu = new Vue({
            el: '#app',
            data: {
                company:company,
                selected_company:null,
                editKey: false,
                averageRate: false,
                branch_type: false,
                all_currency: all_currency,
                selectedCurrency: null,
                paymentCurrency: two,
                summary: [], 
                selectedCurrency2: tree,
                selectedCurrency3: tree,
                selectedCurrency4: tree,
                currency:[],
                currency1:[],
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:1,
                selected_rate1: 1,
                exchange_amount : null,
                selected_rate2: 1,
                selected_rate3: 1,
                defaultAccount: "{{ $cheque->account_id }}",
                show_transaction_confirm_checked: "{{$cheque->transaction_confirm == 'On'}}",
                listAccounts: [],
                selectedMember:{!!$selectedMember!!},
                selectedSender: null,
                selectedReciever: null,
                amount_to_word: null,
                newAmount: null,
                amount:0,
                Examount:0,
                selectedProject: null,
                project_list: [],
				selectedVehicleRent: null,
                vehicle_rent_list: [],
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                comcurrency_len: 'col-md-12',
                comrate_len: 'col-md-0',
                comcurrency2_len: 'col-md-12',
                comrate2_len: 'col-md-0',
                comcurrency3_len: 'col-md-12',
                comrate3_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $cheque->type !!}",
                defaultValue: 0,
                defaultAmount:0,
                defaultValue1: "{{ $cheque->commiss_acc_id }}",
                defaultAccount1: "{{ $cheque->commiss_acc_id }}",
                defaultValue2: "{{ $cheque->commiss_acc2_id }}",
                defaultValue3: "{{ $cheque->commiss_acc3_id }}",
                defaultAccount2: "{{ $cheque->commiss_acc2_id }}",
                defaultAccount3: "{{ $cheque->commiss_acc3_id }}",
                firstAccount: "{{ $cheque->account_id }}",
                ref_no: "{{$cheque->ref_no}}",
                chequeType: '{{$cheque->type}}',
                commission_type: '{{$cheque->commission_type}}',
                commission_type2: '{{$cheque->commission_type2}}',
                commission_type3: '{{$cheque->commission_type3}}',
                income: income,
                selectedIncome: null,
                selectedIncome2: null,
                selectedIncome3: null,
                expense: expense,
                selectedExpense: null,
                selectedExpense2: null,
                selectedExpense3: null,
                commiss_expense: false,
                commiss_expense2: false,
                commiss_expense3: false,
                sender: false,
                reciever: false,
                commiss_currency: false,
                commiss_currency2: false,
                commiss_currency3: false,
                gain_loss_status: false,
                commission2: false,
                commission3: false,
                msg: '',
                isError: false,
                payment_type: "{{$cheque->payment_type}}",
                cheque:{!! $cheque !!},
                member:[],
                old_payment_type:"{{$cheque->payment_type}}",
                summary: [],
                memberClass: memberClass,
                selected_class: null,
                simple_member: [],
                camition_percentage: '',
                commission_amount: '' , 
                camition_percentageTwo: '',
                camition_percentage3: '',
                commiss_amount2: '' , 
                commiss_amount3: '' , 
                commission_amount: '' , 
                commission_amount2: '', 
                commission_amount3: ''
            },
            computed: {
                accountUpdate() {
                    this.averageRate = false;
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                    this.defaultValue = test[0].id;

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    
                                    // @if(getAverageRate() =="true")
                                    // if (this.bankes[x].avg_rate && this.chequeType == "Receive") {
                                    //     this.set_avg_rate(this.bankes[x].avg_rate);
                                    // }
                                    // @endif
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;

                                // @if(getAverageRate() =="true")
                                // if (this.bankes[x].avg_rate && this.chequeType == "Receive") {
                                //     this.set_avg_rate(this.bankes[x].avg_rate);
                                // }
                                // @endif
                                break;
                            }
                        }

                    }
                    }else{
                        this.selectedBank = null;
                    }

                    return test;
                },

                accountUpdateComm() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency2.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0 && !this.defaultValue1) {
                        this.defaultValue1 = test[0].id;
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue1 && z == 'id') {
                                this.defaultAccount1 = this.defaultValue1;
                                break;
                            }
                        }

                    }
                    this.defaultValue1 = 0;
                    return test;
                },
                accountUpdateComm2() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency3.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0 && !this.defaultValue2) {
                        this.defaultValue2 = test[0].id;
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue2 && z == 'id') {
                                this.defaultAccount2 = this.defaultValue2;
                                break;
                            }
                        }
                    }
                    this.defaultValue2 = 0;
                    return test;
                },
                accountUpdateComm3() {
                    var b = _.clone(Banks)
                    var test = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency4.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0 && !this.defaultValue3) {
                        this.defaultValue3 = test[0].id;
                    }
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue3 && z == 'id') {
                                this.defaultAccount3 = this.defaultValue3;
                                break;
                            }
                        }
                    }
                    this.defaultValue3 = 0;
                    return test;
                },

            },
            created() {
                this.checkSelected();
                if(this.cheque)
                {
                    @if($cheque->amount)
                        this.amount = {!!$cheque->amount!!};
                        this.defaultAmount = {!!$cheque->amount!!};
                    @endif

                    @if($cheque->rate > 0)
                        this.selected_rate    = {!!$cheque->rate!!};
                    @endif

                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.cheque.class_id);

                    if (income && this.cheque.income_id) {
                        this.selectedIncome = _.find(income, (c) => c.id == this.cheque.income_id);
                    }

                    if (income && this.cheque.income2_id) {
                        this.selectedIncome2 = _.find(income, (c) => c.id == this.cheque.income2_id);
                    }

                    if (income && this.cheque.income3_id) {
                        this.selectedIncome3 = _.find(income, (c) => c.id == this.cheque.income3_id);
                    }

                    if (expense && this.cheque.income_id && this.cheque.commiss_expense) {
                        this.selectedExpense = _.find(expense, (c) => c.id == this.cheque.income_id);
                    }

                    if (expense && this.cheque.income2_id && this.cheque.commiss_expense2) {
                        this.selectedExpense2 = _.find(expense, (c) => c.id == this.cheque.income2_id);
                    }

                    if (expense && this.cheque.income3_id && this.cheque.commiss_expense3) {
                        this.selectedExpense3 = _.find(expense, (c) => c.id == this.cheque.income3_id);
                    }

                    @if($selectedSender)
                    if (income && this.cheque.sender_id) {
                        this.selectedSender = {!! $selectedSender !!};
                        this.sender = true;
                    }
                    @endif
                    @if($selectedReciever)
                    if (income && this.cheque.reciever_id) {
                        this.selectedReciever = {!! $selectedReciever !!};
                        this.reciever = true;
                    }
                    @endif

                    @if($cheque->commission_type2)
                        this.commission2 = true;
                        @if($cheque->commiss_expense2)
                            this.commiss_expense2 = true;
                        @endif
                    @endif

                    @if($cheque->commission_type3)
                        this.commission3 = true;
                        @if($cheque->commiss_expense3)
                            this.commiss_expense3 = true;
                        @endif
                    @endif

                    @if($cheque->commiss_expense)
                        this.commiss_expense = true;
                    @endif

                    if (this.cheque.branch_company_id) {
                        this.selected_company = _.find(this.company, (c) => c.id == this.cheque.branch_company_id);
                        this.branch_type = true;
                    }
                    if (this.cheque.commiss_currency) {
                        if ("{{ $cheque->commission_currency }}" != this.code) {
                            this.comcurrency_len = 'col-md-6';
                            this.comrate_len = 'col-md-6';
                        }
                        @if($cheque->commiss_rate)
                            this.selected_rate2 = {!!$cheque->commiss_rate!!};
                        @endif
                        this.commiss_currency = true;
                    }
                    if (this.cheque.commiss_currency2) {
                        if ("{{ $cheque->commission_currency2 }}" != this.code) {
                            this.comcurrency2_len = 'col-md-6';
                            this.comrate2_len = 'col-md-6';
                        }
                        @if($cheque->commiss_rate2)
                            this.selected_rate3 = {!!$cheque->commiss_rate2!!};
                        @endif
                        this.commiss_currency2 = true;
                    }
                    if (this.cheque.commiss_currency3) {
                        if ("{{ $cheque->commission_currency3 }}" != this.code) {
                            this.comcurrency3_len = 'col-md-6';
                            this.comrate3_len = 'col-md-6';
                        }
                        @if($cheque->commiss_rate3)
                            this.selected_rate4 = {!!$cheque->commiss_rate3!!};
                        @endif
                        this.commiss_currency3 = true;
                    }
                    if (this.cheque.gain_loss_status) {
                        this.gain_loss_status = true;
                    }
                    if (this.cheque.paymentCurrency) {
                        if ("{{ $cheque->paymentCurrency }}" != this.code) {
                            this.pcurrency_len = 'col-md-6';
                            this.prate_len = 'col-md-6';
                        }
                        @if($cheque->paymentRate)
                            this.selected_rate1 = {!!$cheque->paymentRate!!};
                        @endif
                    }
                }
                defaultValue = "{{ $cheque->account_id }}";

                if ("{{ $cheque->currency }}" == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                }
                else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }

                if(this.selected_rate > 0){
                    @if(systemConfig()[30] == 1)
                    // this.exchange_amount = myRound((this.amount / this.selected_rate1)/this.selected_rate);
                    this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                    @else 
                    this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                    @endif
                }

                this.currency = all_currency;
                this.currency1 = all_currency;
                this.getTranslateToWord();

                @if($cheque->comm_percentage_one)
                 this.camition_percentage = {{$cheque->comm_percentage_one}}
                @endif

                @if($cheque->comm_percentage_two)
                 this.camition_percentageTwo = {{$cheque->comm_percentage_two}}
                @endif

                @if($cheque->comm_percentage3)
                 this.camition_percentage3 = {{$cheque->comm_percentage3}}
                @endif

                @if($cheque->commission_amount)
                 this.commission_amount = {{$cheque->commission_amount}};
                @endif
                 
                @if($cheque->commission_amount2)
                 this.commission_amount2 = {{$cheque->commission_amount2}};
                @endif

                @if($cheque->commission_amount3)
                 this.commission_amount3 = {{$cheque->commission_amount3}};
                @endif

            },
            methods: { 
                calculateCamition(){ 
                    var camition_percentage = this.camition_percentage;
                    var amount = this.amount;
                    if (camition_percentage && amount) {
                        this.commission_amount = (camition_percentage * amount) / 100;
                    } else{
                        this.commission_amount = this.commission_amount;
                    }
                },
                calculateCamitionTwo(){
                    var camition_percentageTwo = this.camition_percentageTwo;
                    var amount = this.amount;
                    if (camition_percentageTwo && amount) {
                        this.commission_amount2 = (camition_percentageTwo * amount) / 100;
                    } else{
                        this.commission_amount2 = this.commission_amount2;
                    }
                },
                calculateCamition3(){
                    var camition_percentage3 = this.camition_percentage3;
                    var amount = this.amount;
                    if (camition_percentage3 && amount) {
                        this.commission_amount3 = (camition_percentage3 * amount) / 100;
                    } else{
                        this.commission_amount3 = this.commission_amount3;
                    }
                },
                
                memberClassChange() {
                    if (vu.selected_class) {
                        vu.member = [];
                        // vu.selectedMember = null;
                        let class_id = vu.selected_class.id;
                    
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember',
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.member = [];
                                vu.member = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.member = [];
                            vu.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                SimpleMemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.simple_member = [];
                            vu.simple_member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                getSummary() {
                    if (vu.selectedMember) {
                        var id = vu.selectedMember.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'memberStatment',
                                    member_id: id,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    vu.summary = response.data;
                                } else {
                                    vu.summary = [];
                                }
                            })
                            .catch(function(error) {
                                vu.summary = [];
                                console.log(error);
                            });
                    }
                },

                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                getTranslateToWord() {
                    var vu = this;
                    vu.amount_to_word = null;
                    if (vu.amount) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'translateNumberToWord',
                                    amount: vu.amount,
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    // console.log(132, response.data, vu.amount);
                                    vu.amount_to_word = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }
                },

                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $cheque->currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                                @if(!$cheque->rate)
                                    this.selected_rate    = this.selectedCurrency.exchange_rate;
                                @endif

                            }
                            if (allCarrencies[x][z] == "{!! $cheque->commission_currency !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.comcurrency_len = 'col-md-6';
                                    this.comrate_len = 'col-md-6';
                                }
                                this.selectedCurrency2 = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $cheque->commission_currency2 !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.comcurrency2_len = 'col-md-6';
                                    this.comrate2_len = 'col-md-6';
                                }
                                this.selectedCurrency3 = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $cheque->commission_currency3 !!}") {
                                if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                    this.comcurrency3_len = 'col-md-6';
                                    this.comrate3_len = 'col-md-6';
                                }
                                this.selectedCurrency4 = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }

                            if (allCarrencies[x][z] == "{!! $cheque->paymentCurrency !!}") {
                                if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];
                                // transactions.unit as paymentCurrency,
                                // transactions.rate as paymentRate,
                                @if(!$cheque->paymentRate)
                                    this.selected_rate1   = this.paymentCurrency.exchange_rate;
                                @endif

                            }
                        }
                    }

                },
                // get_exchange() {
                //     let vu = this;
                //     if (vu.selected_rate > 0) {
                //         vu.exchange_amount = myRound((vu.amount * vu.selected_rate1) / vu.selected_rate);
                //     }
                // },

                get_exchange() {
                var vv = this;
                if (vv.selected_rate > 0) {
                    @if(systemConfig()[30] == 1)
                    if (vv.paymentCurrency && vv.selectedCurrency) { 
                        vv.exchange_amount = myRound(((vv.amount / vv.selectedCurrency.static_rate * vv.selected_rate) * vv.paymentCurrency.static_rate) / vv.selected_rate1);
                        // console.log(vv.exchange_amount);
                    }
                    @else 
                        vv.exchange_amount = myRound((vv.amount * vv.selected_rate1) / vv.selected_rate);
                    @endif
                }  
            },




                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                }, 

            set_rate() { 
            let vm = this; 
            if (vm.paymentCurrency.code == vm.selectedCurrency.code) {
                if (vm.exchange_amount > 0 && vm.amount > 0) {
                    vm.amount = myRound(vm.exchange_amount);
                }
            } else if (vm.paymentCurrency.code == vm.code && !vm.gain_loss_status && !vm.averageRate) {
                if (vm.exchange_amount > 0 && vm.amount > 0) {
                    @if(systemConfig()[30] == 1)
                        vm.selected_rate = Number.parseFloat((vm.exchange_amount / vm.amount) * vm.selectedCurrency.static_rate).toFixed(7);
                        @else
                        vm.selected_rate = Number.parseFloat((vm.amount) / (vm.exchange_amount)).toFixed(7);
                    @endif
                }
            }
            else {
                if (vm.exchange_amount > 0) {
                    @if(systemConfig()[30] == 1)
                        if (vm.gain_loss_status && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound(((vm.exchange_amount / vm.paymentCurrency.static_rate * vm.selected_rate1) * vm.selectedCurrency.static_rate) / vm.selected_rate);
                        } else {
                            vm.selected_rate1 = Number.parseFloat(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) / vm.exchange_amount) * vm.paymentCurrency.static_rate).toFixed(7);
                        }
                    @else
                        if (vm.gain_loss_status && vm.selected_rate1 > 0 && vm.selected_rate > 0) {
                            vm.amount = myRound((vm.exchange_amount / vm.selected_rate1) * (vm.selected_rate));
                        } else {
                            vm.selected_rate1 = Number.parseFloat((vm.exchange_amount) / (vm.amount / vm.selected_rate)).toFixed(7);
                        }
                    @endif
                }
            }
            },

                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    this.averageRate = false;
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    } else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }

                    // @if(getAverageRate() =="true")
                    // if (this.selectedBank.avg_rate && this.chequeType == "Receive" && !this.selectedReciever) {
                    //     this.averageRate = true;
                    //     this.selected_rate = this.selectedBank.avg_rate;
                    //     if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    //         this.selected_rate1 = this.selectedBank.avg_rate;
                    //     }
                    // }
                    // @endif

                },
                setCommSize(selected_code) {
                    this.selected_rate2 = this.selectedCurrency2.exchange_rate;
                    if (selected_code == this.code) {
                        this.comcurrency_len = 'col-md-12';
                        this.comrate_len = 'col-md-0';
                    } else {
                        this.comcurrency_len = 'col-md-6';
                        this.comrate_len = 'col-md-6';
                    }
                },
                setCommSize2(selected_code) {
                    this.selected_rate3 = this.selectedCurrency3.exchange_rate;
                    // console.log(3233, this.selectedCurrency3.exchange_rate);
                    if (selected_code == this.code) {
                        this.comcurrency2_len = 'col-md-12';
                        this.comrate2_len = 'col-md-0';
                    } else {
                        this.comcurrency2_len = 'col-md-6';
                        this.comrate2_len = 'col-md-6';
                    }
                },
                setCommSize3(selected_code) {
                    // console.log(32, this.selectedCurrency4.exchange_rate);
                    this.selected_rate4 = this.selectedCurrency4.exchange_rate;
                    if (selected_code == this.code) {
                        this.comcurrency3_len = 'col-md-12';
                        this.comrate3_len = 'col-md-0';
                    } else {
                        this.comcurrency3_len = 'col-md-6';
                        this.comrate3_len = 'col-md-6';
                    }
                },
                test(defaultAccount) {
                    this.averageRate = false;
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];

                                // @if(getAverageRate() =="true")
                                // if (this.bankes[x].avg_rate && this.chequeType == "Receive" && !this.selectedReciever) {
                                //     this.averageRate = true;
                                //     this.selected_rate = this.bankes[x].avg_rate;
                                //     if (this.paymentCurrency.code == this.selectedCurrency.code) {
                                //         this.selected_rate1 = this.bankes[x].avg_rate;
                                //     }
                                // }
                                // @endif

                                break;
                            }
                        }
                    }
                },

                set_avg_rate(avg_rate) {
                    setTimeout(() => {
                        if (!this.selectedReciever) {
                            this.averageRate = true;
                        }
                    }, 300);
                },

            }
        });
    </script>


@endpush
 