@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('cheque_index');
$_type = !in_array('type', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_description1 = !in_array('description1', $report);
$_description2 = !in_array('description2', $report);
$_member = !in_array('member', $report);
$_account = !in_array('account', $report);
$_amount = !in_array('amount', $report);
// $_currency = !in_array('currency', $report);
$_rate = !in_array('rate', $report);
$_reference_number = !in_array('reference_number', $report);
$_total = !in_array('total', $report);
$_sender = !in_array('sender', $report);
$_reciever = !in_array('reciever', $report);
$_SSN = !in_array('SSN', $report);
$_commission = !in_array('commission', $report);
$_dueDate = !in_array('dueDate', $report);

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ChequeReport')</h3>
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center">#</div>
      </td>
      <td>
        <div class="center">@lang('layout.No')</div>
      </td>
      @if($_reference_number)
      <td>
        <div class="center">@lang('layout.ReferenceNumber')</div>
      </td>@endif
      <td>
        <div class="center"> @lang('layout.FromCompany')</div>
      </td>
      @if($_type)<td>
        <div class="center"> @lang('layout.Type')</div>
      </td>@endif
      @if($_type)<td>
        <div class="center"> @lang('layout.Status')</div>
      </td>@endif
      @if($_member)<td>
        <div class="center"> @lang('layout.Member') </div>
      </td>@endif
      @if($_account)<td>
        <div class="center"> @lang('layout.Account')</div>
      </td>@endif
      @if($_amount)<td>
        <div class="center"> @lang('layout.Amount')</div>
      </td>@endif
      @if($_rate)
      <td>
        <div class="center"> @lang('layout.Rate')</div>
      </td>
      @endif
      @if($_sender)
      <td>
        <div class="center"> @lang('layout.Sender')</div>
      </td>
      @endif
      @if($_SSN)
      <td>
        <div class="center"> @lang('layout.IDNumber')</div>
      </td>
      @endif
      @if($_reciever)
      <td>
        <div class="center"> @lang('layout.Reciever')</div>
      </td>
      @endif
      @if($_SSN)
      <td>
        <div class="center"> @lang('layout.IDNumber')</div>
      </td>
      @endif
      @if($_date)<td>
        <div class="center"> @lang('layout.Date')</div>
      </td>@endif
      @if($_dueDate)
      <td>
        <div class="center"> @lang('layout.DueDate')</div>
      </td>
      @endif
      <td>
        <div class="center"> @lang('layout.User')</div>
      </td>
      @if($_description)<td>
        <div class="center"> @lang('layout.Description')</div>
      </td>@endif
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency_in = 0;
  $total_home_currency_out = 0;
  $total_profitAndLost = 0;
  $currencyIn = [];
  $currencyOut = [];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
    // if ($record->commission_rate > 0) {
    //   $total_profitAndLost += ($record->commission_amount / $record->commission_rate);
    // }
    if ($record->type == 'Receive') {
      if(systemConfig()[30] == 1){
        $total_home_currency_in += ($record->amount / $record->static_rate * $record->rate);
      }else{
        $total_home_currency_in += ($record->amount / $record->rate);
      }
      if (array_key_exists($record->currency, $currencyIn)) {
        $currencyIn[$record->currency] = $currencyIn[$record->currency] + $record->amount;
      } else {
        $currencyIn[$record->currency] = $record->amount;
      }
    }

    if ($record->type == 'Send') {
      if(systemConfig()[30] == 1){
        $total_home_currency_out += ($record->amount / $record->static_rate * $record->rate);
      }else{
        $total_home_currency_out += ($record->amount / $record->rate);
      }
      if (array_key_exists($record->currency, $currencyOut)) {
        $currencyOut[$record->currency] = $currencyOut[$record->currency] + $record->amount;
      } else {
        $currencyOut[$record->currency] = $record->amount;
      }
    }
    ?>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    @if($_reference_number)<td class="center">{{$record->ref_no}}</td>@endif
    <td class="center">{{ $record->from_company }}</td>
    @if($_type)<td class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif
    @if($_type)<td class="center">
      @if($record->status == 'on')
      @lang('layout.NotImplemented')
      @else
      @lang('layout.Implemented')
      @endif
    </td>@endif
    @if($_member)<td class="center">{{$record->Member}}</td>@endif
    @if($_account)<td class="center">{{$record->Account}}</td>@endif
    @if($_amount)<td class="center"> {{simpleRound($record->amount)}} {{$record->currency}} </td>@endif
    @if($_rate)<td class="center">{{simpleRound($record->rate)}}</td>@endif
    @if($_sender)<td class="center">{{$record->sender}}</td>@endif
    @if($_SSN)<td class="center">{{$record->sen_ssn_number}}</td>@endif
    @if($_reciever)<td class="center">{{$record->reciever}}</td>@endif
    @if($_SSN)<td class="center">{{$record->rec_ssn_number}}</td>@endif
    @if($_date)<td class="center"> {{convertDate($record->date)}} </td>@endif
    @if($_dueDate)<td class="center">{{ convertDate($record->due_date) }}</td>@endif
    <td class="center">{{$record->username}}</td>
    @if($_description)<td class="center"> 
      @if(isset($report_format))
      {{$record->description}}
      @else
      {!! wordwrap($record->description,40,"<br/>\n",false) !!}
      @endif 
    </td>@endif
  </tr>
  @endforeach
</table>
@if($_total)
@if($currencyIn)
<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.Total') @lang('layout.Receive')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> #</div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
  $count = 0;
  foreach ($currencyIn as $key => $currency) {
  ?>
    <tr>
      <td>
        <div class="center">{{++$count}}</div>
      </td>
      <td>
        <div class="center">{{$key}}</div>
      </td>
      <td>
        <div class="center">{{simpleRound($currency)}}</div>
      </td>

    </tr>
  <?php
  }
  ?>
</table>
@endif

@if($currencyOut)
<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.Total') @lang('layout.Send')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> #</div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
  $count = 0;
  foreach ($currencyOut as $key => $currency) {
  ?>
    <tr>
      <td>
        <div class="center">{{++$count}}</div>
      </td>
      <td>
        <div class="center">{{$key}}</div>
      </td>
      <td>
        <div class="center">{{simpleRound($currency)}}</div>
      </td>

    </tr>
  <?php
  }
  ?>
</table>
@endif

<table class="main-table">
  <tr class="bg">
    <td colspan="2">
      <div class="center">@lang('layout.Total')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Receive') : {{simpleRound($total_home_currency_in)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
    <td>
      <div class="center"> @lang('layout.Send') : {{simpleRound($total_home_currency_out)}}  {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
  </tr>
</table>
@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection