@extends('layouts.app')
@section('style')

@endsection

@section('content') 


<div class="row">
    <div class="col-md-6 col-sm-6">



        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-signal font-green" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.SaleComparisonReportForCustomeres')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                 <canvas id="canvas" height="280" width="600"></canvas>
                  
            </div>
        </div>
    </div>
       <div class="col-md-6 col-sm-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-sort-amount-desc font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.SaleComparisonReportForCustomeres')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                <canvas id="canvas_min" height="280" width="600"></canvas>
            
            </div>
        </div>
    </div>
    </div>

    <div class="row">

       <div class="col-md-6 col-sm-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.MaxSaleItem')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
            <canvas id="canvas_max_sale_item" height="280" width="600"></canvas>
            </div>
        </div>
    </div>


        <div class="col-md-6 col-sm-6">



        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-pie-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.MinSaleItem')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                 <canvas id="canvas_min_sale_item" height="280" width="600"></canvas>
                 
                  
            </div>
        </div>
    </div>
    </div>    



    <div class="row">
        <div class="col-md-6 col-sm-6">



        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-pie-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.IncomeAndExpense')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                 <canvas id="canvas_income_expense" height="280" width="600"></canvas>
                  
            </div>
        </div>
    </div>
       <div class="col-md-6 col-sm-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.TotalIncomeAndExpense')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                <canvas id="canvas_total_income_expense" height="280" width="600"></canvas>
            </div>
        </div>
    </div>
    </div>    


    <div class="row">
    <div class="col-md-6 col-sm-6">



        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-pie-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.TodayIncomeAndExpense')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                 
                </div>
            </div>
            <div class="portlet-body">
                 <canvas id="canvas_today_income_expense" height="280" width="600"></canvas>
                 

                  
            </div>
        </div>
    </div>
       <div class="col-md-6 col-sm-6">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.TotalIncomeAndExpense')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    <div id="test-chart">
                        <input type="text" class="form-control">
                       </div>
                </div>
            </div>
            <div class="portlet-body">
            </div>
        </div>
    </div>
    </div>



@endsection

@push('scripts')
<script src="{{ asset('chart/Chart.bundle.js') }}"></script>

<script>

let test = new Vue({
        el:'#test-chart',
        data:{
            chart:null,
            dates:[],
            label:[],
            color:[],

        },
        mounted(){
            this.getInventory();
        },
        methods: { 
            getData: function() {



               axios.get("{{route('home.index')}}")
                    .then(function (response) {

                        console.log('daaaaaaaaaaa',response);
                        this.dates = response.data.map(list=>{
                            return list.dt_txt;
                        }) 
                        this.color = response.data.map(list=>{
                            return list.dt_txt;
                        })
						
                    })
                    .catch(function (error) {
                    });

                var ctx = document.getElementById("test_chart");
                this.chart = new Chart(ctx, {
                    type: 'polarArea',
                    data: {
                        labels:this.dates
                    },
                    options: {
                        elements: {
                            rectangle: {
                                borderWidth: 2,
                                borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: false,
                            text: '@lang("layout.SaleComparisonReportForCustomeres")'
                        }
                    }
                });
            },

            }
        }); 


    var label =<?php echo $labelName; ?>;
    var color =<?php echo $color; ?>;
    var data_customer = <?php echo $customer; ?>;

    var barChartData = {
        labels: label,
        datasets: [{
            backgroundColor: color,
            data: data_customer
        }],
    };


    //Min Sale Customer

    var min_label =<?php echo $minSalesCustomerLabel; ?>;
    var min_color =<?php echo $minSalesCustomerColor; ?>;
    var data_min_customer = <?php echo $minSalesCustomer; ?>;

    var minSaleChartData = {
        labels: min_label,
        datasets: [{
            backgroundColor: min_color,
            data: data_min_customer
        }],
    };


    //Income And Expense

    var incomeExpense_label =<?php echo $incomeExpenseLabel; ?>;
    var incomeExpense_color =<?php echo $incomeExpenseColor; ?>;
    var data_income_expense = <?php echo $incomeExpense; ?>;

    var incomeExpenseChartData = {
        labels: incomeExpense_label,
        datasets: [{
            backgroundColor: incomeExpense_color,
            data: data_income_expense
        }],
    };


    //Max Sale Item

    var maxSaleItem_label =<?php echo $maxSaleItemLabel; ?>;
    var maxSaleItem_color =<?php echo $maxSaleItemColor; ?>;
    var data_maxSaleItem = <?php echo $maxSaleItem; ?>;

    var maxSaleItemChartData = {
        labels: maxSaleItem_label,
        datasets: [{
            backgroundColor: maxSaleItem_color,
            data: data_maxSaleItem
        }],
    };    

    //Min Sale Item

    var minSaleItem_label =<?php echo $minSaleItemLabel; ?>;
    var minSaleItem_color =<?php echo $minSaleItemColor; ?>;
    var data_minSaleItem = <?php echo $minSaleItem; ?>;

    var minSaleItemChartData = {
        labels: minSaleItem_label,
        datasets: [{
            backgroundColor: minSaleItem_color,
            data: data_minSaleItem
        }],
    };


    //Total Income And Expense

    var totalIncomeExpense_label =<?php echo $totalIncomeExpenseLabel; ?>;
    var totalIncomeExpense_color =<?php echo $totalIncomeExpenseColor; ?>;
    var data_totalIncome_expense = <?php echo $totalIncomeExpense; ?>;

    var totalIncomeExpenseChartData = {
        labels: totalIncomeExpense_label,
        datasets: [{
            backgroundColor: totalIncomeExpense_color,
            data: data_totalIncome_expense
        }],
    };    

    //today Income And Expense

    var todayIncomeExpense_label =<?php echo $todayIncomeExpenseLabel; ?>;
    var todayIncomeExpense_color =<?php echo $todayIncomeExpenseColor; ?>;
    var data_todayIncome_expense = <?php echo $todayIncomeExpense; ?>;

    var todayIncomeExpenseChartData = {
        labels: todayIncomeExpense_label,
        datasets: [{
            backgroundColor: todayIncomeExpense_color,
            data: data_todayIncome_expense
        }],
    };




    window.onload = function() {
       
        var ctx = document.getElementById("canvas").getContext("2d");
        window.myBar = new Chart(ctx, {
            // type: 'doughnut',
            type: 'polarArea',
            data: barChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.SaleComparisonReportForCustomeres")'
                }
            }
        });

    //Min Sale Customer
    var ctx2 = document.getElementById("canvas_min").getContext("2d");
        window.myBar1 = new Chart(ctx2, {
            // type: 'doughnut',
            // type: 'line',
            // type: 'radar',
            type: 'polarArea',
            // type: 'bubble',
            // type: 'scatter',
            data: minSaleChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.SaleComparisonReportForCustomeres")'
                }
            }
        });    


    //Income And Expense
    var ctx3 = document.getElementById("canvas_income_expense").getContext("2d");
        window.myBar3 = new Chart(ctx3, {
            type: 'pie',
            data: incomeExpenseChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.IncomeAndExpense")'
                }
            }
        });

    //Max Sale Item
    var ctx4 = document.getElementById("canvas_max_sale_item").getContext("2d");
        window.myBar4 = new Chart(ctx4, {
            type: 'pie',
            data: maxSaleItemChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.MaxSaleItem")'
                }
            }
        });     

    //Min Sale Item
    var ctx5 = document.getElementById("canvas_min_sale_item").getContext("2d");
        window.myBar5 = new Chart(ctx5, {
            type: 'doughnut',
            data: minSaleItemChartData,
            options: {
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.MinSaleItem")'
                }
            }
        });    


    //Total Income And Expense
    var ctx6 = document.getElementById("canvas_total_income_expense").getContext("2d");
        window.myBar6 = new Chart(ctx6, {
            type: 'pie',
            data: totalIncomeExpenseChartData,
            options: {
                 legend:{
                    display:true,
                    labels:{
                        fontSize:18
                    }
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.TotalIncomeAndExpense")'
                }
            }
        });       

    //today Income And Expense
    var ctx6 = document.getElementById("canvas_today_income_expense").getContext("2d");
        window.myBar6 = new Chart(ctx6, {
            type: 'pie',
            data: todayIncomeExpenseChartData,
            options: {
                legend:{
                    display:true,
                    labels:{
                        fontSize:18
                    }
                },
                elements: {
                    rectangle: {
                        borderWidth: 2,
                        borderColor: 'rgb(0, 255, 0)',
                        borderSkipped: 'bottom'
                    }
                },
                responsive: true,
                title: {
                    display: false,
                    text: '@lang("layout.TodayIncomeAndExpense")'
                }
            }
        });   
    }; 








</script>

@endpush









