@extends('layouts.app')
@section('style')
<?php
$menu_session = session()->get('getMenu');
//  $bgcolor = "bg-blue-ebonyclay bg-font-blue-ebonyclay";
//  $bgcolortext = "bg-blue-ebonyclay bg-font-blue-ebonyclay"; 
$bgcolor = "#eceef1";
$bgcolortext = "#eceef1";
$menu_text_color = "#333";
$company_bg_color = "#eceef1";
if(getMenuColor()!='')
{
   $bgcolor = getMenuColor();
   $bgcolortext = getMenuColor();
   $menu_text_color = getMenuTextColor();
   $company_bg_color = getCompanyBgColorDashboard();
   // dd($bgcolor,$bgcolortext);
}
if(themColor()=="newTheme"){
   $bgcolor = "#eceef1";
   $bgcolortext = "#eceef1";
   $menu_text_color = "#333";  
}
?>
<style>
  .company-info{
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 5px;
    padding: 5px;
    background-color: {{($company_bg_color)?$company_bg_color:'#eceef1'}}; 
  }
  .company-name{
    font-size: 30px;
    padding:7px;
    color: {{getCompanyNameColorDashboard()}};
  }
  .company-logo{
    width: 120px;
    height: 120px;
    background-color: #fff;
    border-radius:{{getCompanyLogoBorderRadius()}}%;
  }
  .current-date{
    font-size: 18px;
    color: {{getCompanyNameColorDashboard()}};
  }   
</style>
@endsection
@section('content')
@permission('dashboard-list')
@if(getCompanyProfile()=="true")
<div class="company-info">
  <img alt="" class="company-logo" style="border:3px solid #fff;border-radius:9px"  src="{{asset('uploads/'.company()['logo'])}}" >
    <div class="company-name">  {!!company()['name']!!}
    </div>
    <div class="current-date">
        @if(isset($date))<span style="font-size: 18px;"><img src="{{asset('menu_img/calendar.png')}}" style="width: 64px;height:64px;border:3px solid #fff;border-radius:9px"> {{convertdate($date, 0, 'jalali')}}  &nbsp;/&nbsp;  {{convertdate($date, 2, 'gregorian')}} </span> @endif
    </div>
</div>
<br>    
@endif
<!--Begin Menu-->
<div class="row" style="padding: 0px !important;margin: 0px !important;">
  <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light" style="margin: 0px;padding: 0px !important;">
      <template v-cloak id="company_ll">
          <company @company="setCompany"></company>
      </template>
  </div>
</div>
<!--End Menu-->
<br>
<!-- chart -->
<div class="col-md-12 col-sm-12" >
    <h3 style="margin-bottom: 1em !important;">@lang('menu.ChartOfCompanyOrganization')</h3>
    <script src="{{url('/chart_multi/jscharting.js')}}"></script>
    <script src="{{url('/chart_multi/types.js')}}"></script>
    <script src="{{url('/chart_multi/debug.js')}}"></script>
    <div id="chartDiv1" class="chartDiv col-md-12 col-sm-12" style="height: 600px; border: solid 1px #a6a6a6; border-radius: 8px; padding: 0px !important; direction: ltr;overflow: auto;"></div>
    <script type="text/javascript">
      var datas = {!! $data !!};
      // console.log(datas);
      // JS
      var chart = JSC.chart('chartDiv1', {
        debug: false,
        type: 'organizational',
        defaultTooltip_enabled: false,
        /*These options will apply to all annotations including point nodes and breadcrumbs.*/
        defaultAnnotation: { margin: 40 },
        defaultSeries: {
          mouseTracking: true,
          color: 'lightgray',
          defaultPoint: {
            outline_width: 1,
            connectorLine: {
              radius: 100,
              width: 1.5,
              color: '#78797b',
            },
            /* Make node widths sync for every level. */
            annotation_syncWidth_with: 'level',
            label_text:
              '<img width=70 height=70 margin_bottom=4 src=%image><br><b>%name</b><br><span style="font-size:10px;">%role</span>',
          },
        },
        series: [
          {
            points: datas
            // [
        //       {
        //         name: 'Tyrique Kent',
        //         id: 'd1',
        //         attributes: { role: 'Director', image: '{{asset("uploads/")}}/avatar_8.png' },
        //       },
        //       {
        //         name: 'Robin Mill',
        //         id: 'd2',
        //         attributes: { role: 'Director', image: '{{asset("uploads/")}}/avatar_2.png' },
        //       },
        //       {
        //         name: 'Bushra Barnett',
        //         id: 'd3',
        //         attributes: { role: 'Director', image: '{{asset("uploads/")}}/avatar_3.png' },
        //       },
        //       {
        //         name: 'Linzi Cassidy',
        //         id: 'ceo',
        //         parent: 'd1,d2,d3',
        //         attributes: { role: 'CEO', image: '{{asset("uploads/")}}/avatar_5.png' },
        //       },
        //       {
        //         name: 'Linzi Cassidy',
        //         id: 'ceoo',
        //         parent: 'd1,d2',
        //         attributes: { role: 'CEO', image: '{{asset("uploads/")}}/avatar_5.png' },
        //       },
        //       {
        //         name: 'Samara Munoz',
        //         id: 'm1',
        //         parent: 'ceo',
        //         attributes: { role: 'Manager finance', image: '{{asset("uploads/")}}/avatar_9.png' },
        //       },
        //       {
        //         name: 'Alya Roberts',
        //         id: 'm2',
        //         parent: 'ceo',
        //         attributes: { role: 'Manager advertising', image: '{{asset("uploads/")}}/avatar_7.png' },
        //       },
        //       {
        //         name: 'Glyn Dawe',
        //         id: 'm3',
        //         parent: 'ceo',
        //         attributes: { role: 'Manager sales', image: '{{asset("uploads/")}}/avatar_6.png' },
        //       },
        //       {
        //         name: 'Chad Read',
        //         id: 'm4',
        //         parent: 'ceo',
        //         attributes: { role: 'Manager production', image: '{{asset("uploads/")}}/avatar_4.png' },
        //       },
        //       {
        //         name: 'Chad Read',
        //         id: 'm8',
        //         parent: 'ceoo',
        //         attributes: { role: 'Manager production', image: '{{asset("uploads/")}}/avatar_4.png' },
        //       },
            // ],
          },
        ],
      });
    </script>
 <br/>  
 <hr/> 
</div> 
<!-- end chart -->
<div class="row">
</div> 
<!-- END CONTENT -->
@endpermission
@if(!\Entrust::can('dashboard-list'))
<h1 class="page-title"></h1>
<div class="row">
    <div class="col-md-12">
        <div class="portlet light bordered">
            <div class="portlet-title note note-info note-bordered">
                <div class="caption">
                    <i class="icon-bar-chart font-green-haze"></i>
                    <span class="caption-subject bold uppercase font-green-haze" style="font-size: 20px">@lang('menu.Dashboard')</span>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function (event) {
                window.location.reload();
            }
        }
    });
</script>
@endpush