@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show" :value-type="'cashBook_Report'" @closed="closeModal">

 

            <div slot="body">
                <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                    ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop"> 
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endif
                        </ul> 
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('menu.FinancialClass')</label>
                                                        <select name="class_id" class="form-control" v-model="selected" >
                                                            <option value="">@lang('layout.SelectClass')</option>
                                                            <option value="Unclassified">Unclassified</option>
                                                            <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endpermission
                                        @endif
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <h4 style="color: red; text-align:center" class="center">@lang('layout.CashBookInfo')</h4>
                                                    <div class="form-group">
                                                        <label class="control-label"><i class="fa fa-calendar" style="color: green;"></i> @lang('layout.OneDayDate')</label>
                                                        <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  

                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-12" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"><i class="fa fa-calendar" style="color: green;"></i> @lang('layout.BetweenTwoDates')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date1" v-model="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" v-model="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    </div>
                                </div>
                            </div>
    
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
    
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="new_cachbook_index">
    
    
                                            <div class="col-md-12 col-sm-12 col-xs-12">
    
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
    
                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
    
    
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
    
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                        class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
    
    
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.CashBook')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                    @permission('cashbook-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="anchore-modal-link" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cashBook">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.Name')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Unit')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Remark')</th>
                            <th>@lang('layout.Remark')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
        var cust_rep = {!!customeReportNewData('new_cachbook_index')!!};
        let data = {
            selected: '{!! getCompanyID() !!}'
        };
        let data_table =null;
        Vue.component("v-select", VueSelect.VueSelect);
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cashBook').DataTable({
                ajax: '{{route("cashBook.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                order: [[4, "desc"]],
                columns: [
                    {data: 'id', name: 'transactions.id'},
                    {data: 'name', name: 'accounts.name'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'rate', name: 'transactions.rate'},
                    {data: 'currency', name: 'accounts.currency'},
                    {data: 'date', name: 'transactions.date', searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'remark_en', name: 'remark_en', orderable: false, searchable: false},
                    {data: 'remark_fa', name: 'remark_fa', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({

            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    console.log('company emitted from child',event.company);
                    data.selected = event.company;
                    try{
                        if (data_table != null &&  typeof  data_table =='object')
                        {
                            data_table.clear();
                            data_table.ajax.reload();
                        }
                    }catch (e) {

                    }

                }
            }
        });

        var vm = new Vue({

            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                financial_classes: {!!getFinancialClassList()!!},
                selected: '',
                customReportData:
                [
                 {Name: '@lang("layout.Bilance")', column_name: 'bilance',checkedColumn:(cust_rep.bilance)?'checked':'',column_percentage:(cust_rep.bilance___percent)?cust_rep.bilance___percent:''},
                 {Name: '@lang("layout.BaseAmount")', column_name: 'base_amount',checkedColumn:(cust_rep.base_amount)?'checked':'',column_percentage:(cust_rep.base_amount___percent)?cust_rep.base_amount___percent:''},
                 {Name: '@lang("layout.BaseBilance")', column_name: 'base_bilance',checkedColumn:(cust_rep.base_bilance)?'checked':'',column_percentage:(cust_rep.base_bilance___percent)?cust_rep.base_bilance___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                  ],
                  cust_rep:cust_rep
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                },
            }
        });
    </script>
@endpush