@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
@stop
@section('content')
{{-- {{dd($customer->)}} --}}
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CustomerInformation') </span>
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($customer,['method' => 'PATCH','route' => ['customer.update',$customer->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                                         <h3 class="form-section">@lang('layout.PersonInfoo')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', null, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                                </div>
                                
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                <div class="col-md-9">
                                   <input type="text" id="date_of_birth" value="{{$customer->date_of_birth}}" name="date_of_birth" class="form-control date" autocomplete="off">
                                     
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div id="genderApp">
                            <div class="col-md-6">
                                <label class="control-label col-md-3">@lang('layout.Gender')</label>
                                    <div class="col-md-9">
                                        <div id="" >
                                            <label class="radio-inline">
                                                <input type="radio" name="gender" checked="" value="male" v-model="type"> @lang('layout.Male') </label>
                                                <label class="radio-inline">
                                                <input type="radio" name="gender" value="female" v-model="type">
                                                @lang('layout.Female') </label>
                                        </div>
                                    </div>
                            </div>
                            <!--/span-->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-3">@lang('layout.Membership')</label>
                                    <div class="col-md-9">
                                        <div >
                                            <label class="radio-inline">
                                                <input type="radio" name="membership" value="free" v-model="members"> @lang('layout.Free') </label>
                                            <label class="radio-inline">
                                                <input type="radio" name="membership" value="professiona" v-model="members">
                                                @lang('layout.Professional') </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Date')</label>
                                <div class="col-md-9">
                                    <input type="text" id="reg_date" name="reg_date" class="form-control date" autocomplete="off" value="{{ $customer->reg_date }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div> 
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Type')</label>
                                <div class="col-md-9">
                                 {!! Form::select('type[]', $type,$customer->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                                </div>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Class')</label>
                                <div class="col-md-9">
                                     {!! Form::select('class', $class,$customer->class, array('class' => 'form-control')) !!}

                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="row" id="app">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsReceivable')</label>
                                <div class="col-md-9">
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.AccountsPayable')</label>
                                <div class="col-md-9">
                                      <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="form-section">@lang('layout.Address')</h3>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address1')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address2')</label>
                                <div class="col-md-9">
                                    {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-9">
                                    {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                     {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9" id="countries">
                                   <select  class="form-control" name="country" v-model="country">
                                        <option value="Afghanistan">@lang('layout.Afghanistan')</option>
                                        <option value="Iran">@lang('layout.Iran')</option>
                                        <option value="Pakistan" >@lang('layout.Pakistan')</option>
                                        <option value="China" >@lang('layout.China')</option>
                                        <option value="us" >@lang('layout.USA')</option>
                                        <option value="india" >@lang('layout.India')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                     <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <a href="{{route('customer.index')}}" type="button" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
script>
<script>
    $('#type').multiselect({
        placeholder: 'Select Type',
        columns: 4

    });
    Vue.component('v-select', VueSelect.VueSelect);
 

    var gen = {!! json_encode($customer) !!}
    console.log('asdf',gen['photo'])
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });
    new Vue({
        el:'#countries',
        data:{
            country: gen['country'],
        }
    });
    var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $customer !!};
  var member_class = {!!$class!!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
        member_class:member_class,
        selectedClass:"{!!$customer->class!!}",
    },
    mounted:function(){
        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
               if(this.receivable[j].id==this.customer.receivable_id)
              {
                 this.selected_receivable=this.receivable[j];
              }
          }

          
    },

  });
    
</script>
@endpush