@extends('layouts.factor-master')


@section('content')
<?php

$report = customeReportNew('new_cachbook_index');
$_balance = !in_array('bilance', $report);
$_base_amount = !in_array('base_amount', $report);
$_base_balance = !in_array('base_bilance', $report);
$_user = !in_array('user', $report);
 
$report_percent = customeReportNewPercent('new_cachbook_index');
$_balance_percent= (array_key_exists('bilance___percent', $report_percent))?$report_percent['bilance___percent']:null;
$_number_percent= (array_key_exists('base_amount___percent', $report_percent))?$report_percent['base_amount___percent']:null;
$_type_percent= (array_key_exists('base_bilance___percent', $report_percent))?$report_percent['base_bilance___percent']:null;
$_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;


$count = 0;
$total_home_currency = 0;
$currencies = [];

$total_home_currency_all_time = 0;
$currencies_all_time = [];

// dd($_balance , $_base_amount , $_base_balance , $_user);

?>
<h4></h4>
<h2 class="center">@lang('menu.CashBook1')</h2>  
<table class="main-table">
  <tr>
    @if($ClassName)
    <td>
      <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
    </td>
    @endif

  </tr>
</table>
<br>
<table class="main-table">
  <tr>
    @if($from_date1 || $to_date)
    @if($from_date1)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date1)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
    @elseif($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<br>

<?php
// dd($data);

?>
@foreach($data AS $key=>$value)
<!-- <span style="font-size: 25px; font-weight: bolder; float: right;">{{$key}}</span><br>-->

<br>
<table class="main-table">
  <tr>
    <th style=" font-size: 25px; font-weight: bolder;">{{__('currency.'.$key)}}</th>
  </tr>
</table>

@foreach($value As $k=>$v)


<!-- <span class="center" style="color: blue; font-size: 25px; font-weight: bolder;">{{$v['account']->name}}</span> -->

<br>
<table class="main-table">
  <tr style="background-color: lightblue">
    <th style="color: blue; font-size: 20px; font-weight: bolder;">({{$v['account']->name}})</th>
  </tr>
</table>

@if($v['details'])

<!-- begin detail -->

<table class="main-table">
  <tr style="background-color: lightblue">
    <th>@lang('layout.ID')</th>
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Description')</th>
    <th>@lang('layout.Currency')</th>
    <th>@lang('layout.Rate')</th>
    <th>@lang('layout.Received')</th>
    <th>@lang('layout.Paid')</th>
    @if($_balance)
    <th  @if($_balance_percent) width="{{$_balance_percent}}%" @endif >@lang('layout.Balance')</th>
    @endif
    @if($_base_amount)
    <th  @if($_number_percent) width="{{$_number_percent}}%" @endif >@lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}} </th>
    @endif
    @if($_base_balance)
    <th  @if($_type_percent) width="{{$_type_percent}}%" @endif >@lang('layout.Balance') {{getHomeCurrency()[getCurrencyType()]}} </th>
    @endif 
    @if($_user)
    <th  @if($_user_percent) width="{{$_user_percent}}%" @endif >@lang('layout.User')</th>
    @endif
  </tr>
  <?php
  $total = 0;
  $totalHomeCurrencyEachAccount = 0;
  $total_r = 0;
  $total_p = 0;
  $Balance = 0;
  $BalanceHomeCurrency = 0;
  $rate = 1;

  $statement_flag = '';
  $statement_flag_change = '';
  $closing_blance_amount = 0;
  $closing_blance_exchange_amount = 0;
  $closing_blance_amount_to = 0;
  $closing_blance_exchange_amount_to = 0;

  $totalReceive = 0;
  $totalPayd  = 0;
 
  ?>

  @if(isset($v['closing_Blance']->amount))

  <?php

  // begin check for balance
  if ($statement_flag == '') {
    if ($v['closing_Blance']->amount > 0) {
      $statement_flag = 'Received';
      $statement_flag_change = 'paid';
      $Balance += $v['closing_Blance']->amount;
      $BalanceHomeCurrency += $v['closing_Blance']->exchange_amount;
    } else {
      $statement_flag = 'paid';
      $statement_flag_change = 'Received';
      $Balance += $v['closing_Blance']->amount;
      $BalanceHomeCurrency += $v['closing_Blance']->exchange_amount;
    }
  }
  // end check balance
  $closing_blance_amount = $v['closing_Blance']->amount;
  $closing_blance_exchange_amount = $v['closing_Blance']->exchange_amount;

  $total_home_currency_all_time += $v['closing_Blance']->exchange_amount;
  if (array_key_exists($v['closing_Blance']->currency, $currencies_all_time)) {
    $currencies_all_time[$v['closing_Blance']->currency] = $currencies_all_time[$v['closing_Blance']->currency] + $v['closing_Blance']->amount;
  } else {
    $currencies_all_time[$v['closing_Blance']->currency] = $v['closing_Blance']->amount;
  }

  ?>
  <tr>
    <td class="center" style="background-color: #ccc;">###</td>
    <td class="center" style="background-color: #ccc;"></td>
    <td class="center" style="background-color: #ccc;">@lang('layout.TotalBeforAmount')</td>
    <td class="center" style="background-color: #ccc;">{{$v['closing_Blance']->currency}}</td>

    <td class="center" style="background-color: #ccc;"></td>
    <td class="center ltr">
      @if($v['closing_Blance']->amount>0)
      <?php 
         $totalReceive += $v['closing_Blance']->amount;
      ?>
      {{myRound($v['closing_Blance']->amount)}}
      @endif
    </td>   
    <td class="center ltr" style="color: red;">
      @if($v['closing_Blance']->amount<0) <?php $totalPayd +=$v['closing_Blance']->amount; 
        ?>
        {{myRound($v['closing_Blance']->amount)}}
        @endif
    </td>
    @if($_balance)
    <td class="center ltr">{{myRound($Balance)}}</td>
    @endif
    @if($_base_amount)
    <td class="center ltr">
      @if($v['closing_Blance']->exchange_amount>0)
      <span style="color: green;"> {{myRound($v['closing_Blance']->exchange_amount)}}  </span>
      @else
      <span style="color: red;"> {{myRound($v['closing_Blance']->exchange_amount)}}  </span>
      @endif
    </td>
    @endif
    @if($_base_balance)
    <td class="center ltr">{{myRound($BalanceHomeCurrency)}}</td>
    @endif
  </tr>

  @endif

  @foreach($v['details'] as $detail)
  <tr>
    <?php

    // begin check for balance
    if ($statement_flag == '') {
      if ($detail->amount > 0) {
        $statement_flag = 'Received';
        $statement_flag_change = 'paid';
        $Balance += $detail->amount;
        $BalanceHomeCurrency += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
      } else {
        $statement_flag = 'paid';
        $statement_flag_change = 'Received';
        $Balance += $detail->amount;
        $BalanceHomeCurrency += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
      }
    } else {
      if ($detail->amount) {
        $Balance += $detail->amount;
        $BalanceHomeCurrency += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
      } else {
        $Balance += $detail->amount;
        $BalanceHomeCurrency += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
      }
    }
    
    // end check balance
 
    if ($detail->amount > 0) {
      $total_r += $detail->amount;
      
    }
    if ($detail->amount < 0) {
      $total_p += $detail->amount;
    }
    $rate = $detail->rate;
    $total += $detail->amount;
    $totalHomeCurrencyEachAccount += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);

    $total_home_currency += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
    if (array_key_exists($detail->currency, $currencies)) {
      $currencies[$detail->currency] = $currencies[$detail->currency] + $detail->amount;
    } else {
      $currencies[$detail->currency] = $detail->amount;
    }

    $total_home_currency_all_time += (systemConfig()[30] == 1)?($detail->amount * $detail->rate / $detail->static_rate):($detail->amount / $detail->rate);
    if (array_key_exists($detail->currency, $currencies_all_time)) {
      $currencies_all_time[$detail->currency] = $currencies_all_time[$detail->currency] + $detail->amount;
    } else {
      $currencies_all_time[$detail->currency] = $detail->amount;
    }
    ?>
    <td class="center">{{$detail->id}}</td>
    <td class="center">{{convertDate($detail->date)}}</td>
    @if(getDesWithNote() == 'true' && $detail->remark1 != $detail->remark)
    <td class="center">{{ $detail->remark1.' '.$detail->remark }}</td>
    @else
    <td class="center">{{ $detail->remark }}</td>
    @endif
    <td class="center">{{$detail->currency}}</td>
    <td class="center">{{myRound($detail->rate)}}</td>
    <td class="center ltr" style="color: green">
      @if($detail['amount']>0)
      <?php 
        $totalReceive = $totalReceive + $detail['amount'];
      ?>
      {{myRound($detail['amount'])}}
      @endif
    </td>
    <td class="center ltr" style="color: red;">
      @if($detail['amount']<0) 
      <?php $totalPayd=$totalPayd + $detail['amount']; ?>
        {{myRound($detail['amount'])}} 
      @endif
    </td>

    @if($_balance)
    
    <td class="center ltr">{{myRound($Balance)}}</td>
    @endif 
    @if($_base_amount)
    <td class="center ltr">
      @if($detail['amount']>0)
      <span style="color: green;"> {{(systemConfig()[30] == 1)? myRound($detail->amount * $detail->rate / $detail->static_rate): myRound($detail->amount / $detail->rate)}} </span>
      @else
      <span style="color: red;"> {{(systemConfig()[30] == 1)? myRound($detail->amount * $detail->rate / $detail->static_rate): myRound($detail->amount / $detail->rate)}} </span>
      @endif
    </td>
    @endif
    @if($_base_balance)
    <td class="center ltr">{{myRound($BalanceHomeCurrency)}}</td>
    @endif
    @if($_user)
    <td class="center">{{$detail->user}}</td>
    @endif
  </tr>

  @endforeach
  <!-- end detail -->

  <tr>
    <td colspan="5" class="center" style="font-size: 18px; font-weight:bold;"> @lang('layout.TotalReceivePay') </td>
    <td colspan="1" class="center" style="font-weight: bold; color:green"> {{myRound($totalReceive)}} </td>
    <td colspan="1" class="center" style="font-weight: bold; color:red"> {{myRound($totalPayd)}} </td>
    <td colspan="2"></td>
  </tr>

  @if(isset($v['closing_balanceTo']->amount))

  <?php

  // begin check for balance
  // if ($statement_flag == '') {
    if ($v['closing_balanceTo']->amount > 0) {
      // $statement_flag = 'Received';
      // $statement_flag_change = 'paid';
      $Balance += $v['closing_balanceTo']->amount;
      $BalanceHomeCurrency += $v['closing_balanceTo']->exchange_amount;
    } else {
      // $statement_flag = 'paid';
      // $statement_flag_change = 'Received';
      $Balance += $v['closing_balanceTo']->amount;
      // dd($v['closing_balanceTo']->amount);
      $BalanceHomeCurrency += $v['closing_balanceTo']->exchange_amount;
    }
  // }
  // end check balance
  $closing_blance_amount_to = $v['closing_balanceTo']->amount;
  $closing_blance_exchange_amount_to = $v['closing_balanceTo']->exchange_amount;

  $total_home_currency_all_time += $v['closing_balanceTo']->exchange_amount;
  if (array_key_exists($v['closing_balanceTo']->currency, $currencies_all_time)) {
    $currencies_all_time[$v['closing_balanceTo']->currency] = $currencies_all_time[$v['closing_balanceTo']->currency] + $v['closing_balanceTo']->amount;
  } else {
    $currencies_all_time[$v['closing_balanceTo']->currency] = $v['closing_balanceTo']->amount;
  }

  ?>
  <tr>
    <td class="center" style="background-color: #ccc;">###</td>
    <td class="center" style="background-color: #ccc;"></td>
    <td class="center" style="background-color: #ccc;">@lang('layout.TotalAfterAmount')</td>
    <td class="center" style="background-color: #ccc;">{{$v['closing_balanceTo']->currency}}</td>

    <td class="center" style="background-color: #ccc;"></td>
    <td class="center ltr">
      @if($v['closing_balanceTo']->amount>0)
      {{myRound($v['closing_balanceTo']->amount)}}
      @endif
    </td>
    <td class="center ltr" style="color: red;">
      @if($v['closing_balanceTo']->amount<0) {{myRound($v['closing_balanceTo']->amount)}} @endif </td>
    <td class="center ltr">{{myRound($Balance)}} </td>
    <td class="center ltr">
      @if($v['closing_balanceTo']->exchange_amount>0)
      <span style="color: green;"> {{myRound($v['closing_balanceTo']->exchange_amount)}} </span>
      @else
      <span style="color: red;"> {{myRound($v['closing_balanceTo']->exchange_amount)}} </span>
      @endif
    </td>

    <td class="center ltr"> {{myRound($BalanceHomeCurrency)}} </td>

  </tr>
  @endif
  <!-- end closing -->



  <!-- end closing -->


  <tr>
    <td class="center" style="background-color: lightblue;font-weight:bold" colspan="3">@lang('layout.ToDay')</td>
    <td class="center ltr doubleLine" colspan="3">{{myRound($total)}} {{$v['account']->currency}}</td>
    <td class="center ltr doubleLine" colspan="2">{{myRound($totalHomeCurrencyEachAccount)}}
      {{getHomeCurrency()[getCurrencyType()]}}</td>

  </tr>
  <tr>
    <td class="center" style="background-color: lightblue;font-weight:bold" colspan="3">@lang('layout.Balance')</td>
    <td class="center ltr doubleLine" colspan="3">

      {{myRound($closing_blance_amount_to + $closing_blance_amount + $total)}}
      {{$v['account']->currency}}

    </td>
    <td class="center ltr doubleLine" colspan="2">
      {{myRound($totalHomeCurrencyEachAccount+$closing_blance_exchange_amount+$closing_blance_exchange_amount_to)}}
      {{getHomeCurrency()[getCurrencyType()]}}
    </td>

  </tr>


</table>


@endif


@endforeach
<!--  end each account -->

@endforeach

<br>
<table class="main-table">
  <tr style="background-color: lightblue">
    <td colspan="3" style="background-color: lightblue;font-weight:bold">
      <div class="center">@lang('layout.PerCurrency') @lang('layout.ToDay')</div>
    </td>
  </tr>



  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
  $count = 0;
  foreach ($currencies as $key => $currency) {
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td class="ltr">
      <div class="center ltr">{{myRound($currency)}}</div>
    </td>
  </tr>
  <?php
  }
  ?>

  <tr>
    <td colspan="2" style="background-color: lightblue;font-weight:bold">
      <div class="center">@lang('layout.HomeCurrencyTotal')
    </td>
    <td class="ltr">
      <div class="center ltr">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>

  </tr>
</table>

<br>
<!-- begin all time data -->
<table class="main-table">
  <tr style="background-color: lightblue">
    <td colspan="3" style="background-color: lightblue;font-weight:bold">
      <div class="center"> @lang('layout.Total') @lang('layout.PerCurrency')</div>
    </td>
  </tr>



  <tr>
    <td>
      <div class="center"> @lang('layout.Record') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
  </tr>
  <?php
  $count = 0;
  foreach ($currencies_all_time as $key => $currency) {
  ?>
  <tr>
    <td>
      <div class="center">{{++$count}}</div>
    </td>
    <td>
      <div class="center">{{$key}}</div>
    </td>
    <td class="ltr">
      <div class="center ltr">{{myRound($currency)}}</div>
    </td>
  </tr>
  <?php
  }
  ?>

  <tr>
    <td colspan="2" style="background-color: lightblue;font-weight:bold">
      <div class="center">@lang('layout.HomeCurrencyTotal')
    </td>
    <td class="ltr">
      <div class="center ltr">{{myRound($total_home_currency_all_time)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>

  </tr>
</table>


 
@if($statement && $statement !=[]) 
<h3 class="table-caption" style="text-align: center;">@lang('layout.Receivable') / @lang('layout.Payable')</h3>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td>
        <div class="center">@lang('layout.Number')</div>
      </td>
      <td>
        <div class="center">@lang('layout.TransactionID')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Name') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Description') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Phone') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Currency') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Rate') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Receivable') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Payable') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Balance') </div>
      </td> 
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 0;
    $tempName = '';
    $totalP = 0;
    $totalR = 0;

    ?>
 
    @foreach($statement AS $key=>$value) 
    @foreach($value['Currency'] AS $key1=>$rec)
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$value['transaction_id']}}</td>
      <td class="center">{{$key}}</td>
      <td class="center">{{$value['Description']}}</td>
      <td class="center">{{$value['Phone']}}</td>
      <td class="center">{{$key1}}</td>
      <td class="center"> {{$rec['Rate']}}</td>
      <td class="center">{{myRound($rec['Receivable'])}}</td>
      <td class="center"> {{myRound($rec['Payable'])}}</td>
      <td class="center">
        <?php
        $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
        $p1 = $result1['a'];
        $r1 = $result1['b'];
 
        if ($p1 != 0) {  
          $totalP += ((systemConfig()[30] == 1)? ($p1 * $rec['Rate'] / $rec['static_rate']): ($p1 / $rec['Rate']));
          // echo round($p1,2).' '.__('layout.Payable');
        } elseif ($r1 != 0) {
          $totalR += ((systemConfig()[30] == 1)? ($r1 * $rec['Rate'] / $rec['static_rate']): ($r1 / $rec['Rate']));
          // echo round($r1,2).' '.__('layout.Receivable');
        } else {
          echo '0';
        }
        ?>
        @if($r1 !=0)
        {{myRound($r1)}}:
        @lang('layout.Receivable') 
        @elseif($p1 !=0) 
        {{myRound($p1)}}:
        @lang('layout.Payable') 
        @endif
      </td> 
    </tr>
    @endforeach
    @endforeach
  </tbody>
</table>
<table class="main-table bg">
  <tr>
    <td width="25%">
      <div class="center"> @lang('layout.Payable') </div>
    </td>
    <td width="25%">
      <div class="center"> {{myRound($totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
    <td width="25%">
      <div class="center"> @lang('layout.Receivable') </div>
    </td>
    <td width="25%">
      <div class="center"> {{myRound($totalR)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
  </tr>
</table>
@endif 
<!-- end all time data -->
 

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->

@endsection