@extends('layouts.factor-master')

@section('content')

<h3 style="text-align: center;">@lang('layout.ContructReport')</h3>
@if($info && $info !=[])
<table class="main-table">
    <thead>
        <tr>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.Number')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.ReferenceNumber')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.Employee')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.FatherName')
            </th>
            <th>
                <i class="icon-phone"></i> @lang('layout.Phone')
            </th>
            <th>
                <i class="fa fa-home"></i> @lang('layout.Address')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.Currency')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelOne')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelTow')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelTree')
            </th>
        </tr>

    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $info->number}} </td>
            <td class="hidden-xs"> {{ $info->ref_no}} </td>
            <td class="hidden-xs"> {{ $info->employee}} </td>
            <td class="hidden-xs"> {{ $info->father_name}} </td>
            <td class="hidden-xs"> {{ $info->phone}}</td>
            <td class="hidden-xs"> {{ $info->address1}}</td>
            <td class="hidden-xs"> {{ $info->currency}}</td>
            <td class="hidden-xs"> {{ $info->price_level1}}</td>
            <td class="hidden-xs"> {{ $info->price_level2}}</td>
            <td class="hidden-xs"> {{ $info->price_level3}}</td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr>
            <th>@lang('layout.GraphNumber')</th>
            <th>@lang('layout.Quality')</th>
            <th>@lang('layout.CarpetSize')</th>
            <th>@lang('layout.TextMap')</th>
            <th>@lang('layout.BorderMap')</th>
            <th>@lang('layout.TypeManufactory')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=" "> {{ $info->graph_number}} </td>
            <td class=" "> {{ $info->quality}} </td>
            <td class=" "> {{ $info->size}} </td>
            <td class=" "> {{ $info->text_map}} </td>
            <td class=" "> {{ $info->border_map}} </td>
            <td class=" "> {{ $info->work_type}} </td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr>
            <th width="">
                <i class=" fa "></i> @lang('layout.Date')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.StartDate')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.EndDate')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.Duration')
            </th>
            <th width="">
                <i class=" fa fa-text-width"></i> @lang('layout.Description')
            </th>
            <th width=" ">
                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=" "> {{ convertDate($info->Date)}} </td>
            <td class=" "> {{ convertDate($info->start_date)}} </td>
            <td class=" "> {{ convertDate($info->end_date)}} </td>
            <td class=" "> {{ $info->duration}} </td>
            <td class=" "> {{ $info->description}} </td>
            <td class=" "> {{ $info->memo}} </td>
        </tr>
    </tbody>
</table>
@endif

@if(count($data) > 0)
<h4>@lang('layout.Payroll')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.NetPayable')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.FromDate')</th>
            <th>@lang('layout.ToDate')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record4)
        <tr>
            <td class="center">{{$record4->id}}</td>
            <td class="center">{{myRound($record4->net_payable)}}</td>
            <td class="center">{{$record4->currency}}</td>
            <td class="center">{{myRound($record4->rate)}}</td>
            <td><div class="center"> {{convertDate($record4->from_date)}}</div></td>
            <td><div class="center"> {{convertDate($record4->to_date)}}</div></td>
            <td class="center">{{$record4->description}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif



@endsection