@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>

</style>
@stop
@section('content')
@include("layouts.Cmodal")

<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-anchor font-green-sharp"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CarpetContractEdit') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>

        </div>
        <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::model($contract,['method' => 'PATCH','route' => ['carpetContract.update',$contract->id],'files'=> true,'id'=>'contract-form'])!!}
            {{ csrf_field() }}

            <div class="form-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.Employee') </label>
                                <div class="input-group">
                                    <v-select label="name" :options="employee" v-model="selected_employee"></v-select>
                                    <input type="hidden" name="employee" v-validate="'required'" data-vv-as="@lang('layout.Employee')" :value="!selected_employee?null:selected_employee.id" required>
                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewEmployee')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span>
                                </div>
                                <span class="required">@{{ errors.first('employee') }}</span>
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.Number')</label>
                                {{Form::text('number',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                {{Form::text('ref_no',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input class="form-control date" name="date" value="{{$contract->date}}" autocomplete="off">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.GraphNumber')</label>
                                {!! Form::text('graph_number', null, array('placeholder' => __('layout.GraphNumber'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.Quality')</label>
                                {!! Form::text('quality', null, array('placeholder' => __('layout.Quality'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.CarpetSize')</label>
                                {!! Form::text('size', null, array('placeholder' => __('layout.CarpetSize'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.TextMap')</label>
                                {!! Form::text('text_map', null, array('placeholder' => __('layout.TextMap'),'class' => 'form-control')) !!}
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.BorderMap')</label>
                                {!! Form::text('border_map', null, array('placeholder' => __('layout.BorderMap'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.TypeManufactory')</label>
                                {!! Form::text('work_type', null, array('placeholder' => __('layout.TypeManufactory'),'class' => 'form-control')) !!}
                            </div>

                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.StartDate')</label>
                                <input type="text" class="form-control date" value="{{$contract->start_date}}" autocomplete="off" name="start_date">
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.EndDate')</label>
                                <input type="text" class="form-control date" value="{{$contract->end_date}}" name="end_date" autocomplete="off">
                            </div>

                        </div>

                        <div class="row">
                            <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-3' }} col-sm-12">
                                <label class="control-label">@lang('layout.Currency')</label>
                                <v-select label="code" @input="selectedRate" :options="setRates" v-model="selected_currency"></v-select>
                                <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                <span class="required">@{{ errors.first('currency') }}</span>
                            </div>

                            <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-3' }} col-sm-12">
                                <label class="control-label">@lang('layout.Rate')</label>

                                <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                <span class="required">@{{ errors.first('currency_rate') }}</span>

                            </div>

                            @if(auth()->user()->company()->first()->tag != 1)

                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.ExchangeRateHQ')</label>

                                <input type="number" name="currency_rate_hq" v-validate="'required'" data-vv-as="@lang('layout.RateHQ')" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control" :class="{'has-error':rate<=0}">
                                <span class="required">@{{ errors.first('currency_rate') }}</span>
                            </div>

                            @endif
                            
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.PriceLevelOne')</label>
                                {{Form::number('price_level1',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.PriceLevelOne')])}}
                                <span class="required">@{{ errors.first('price_level1') }}</span>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.PriceLevelTow')</label>
                                {{Form::number('price_level2',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.PriceLevelTow')])}}
                                <span class="required">@{{ errors.first('price_level2') }}</span>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.PriceLevelTree')</label>
                                {{Form::number('price_level3',null,['class' => 'form-control','v-validate'=>"''",'data-vv-as'=>__('layout.PriceLevelTree')])}}
                                <span class="required">@{{ errors.first('price_level3') }}</span>
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.Duration')</label>
                                {!! Form::text('duration', null, array('placeholder' => __('layout.Duration'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.Width')</label>
                                {{Form::number('width',null,['class' => 'form-control','v-validate'=>"'required'",'v-model'=>'width', '@input'=>'changeMetraz()','data-vv-as'=>__('layout.Width')])}}
                                <span class="required">@{{ errors.first('width') }}</span>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.Length')</label>
                                {{Form::number('length',null,['class' => 'form-control','v-validate'=>"'required'",'v-model'=>'length', '@input'=>'changeMetraz()','data-vv-as'=>__('layout.Length')])}}
                                <span class="required">@{{ errors.first('length') }}</span>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <label class="control-label">@lang('layout.Metraz')</label>
                                {{Form::number('metraz',null,['class' => 'form-control','v-validate'=>"'required'",'v-model'=>'metraz','data-vv-as'=>__('layout.Metraz')])}}
                                <span class="required">@{{ errors.first('metraz') }}</span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.Memo')</label>
                                {!! Form::textarea('memo', null, array('placeholder' => __('layout.Memo'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div>
                        </div>
                    </div>
                
                </div>
                <br/>

                <!-- begin item -->
                <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')</th>
                                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')</th>
                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" @Click.native="setIndex(index)" v-model="item.item" :options="temp_items" @search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="'required'" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                    <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                            <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                @{{site.site_name}}
                                            </option>
                                        </span>
                                    </select>
                                    <input type="hidden" :name="'site_id['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>
                                <td>
                                    <input type="number" :name="'quantity['+index+']'" v-validate="'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                    <span class="required">@{{ errors.first('quantity['+index+']') }}</span>
                                </td>

                                 <td>
                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                 </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" :name="'other_measure1['+index+']'" v-model="(item.item==null)?null:item.item.other_measure1" class="form-control input-style input-number" placeholder="@lang('layout.OMeasureValue1')">
                                </td>
                                <td v-show="showWhat('other_measure2')=='yes'">
                                    <input type="number" :name="'other_measure2['+index+']'" v-model="(item.item==null)?null:item.item.other_measure2" class="form-control input-style input-number" placeholder="@lang('layout.OMeasureValue2')">
                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                            <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                @{{measure.measure_name}}
                                            </option>
                                        </span>
                                    </select>
                                    <input type="hidden" :name="'um_id['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',1000)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                    <hr>

                </div>
                <span v-if="inventories.length==0">
                    <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                </span>

                <!-- end item -->

                <hr>
                        <!-- begin payments -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center"style="min-width: 70px;">@lang('layout.Number')</th> 
                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                <th></th>

                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(payment,index) in payments">
                                <td>@{{index+1}}</td>
                                <td>
                                    <span>@{{(payment.item==null)?null:(payment.item.pay_number)+index}}</span>

                                        <input  type="hidden"
                                            name="payment_number[]"
                                            :value="(payment.item==null)?null:(payment.item.pay_number)+index"
                                            />
                                </td>

                                <td class="highlight">
                                    <v-select label="name" v-model="payment.item" :options="(payment.items)"
                                              @click.native="addNew('payment',index)"
                                              @input="checkExistingPayment(index)">

                                    </v-select>
                                    <input type="hidden" :name="'payment_id['+index+']'"
                                           :value="(payment.item==null)?null:payment.item.id">
                                </td>

                                <td>
                                    <span v-if="payment.item !=null">
                                     @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                   </span>
                                </td>
                                <td>
                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                           type="number" v-model.number="(payment.item==null)?null:payment.item.rate "
                                           class="form-control"
                                           placeholder="@lang('layout.Rate')" required/>
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate['+index+']'"
                                           v-bind:value="payment.item.rate">
                                    <input v-if="payment.item !=null" type="hidden" :name="'payment_rate_hq['+index+']'"
                                           v-bind:value="payment.item.hq_rate">
                                </td>
                                <td>
                                    <input type="text" :name="'payment_currency['+index+']'" class="form-control"
                                           v-model="(payment.item==null)?null:payment.item.code"
                                           placeholder="@lang('layout.Currency')" required disabled/>

                                    <input v-if="payment.item !==null" type="hidden" :name="'payment_currency['+index+']'"
                                           v-bind:value="payment.item.code"/>
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control"
                                               v-model.number="(payment.item==null)?null:payment.item.amount "
                                               placeholder="@lang('layout.PayAmount')" required/>

                                        <input v-if="payment.item !=null" type="hidden" :name="'payment_amount['+index+']'"
                                               v-bind:value="payment.item.amount">

                                        <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                    </div>
                                </td>
                                <td>
                                    @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate).result }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                <td>
                                    <textarea class="form-control" name="payment_description[]" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('payment',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <!-- end payments -->


            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                <a href="{{route('carpetContract.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            <cmodal :show='showModal' @close="showModal=false">

            </cmodal>

            {!! Form::close() !!}

        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif


    Vue.component('v-select', VueSelect.VueSelect);

    //begin new member
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Employee") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("employee.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },

                    dataType: 'json',

                }).done(function(response) {
                    var employee_id = 0;
                    if (response) {
                        employee_id = response.employee_id;
                    }
                    axios.get('{{route("carpetContract.create")}}').then(response => {
                        console.log('error', response.data);
                        v.employee = response.data.employee;
                        document.getElementById("modalForm").reset();
                        v.selected_employee = _.find(v.employee, (v) => v.id == employee_id);

                    }).catch(error => console.log(error));

                }).fail(function(error) {
                    console.log('error', error);
                    
                });

            }
        }
    });


    var banks = {!! $banks!!}
    var employee = {!!$employee!!}
    var currency = {!! $currency!!}
    var inventory_category = {!! $inventory_category !!};
    // group of company
    let selectedCurrency = {!! $selectedCurrency !!};
    let ratesFetched = {!! $rates !!};
    var pay_number = {!! $pay_number !!}; 
    var selectedItem = {!! $selectedItem !!}; 
    var contract = {!! $contract !!}; 
    var select_payment = {!! $payments !!}; 

    var v = new Vue({
        el: '#app',
        data: {
            currency: currency,
            selected_currency: selectedCurrency,
            employee: employee,
            selected_employee: null,
            selectedItem: selectedItem,
            showModal: false,
            listAccounts: [],
            type: 'bank',
            banks: banks,
            selected_banks: null,
            pay_number: pay_number,
            payments: [],
            select_payment: select_payment,
            width: contract.width,
            length: contract.length,
            metraz: contract.metraz,
            rate: 0,
            temp_items: [],
            inventory_category: inventory_category,
            selected_category: null,
            selected_iventory_category: null,
            selected_index: 0,
            inventories: [],
            discountFiled: 0,
            discountIsAmount: true,
        },
        computed: {

            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });
                this.banks = [];

                banks.forEach((a) => {
                    rates.forEach((r) => {
                        if (a.code == r.code) {
                            this.banks.push({
                                amount: a.amount,
                                balance: a.balance,
                                code: a.code,
                                id: a.id,
                                name: a.name,
                                rate: r.rate,
                                hq_rate: r.hq_rate,
                                pay_number: pay_number
                            })
                        }
                    });
                });

                return rates;

            },
            // accountUpdate() {
            //     var b = _.clone(Banks)
            //     return this.accounts = b.filter((account) => {
            //         return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
            //     })
            // },
            selectedRate() {
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
            },
            discount() {
                if (this.discountIsAmount) {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }

            },
            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {

                        var quantity = this.inventories[i]['item']['quantity'];
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        if (new_rate != rate && quantity > 0) {
                            sum += new_rate * quantity * this.selected_currency.rate;
                        } else {
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                        }


                    }
                    // this.totalAmountes=sum;

                }
                // for (var i = 0; i < this.services.length; i++) {
                //     if (this.services[i].item)
                //         sum += this.services[i]['item']['quantity'] * this.services[i]['item']['rate'];
                // }
                return sum;
            },


            // filter the banks according to selected currency
            approperiateBank: function() {
                var bankCopy = this.banks.slice();
                var tempBank = bankCopy.filter((account) => {
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if (tempBank.length > 0) {
                    this.selected_banks = tempBank[0];
                }
                return tempBank;
            },
        },
        mounted: function () {
            if (contract) {
                this.selected_employee = _.find(this.employee, (v) => v.id == contract.customer_id);
                if(contract.currency != null){
                    this.selected_currency = _.find(currency, (c) => c.code == contract.currency);
                } 
                this.selected_currency.rate = contract.rate;
            }

            // var selected_banks = null;
            // var bankCopy = this.banks.slice();
            // var tempBank = bankCopy.filter((account) => {
            //     return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
            // });
            // if (tempBank.length > 0) {
            //     selected_banks = tempBank[0];
            // }
            
            // this.payments.push({
            //     items: this.banks,
            //     item: selected_banks
            // });

            // initialize payments
            for (var k = 0; k < this.select_payment.length; k++) {
                var foundFlag = false;
                var tempBank = null;
                for (var j = 0; j < this.banks.length; j++) {
                    if (this.banks[j].id == this.select_payment[k].Account_id) {
                        foundFlag = true;
                        tempBank = this.banks[j];
                        tempBank.amount = this.select_payment[k].Amount;
                        tempBank.rate = this.select_payment[k].Rate;

                        tempBank.description = this.select_payment[k].description;
                        tempBank.number = this.select_payment[k].number;
                    }
                }
                if (foundFlag) {

                    this.payments.push({item: tempBank, items: this.banks});
                }

            }

            for (var w = 1; w > this.select_payment.length; w--) {
                this.payments.push({item: null, items: banks});
            }
            // end payment 

            for (var i = 0; i < this.selectedItem.length; i++) {
                // console.log('item', this.selectedItem);
                this.inventories.push({
                    item: this.selectedItem[i]
                });
            }

        },
        methods: {

            changeMetraz() {
                if (this.length != null && this.width != null) {
                    var lengths = this.length;
                    var widths = this.width;
                    this.metraz = myRound(lengths * widths);
                }
            },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        v.submitForm(e.target);
                    }
                });
            },

            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.inventories[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },

            // set new price
            setNewRate(index) {

                if (this.inventories[index].item) {
                    this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                }
            },
            // begin item search


            onItemSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: "itemSearchPurchase",
                            keyword: search,
                            inventory_category_id: inventory_category_id
                        }
                    })
                    .then(function(response) {
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            setIndex(e) {
                this.selected_index = e;
            },
            itemCategoryChange(index) {

                v.setIndex(index);
                v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                if (this.inventories[this.selected_index]['item_category'] != null) {

                    let inventory_category_id = this.inventories[this.selected_index]['item_category'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchPurchase',
                                inventory_category_id: inventory_category_id
                            }
                        })
                        .then(function(response) {
                            v.temp_items = [];

                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }

                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                item: null,
                                item_category: this.selected_iventory_category
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    } 
                }

            },


            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {


                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("contract-form").submit()

                    } else {

                    }
                });

            },

            defaultValue() {

                this.inventories = [{
                    item: null,
                    item_category: this.selected_iventory_category
                }, ];


                this.discountFiled = 0;
                this.temp_items = [];
            },
        },
        created: function() {

        }

    });
</script>


@endpush