@extends('layouts.factor-master')

@section('content')

<h3 style="text-align: center;">@lang('layout.ContructReport')</h3>
@if($info && $info !=[])
<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.Number')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.ReferenceNumber')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.Employee')
            </th>
            <th class="hidden-xs">
                <i class="fa "></i> @lang('layout.FatherName')
            </th>
            <th>
                <i class="icon-phone"></i> @lang('layout.Phone')
            </th>
            <th>
                <i class="fa fa-home"></i> @lang('layout.Address')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.Currency')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelOne')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelTow')
            </th>
            <th>
                <i class="fa "></i> @lang('layout.PriceLevelTree')
            </th>
        </tr>

    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $info->number}} </td>
            <td class="hidden-xs"> {{ $info->ref_no}} </td>
            <td class="hidden-xs"> {{ $info->employee}} </td>
            <td class="hidden-xs"> {{ $info->father_name}} </td>
            <td class="hidden-xs"> {{ $info->phone}}</td>
            <td class="hidden-xs"> {{ $info->address1}}</td>
            <td class="hidden-xs"> {{ $info->currency}}</td>
            <td class="hidden-xs"> {{ $info->price_level1}}</td>
            <td class="hidden-xs"> {{ $info->price_level2}}</td>
            <td class="hidden-xs"> {{ $info->price_level3}}</td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.GraphNumber')</th>
            <th>@lang('layout.Quality')</th>
            <th>@lang('layout.CarpetSize')</th>
            <th>@lang('layout.TextMap')</th>
            <th>@lang('layout.BorderMap')</th>
            <th>@lang('layout.TypeManufactory')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Metraz')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=" "> {{ $info->graph_number}} </td>
            <td class=" "> {{ $info->quality}} </td>
            <td class=" "> {{ $info->size}} </td>
            <td class=" "> {{ $info->text_map}} </td>
            <td class=" "> {{ $info->border_map}} </td>
            <td class=" "> {{ $info->work_type}} </td>
            <td class=" "> {{ $info->width}} </td>
            <td class=" "> {{ $info->length}} </td>
            <td class=" "> {{ $info->metraz}} </td>
        </tr>
    </tbody>
</table>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th width="">
                <i class=" fa "></i> @lang('layout.Date')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.StartDate')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.EndDate')
            </th>
            <th width="">
                <i class=" fa "></i> @lang('layout.Duration')
            </th>
            <th width="">
                <i class=" fa fa-text-width"></i> @lang('layout.Description')
            </th>
            <th width=" ">
                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=" "> {{ convertDate($info->Date)}} </td>
            <td class=" "> {{ convertDate($info->start_date)}} </td>
            <td class=" "> {{ convertDate($info->end_date)}} </td>
            <td class=" "> {{ $info->duration}} </td>
            <td class=" "> {{ $info->description}} </td>
            <td class=" "> {{ $info->memo}} </td>
        </tr>
    </tbody>
</table>
@endif

@if($build_item)
<h4>@lang('layout.BuildDetails')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.BuildNumber')</th>
            <th>@lang('layout.Employee')</th>
            <th>@lang('layout.Phone')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Rate') {{getHomeCurrency()["code"]}} </th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.UnitCost')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            @if(getOtherMeasure()=="true")
            <th> @lang('layout.Metraz')</th>
            @endif
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $count = 0;
        $total_quantity = 0;
        $total_metraz = 0;
        ?>
        @foreach($build_item AS $record1)
        <?php
            $total_quantity += $record1->Quantity;
            $total_metraz += (double)$record1->other_measure;
        ?>
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record1->Build_Number}}</td>
            <td class="center">{{$record1->employee}}</td>
            <td class="center">{{$record1->phone}}</td>
            <td class="center">{{convertDate($record1->Date)}}</td>
            <td class="center">{{$record1->Name}}</td>
            <td class="center">{{$record1->code}}</td>
            <td class="center">{{simpleRound($record1->Quantity)}}</td>
            <td class="center">{{$record1->Measure}}</td>
            <td class="center">{{myRound($record1->Cost)}}</td>
            <td class="center">{{myRound($record1->expense_cost)}}</td>
            <td class="center">{{myRound($record1->Cost + $record1->expense_cost)}}</td>
            <td class="center">{{$record1->widths}}</td>
            <td class="center">{{$record1->lengths}}</td>
            @if(getOtherMeasure()=="true")
            <td class="center">{{$record1->other_measure}} {{$record1->other_measure_name}}</td>
            @endif
            <td class="center">{{$record1->description}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if($contract_item)
<h4>@lang('layout.ItemDetails')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.SiteName')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Measure')</th>
            @if(getOtherMeasure()=='true')<th>@lang('layout.OMeasureValue1')</th>@endif
            @if(getOtherMeasure2()=='true')<th>@lang('layout.OMeasureValue2')</th>@endif
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($contract_item AS $record)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->item_name}}</td>
            <td class="center">{{$record->site_name}}</td>
            <td class="center">{{$record->quantity}}</td>
            <td class="center">{{$record->item_measure}}</td>
            @if(getOtherMeasure()=='true')
            <td class="center">{{$record->other_measure1}}</td>
            @endif
            @if(getOtherMeasure2()=='true')
            <td class="center">{{$record->other_measure2}}</td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if(count($return_item) > 0)
<h4>@lang('layout.RefundQuantity')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.BuildNumber')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Cost') {{getHomeCurrency()["code"]}}</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($return_item AS $record2)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record2->name}}</td>
            <td class="center">{{$record2->b_number}}</td>
            <td class="center">{{convertDate($record2->date)}}</td>
            <td class="center">{{$record2->qty}}</td>
            <td class="center">{{$record2->Measure}}</td>
            <td class="center">{{myRound($record2->cost)}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if(count($inventoryOnHand) > 0)
<h4>@lang('layout.InStock')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.SiteName')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Measure')</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($inventoryOnHand AS $record2)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record2->item_name}}</td>
            <td class="center">{{$record2->site_name}}</td>
            <td class="center">{{myRound($record2->OnHand)}}</td>
            <td class="center">{{$record2->measure}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if(count($payroll) > 0)
<h4>@lang('layout.Payroll')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.NetPayable')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.FromDate')</th>
            <th>@lang('layout.ToDate')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($payroll AS $record4)
        <tr>
            <td class="center">{{$record4->id}}</td>
            <td class="center">{{myRound($record4->net_payable)}}</td>
            <td class="center">{{$record4->currency}}</td>
            <td class="center">{{myRound($record4->rate)}}</td>
            <td><div class="center"> {{convertDate($record4->from_date)}}</div></td>
            <td><div class="center"> {{convertDate($record4->to_date)}}</div></td>
            <td class="center">{{$record4->description}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

@if(count($payments) > 0)
<h4>@lang('layout.Payment')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($payments AS $record3)
        <tr>
            <td class="center">{{$record3->number}}</td>
            <td class="center">{{convertDate($record3->Date)}}</td>
            <td class="center">{{myRound($record3->Amount)}}</td>
            <td class="center">{{$record3->Currency}}</td>
            <td class="center">{{myRound($record3->Rate)}}</td>
            <td class="center">{{$record3->description}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif




@endsection