@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ContractItems')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>

        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Contract')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Name')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.QutOut')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.QutIn')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.OnHand')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>

        </tr>
        </thead>

        <?php
        $count = 0;

        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record['contract']}}</td>
                <td class="center">{{$record['name']}}</td>
                <td class="center">{{$record['quantityOut']}}</td>
                <td class="center">{{$record['qut_in']}}</td>
                <td class="center">{{$record['qut_in'] - $record['quantityOut']}}</td>
                <td class="center">{{$record['measure']}}</td>

            </tr>
        @endforeach
    </table>





@endsection