@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CarpetContractReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">

            <th>@lang('layout.Number')</th>
            <th>@lang('layout.ReferenceNumber')</th>
            <th>@lang('layout.Employee')</th>
            <th>@lang('layout.Phone')</th>
            <th>@lang('layout.FatherName')</th>
            <th>@lang('layout.GraphNumber')</th>
            <th>@lang('layout.Quality')</th>
            <th>@lang('layout.CarpetSize')</th>
            <th>@lang('layout.TextMap')</th>
            <th>@lang('layout.BorderMap')</th>
            <th>@lang('layout.Duration')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.StartDate')</th>
            <th>@lang('layout.EndDate')</th>
            <th>@lang('layout.Status')</th>
            <th>@lang('layout.Address')</th>

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->ref_no}}</td>
                <td class="center">{{$record->employee}}</td>
                <td class="center">{{$record->phone}}</td>
                <td class="center">{{$record->father_name}}</td>
                <td class="center">{{$record->graph_number}}</td>
                <td class="center">{{$record->quality}}</td>
                <td class="center">{{$record->size}}</td>
                <td class="center">{{$record->text_map}}</td>
                <td class="center">{{$record->border_map}}</td>
                <td class="center">{{$record->duration}}</td>
                <td class="center">{{convertDate($record->Date)}}</td>
                <td class="center">{{convertDate($record->start_date)}}</td>
                <td class="center">{{convertDate($record->end_date)}}</td>
                <td class="center">{{__("layout.".$record->status)}}</td>
                <td class="center">{{$record->address1}}</td>
            </tr>
        @endforeach

    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection