@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption"><i class=""></i>@lang('layout.TransferAndLoadingDetail')

            </div>
            <div class="tools"><a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table
                        class="table table-striped table-bordered table-advance table-hover">
                    <thead>

                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                    </tr>

                    </thead>
                    <tbody>
                    <tr>
                        <td class=""> {{ $cargoWastage->number}}  </td>
                        <td class=""> {{ $cargoWastage->member}}  </td>
                        <td class=""> {{ $cargoWastage->currency}}  </td>
                        <td class=""> {{myRound($cargoWastage->amount)}}  </td>
                        <td class=""> {{convertDate($cargoWastage->date)}}  </td>
                        <td class="">  {{ $cargoWastage->description}}  </td>
                        <td class=""> {{ $cargoWastage->user}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="row">


        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.TransferAndLoadingDetail')</a>
                </li>
                <!-- <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_adjustment">@lang('layout.AdjustmentDetails')</a>
                </li> -->
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{--{{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}--}}
                                        {{--<input type="hidden" name="type" value="inventory_transfer_detail"/>--}}
                                        {{--<input type="hidden" name="inventory_transfer_id"--}}
                                        {{--value="{{$cargoWastage->id}}"/>--}}
                                        {{--<button type="submit" class="btn btn-success"><i--}}
                                        {{--class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>--}}
                                        {{--{{Form::close()}}--}}

                                        {{--{{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}--}}
                                        {{--<input type="hidden" name="type" value="inventory_transfer_detail"/>--}}
                                        {{--<input type="hidden" name="inventory_transfer_id"--}}
                                        {{--value="{{$cargoWastage->id}}"/>--}}
                                        {{--<button type="submit" class="btn btn-success"><i--}}
                                        {{--class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>--}}
                                        {{--{{Form::close()}}--}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="inventory_transfer_detail">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Item')</th>
                                            <th>@lang('layout.Description') En</th>
                                            <th>@lang('layout.Description') Oth</th>
                                            <th>@lang('layout.Destination')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.Length')</th>
                                            <th>@lang('layout.Weight')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Price') </th>
                                            <th>@lang('layout.Volume')</th>
                                            <th> @lang('layout.Weight') @lang('layout.Package')</th>
                                            <th> @lang('layout.Volume') @lang('layout.Package')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab3">
                    <div class="">
                        <div class="col-md-12">
                            
                        </div>
                    </div>
                </div>


                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="cargoWastage.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$cargoWastage->id}}">
                                        <input type="hidden" name="path" value="uploads/cargoWastage">
                                        <input type="hidden" name="table_name" value="cargo_wastages">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('inventoryTransfer.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>

                {{--end of tabe--}}

            </div>
        </div>

    </div>
@endsection

@push('scripts')

    <script>

        $(document).ready(function () {
            $('#inventory_transfer_detail').DataTable({
                ajax: {

                    url: '{{route("cargoWastage.show",$cargoWastage->id)}}',
                    data: {type: 'loading'}
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'name', name: 'name'},
                    {data: 'item_description2', name: 'item_description2'},
                    {data: 'item_description3', name: 'item_description3'},
                    {data: 'site', name: 'site'},
                    {data: 'width', name: 'width'},
                    {data: 'height', name: 'height'},
                    {data: 'length', name: 'length'},
                    {data: 'weight', name: 'weight'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'price', name: 'price'},
                    {data: 'volume', name: 'volume'},
                    {data: 'package_weight', name: 'package_weight'},
                    {data: 'package_volume', name: 'package_volume'},
                ]

            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("cargoWastage.show",$cargoWastage->id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });

    </script>


@endpush

