@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <!-- new modal -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'wastage'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Customer') </label>
                            <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" placeholder="@lang('layout.Customer')" >
                            </v-select>
                            <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" >
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.ContractNumber') </label>
                            <input type="number" name="number" class="form-control" autocomplete="off">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.Type') </label>
                            <select class="form-control" name="report_type">
                                <option value="">@lang('layout.Select')</option>
                                <option value="detail">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.WastageList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoWastage-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('CargoWastage-create')
                    <a href="{{route('cargoWastage.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
            
                <div id="sites">
                    <div class="col-md-3">
                        <div class="form-group">
                            <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" @input="getData()" placeholder="@lang('layout.Customer')" >
                            </v-select>
                            <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" >
                        </div>
                    </div>
                </div>

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContracts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;

        function getRecord() {
            if (vtr.selectedMember) {
                vtr.member_id = vtr.selectedMember.id;
            }else{
                vtr.member_id = '';
            }
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cargoContracts').DataTable({
                ajax: {
                    ajax: '{{route("cargoWastage.index")}}',
                    data: {
                        member_id: vtr.member_id
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'cargo_wastages.number'},
                    {data: 'member', name: 'members.name'},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'date', name: 'cargo_wastages.date', searchable: false},
                    {data: 'description', name: 'cargo_wastages.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        }

        $(document).ready(function() {
            getRecord();
        });

        var vtr = new Vue({
            el: '#sites',
            data: {
                types: '',
                state: '',
                member: [],
                selectedMember: null,
                member_id: '',
            },
            methods: {
                getData() {
                    getRecord();
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vtr.member = [];
                            vtr.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoWastage.report") !!}',
                excelRoute: '{!! route("cargoWastage.report") !!}',
                selectedMember: null,
                member: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
