@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.ContractItems')</h3>

<h3>@lang('layout.Loading')</h3>
<table class="main-table">

    <thead>


        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th style="min-width: 100px">@lang('layout.Contract') </th>
            <th style="min-width: 100px">@lang('layout.ContractNumber') </th>
            <th style="min-width: 100px">@lang('layout.ItemName') </th>
            <th style="min-width: 100px">@lang('layout.Site') </th>
            <th style="min-width: 100px">@lang('layout.Date') </th>
            <th style="min-width: 100px">@lang('layout.Driver') </th>
            <th style="min-width: 100px">@lang('layout.PaletNumber')</th>
            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
            <th style="min-width: 100px">@lang('layout.Destination') </th>
            <th style="min-width: 100px">@lang('layout.Discharge') </th>
            <th style="min-width: 100px">@lang('layout.Measure') </th>
            <th>@lang('layout.Quantity') </th>
            <th>@lang('layout.DischargeQuantity') </th>
            <th>@lang('layout.Differ') </th>
            <th>@lang('layout.OverLoad') </th>
            <th>@lang('layout.LoadDrop') </th>
            <th>@lang('layout.FinedAmount') </th>
            <th>@lang('layout.Balance') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totales = 0;
    $qty = 0;
    $QtyOut = 0;
    $Differ = 0;
    $overLoad = 0;
    $leakage = 0;
    $fined = 0;
    $balance = 0;
    ?>
    @foreach($loadingDetails AS $srecord)
    <?php
    $totales += ($srecord->Total / $srecord->Rate);
    $qty += ($srecord->qty);
    $QtyOut += ($srecord->QtyOut + $srecord->overLoad);
    $Differ += (($srecord->QtyOut + $srecord->overLoad) - $srecord->qty);
    $overLoad += ($srecord->overLoad);
    $leakage += ($srecord->leakage);
    $fined += ($srecord->fined);
    $balance += (($srecord->qty + $srecord->overLoad) - ($srecord->QtyOut + $srecord->fined + $srecord->leakage));
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$srecord->contract}}</td>
        <td class="center">{{$srecord->contract_no}}</td>
        <td class="center">{{$srecord->items}}</td>
        <td class="center">{{$srecord->site}}</td>
        <td class="center"> {{convertDate($srecord->loading_date)}} </td>
        @if($srecord->driver_type == 'OwnDriver')
        <td class="center">{{$srecord->driver_name}}</td>
        <td class="center">{{$srecord->vehicle_palet_number}}</td>
        @else
        <td class="center">{{$srecord->other_driver_name}}</td>
        <td class="center">{{$srecord->other_vehicle_name}}</td>
        @endif
        <td class="center">{{$srecord->source}}</td>
        <td class="center">{{$srecord->destination}}</td>
        @if($srecord->state == 'On')
        <td class="center">@lang('layout.Not')</td>
        @else
        <td class="center">@lang('layout.yes')</td>
        @endif
        <td class="center">{{$srecord->measure}}</td>
        <td class="center">{{simpleRound($srecord->qty)}}</td>
        <td class="center">{{simpleRound($srecord->QtyOut + $srecord->overLoad)}}</td>
        <td class="center">{{simpleRound(($srecord->QtyOut + $srecord->overLoad) - ($srecord->qty))}}</td>
        <td class="center">{{simpleRound($srecord->overLoad)}}</td>
        <td class="center">{{simpleRound($srecord->leakage)}}</td>
        <td class="center">{{simpleRound($srecord->fined)}}</td>
        <td class="center">{{simpleRound($balance)}}</td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="12" class="center"> @lang('layout.Total') </td>
        <td colspan="1" class="center">{{simpleRound($qty)}}</td>
        <td colspan="1" class="center">{{simpleRound($QtyOut)}}</td>
        <td colspan="1" class="center">{{simpleRound($Differ)}}</td>
        <td colspan="1" class="center">{{simpleRound($overLoad)}}</td>
        <td colspan="1" class="center">{{simpleRound($leakage)}}</td>
        <td colspan="1" class="center">{{simpleRound($fined)}}</td>
        <td colspan="1" class="center">{{simpleRound($balance)}}</td>
        <!-- <td colspan="6" class="center">{{simpleRound($totales)}} {{getReportCurrency()}}</td> -->
    </tr>
</table>

<hr />
<h3>@lang('layout.Discharge')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            <th style="min-width: 100px">@lang('layout.Contract') </th>
            <th style="min-width: 100px">@lang('layout.ContractNumber') </th>
            <th style="min-width: 100px">@lang('layout.ItemName') </th>
            <th style="min-width: 100px">@lang('layout.Site') </th>
            <th style="min-width: 100px">@lang('layout.Date') </th>
            <th style="min-width: 100px">@lang('layout.Type') </th>
            <th style="min-width: 100px">@lang('layout.Driver') </th>
            <th style="min-width: 100px">@lang('layout.PaletNumber')</th>
            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
            <th style="min-width: 100px">@lang('layout.Destination') </th>
            <th style="min-width: 100px">@lang('layout.Measure') </th>
            <th>@lang('layout.Quantity') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $qty = 0;
    ?>
    @foreach($loadingDetailsDischarge AS $srecord)
    <?php
    $qty += ($srecord->qty + $srecord->overLoad);
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$srecord->contract}}</td>
        <td class="center">{{$srecord->contract_no}}</td>
        <td class="center">{{$srecord->items}}</td>
        <td class="center">{{$srecord->site}}</td>
        <td class="center"> {{convertDate($srecord->loading_date)}} </td>
        <td class="center">{{ __('layout.'.$srecord->type) }}</td>
        @if($srecord->driver_type == 'OwnDriver')
        <td class="center">{{$srecord->driver_name}}</td>
        <td class="center">{{$srecord->vehicle_palet_number}}</td>
        @else
        <td class="center">{{$srecord->other_driver_name}}</td>
        <td class="center">{{$srecord->other_vehicle_name}}</td>
        @endif
        <td class="center">{{$srecord->source}}</td>
        <td class="center">{{$srecord->destination}}</td>
        <td class="center">{{$srecord->measure}}</td>
        <td class="center">{{simpleRound($srecord->qty + $srecord->overLoad)}}</td>

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="12" class="center"> @lang('layout.Total') </td>
        <td colspan="1" class="center">{{simpleRound($qty)}}</td>
    </tr>
</table>



@endsection