@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract');
    $_code = in_array('code', $report);
    $_date = in_array('date', $report);
    $_contract_name = in_array('contract_name', $report);
    $_vendor = in_array('vendor', $report);
    $_bank = in_array('bank', $report);
    $_price = in_array('price', $report);
    $_amount = in_array('amount', $report);
    $_currency = in_array('currency', $report);
    $_rate = in_array('rate', $report);
    $_total_in_home_currency = in_array('total_in_home_currency', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.WastageReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
            <tr class="bg">
                <td class="center"><div >  @lang('layout.Record') </div></td>
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Description')</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.Quantity')</th>
                <th>@lang('layout.Currency')</th>
                <th>@lang('layout.Amount')</th>
                
                <th>@lang('layout.User')</th>
            </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <?php

            if(systemConfig()[30] == 1){
                $total_home_currency += $record->amount / $record->static_rate * $record->rate;
            }else{
                $total_home_currency += $record->amount / $record->rate;
            }


            if (array_key_exists($record->currency, $currencies)) {
                $currencies[$record->currency] = $currencies[$record->currency] + $record->amount;
            } else {

                $currencies[$record->currency] = $record->amount;
            }
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->description}}</td>
                <td class="center">{{$record->member}}</td>
                <td class="center">{{myRound($record->quantity)}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{myRound($record->amount)}}</td>
                
                <td class="center">{{$record->user}}</td>
            </tr>
        @endforeach

    </table>
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection