@extends('layouts.app')

@section('style')
<style>

</style>
@stop 

@section('content')


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET-->


<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.InventorySiteslist')</span>
            </div>
            <div class="tools"> </div> 
             <div class="btn-group pull-right">

                    @permission('inventorySite-export')

                        <span id="print-modal">

                            <a href="#" @click.prevent="is_show_modal = !is_show_modal" class="btn  btn-success">
                                 <i class="fa fa-print"></i>
                            </a>

                            <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                             v-if="is_show_modal" 
                                :value-type="'cargoSite'"
                                @closed="closeModal">


                                <div slot="body">

                                    <!----------------------------------------------
                                    ----Begin Report Body And Custome Report-------
                                    ----------------------------------------------->
                                    <div class="row" v-cloak>
                                             <div class="tabbable tabbable-tabdrop">

                                                <ul class="nav nav-tabs">
                                                    
                                                    <li class="active">
                                                        <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                                    </li>
                                                    @if(systemConfig()[2] != 0 )
                                                    @permission(['customreport-list'])
                                                    <li class="">
                                                        <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                                    </li>
                                                    @endpermission
                                                    @endif
                                                </ul>
                                                <div class="tab-content">
                                                     <div class="tab-pane active" id="tab1"> 
                                                            <div class="portlet light bordered">
                                                        
                                                                <div class="portlet-body">
                                                                       
                                                                </div>
                                                            </div>
                                                    </div> 

                                                    <div class="tab-pane" id="tab2"> 
                                                       <div class="portlet light bordered">
                                                            <div class="portlet-body">

                                                                <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                                    @csrf
                                                                    <input type="hidden" name="part_name" value="inventory_site_index">


                                                                    <div class="col-md-12 col-sm-12 col-xs-12">

                                                                        <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">
                                                                            <div class="form-group">
                                                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                                                <tr>
                                                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td style="text-align: center;">
                                                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                
                                
                                                                                                        <label class="switch">
                                                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                                            :checked="row.checkedColumn" >
                                                                                                            <span class="slider round"></span>
                                                                                                        </label>
                                                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                                            <option value="">@lang('layout.Select')</option>
                                                                                                            <option value="2">2 %</option>
                                                                                                            <option value="6">6 %</option>
                                                                                                            <option value="10">10 %</option>
                                                                                                            <option value="15">15 %</option>
                                                                                                            <option value="20">20 %</option>
                                                                                                            <option value="25">25 %</option>
                                                                                                            <option value="30">30 %</option>
                                                                                                            <option value="40">40 %</option>
                                                                                                            <option value="50">50 %</option>
                                                                                                            <option value="60">60 %</option>
                                                                                                        </select>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>
                                                                                </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="margiv-top-10">
                                                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                                        <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                                    </div>
                                                            </form>
                                                            </div>
                                                    </div>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!----------------------------------------------
                                    ----Begin Report Body And Custome Report-------
                                    ----------------------------------------------->
                                </div> 
                            </report-modal>

                        </span>
                    

                    @endpermission
                    @permission('inventorySite-create')  
                    <a href="{{route('cargoSite.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                         </button>
                    </a>
                    @endpermission 
                </div>
        </div>
        <div class="portlet-body">
            <span  v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </span>
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="cargoSite">
                <thead>
                <tr> 
                    {{--<th>@lang('layout.ID')</th>--}}
                    @if(getStockInfo()=="true")
                        <th>@lang('layout.Number')</th>
                        
                    @endif

                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Parent')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.CreatedAt')</th>
                    @if(getStockInfo()=="true")
                        <th>@lang('layout.SiteOtherName')</th>
                        <th>@lang('layout.StockManName')</th>
                        <th>@lang('layout.StockManPhone')</th>
                        <th>@lang('layout.StockAddress')</th>
                    @endif
                    <th>@lang('layout.Actions')</th>

                </tr>
                </thead> 
            </table>


        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>

    var cust_rep = {!!customeReportNewData('inventory_site_index')!!};

    let data_table;
    $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
       data_table = $('#cargoSite').DataTable( {
            ajax:           '{{route("cargoSite.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            columns: [  
            @if(getStockInfo()=="true")
            { data: 'number', name: 'number' },
            
            @endif
            { data: 'name', name: 'name' },
            { data: 'Parent', name: 'Parent',searchable:false,orderable:false},
            { data: 'description', name: 'description' },
            { data: 'created_at', name: 'created_at' },
            @if(getStockInfo()=="true")
            { data: 'other_name', name: 'other_name' },
            { data: 'stock_man_name', name: 'stock_man_name' },
            { data: 'stock_man_phone', name: 'stock_man_phone' },
            { data: 'stock_address', name: 'stock_address' },
            @endif
            { data: 'action' ,searchable:false,orderable:false },
            ] 

    } );
    } );

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function (event) {
                if(typeof data_table =='object'){
                    data_table.clear();
                    data_table.ajax.reload();
                }

            }
        }
    });    






    // print config

   new Vue({


            el: '#print-modal',
            data:{
                is_show_modal: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [
                 
                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Parent")', column_name: 'parent',checkedColumn:(cust_rep.parent)?'checked':'',column_percentage:(cust_rep.parent___percent)?cust_rep.parent___percent:''},
                 {Name: '@lang("layout.CreatedAt")', column_name: 'created_at',checkedColumn:(cust_rep.created_at)?'checked':'',column_percentage:(cust_rep.created_at___percent)?cust_rep.created_at___percent:''},
                 {Name: '@lang("layout.UpdatedAt")', column_name: 'updated_at',checkedColumn:(cust_rep.updated_at)?'checked':'',column_percentage:(cust_rep.updated_at___percent)?cust_rep.updated_at___percent:''},

                  ],
                  cust_rep:cust_rep
            },
    
            methods:{

                closeModal: function(){
                    this.is_show_modal = !this.is_show_modal;
                }
            }
        });

</script>




@endpush


