@extends('layouts.app')
@section('content')
@section('style')
@stop
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateInventorySite')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM--> 
                {!! Form::model($cargoSite, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['cargoSite.update',$cargoSite->id]]) !!}
                    <div class="form-body" id="app">
                           @if(getStockInfo()=="true")
                            <div class="col-md-7"> 
                            @else
                            <div class="col-md-9">
                            @endif 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SiteName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.SiteName')])}}
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                                <div class="col-md-9">
                                    {{Form::select('parent_id',$parent,$cargoSite->parent_id,['class' => 'form-control','placeholder' => __('layout.SelectParent')])}}
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                    
                                </div>
                            </div>
                        </div>
                        @if(getStockInfo()=="true")
                        <div class="col-md-5"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Number'):</label>
                                 <div class="col-md-9">
                                    <input type="number" name="number" class="form-control"  value="{{$cargoSite->number}}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SiteOtherName'):</label>
                                 <div class="col-md-9">
                                    <input type="text" name="other_name" class="form-control"  placeholder="@lang('layout.SiteOtherName')" value="{{$cargoSite->other_name}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockManName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('stock_man_name',null,['class' => 'form-control','placeholder' => __('layout.StockManName')])}}
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockManPhone'):</label>
                                 <div class="col-md-9">
                                    {{Form::text('stock_man_phone',null,['class' => 'form-control','placeholder' => __('layout.StockManPhone')])}}
                                </div>
                            </div>    
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockAddress'):</label>
                                 <div class="col-md-9">
                                    {{Form::text('stock_address',null,['class' => 'form-control','placeholder' => __('layout.StockAddress')])}}
                                </div>
                            </div> 
                            
                        </div>  
                        @endif
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                        <button href="{{url('cargoSite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                     </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
<script type="text/javascript">
    new Vue({
        data: {
            selected_parent:{!! $cargoSite->id !!}
        }
    })
</script>
