@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <!-- new modal -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'loading'"
            @closed="closeModal">  
            <div slot="body">
                <!----------------------------------------------
                    ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop"> 
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
    
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.Type') </label>
                                                    <select name="types" class="form-control">
                                                        <option value="">@lang('layout.SelectType')</option>
                                                        <option value="loading">@lang('layout.Loading')</option>
                                                        <option value="discharge">@lang('layout.Discharge')</option>
                                                        <option value="InventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.State') </label>
                                                    <select name="state" class="form-control">
                                                        <option value="">@lang('layout.SelectVehicleStatus')</option>
                                                        <option value="Loaded">@lang('type.fill')</option>
                                                        <option value="Empty">@lang('type.empty')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.Details') </label>
                                                    <select name="details" class="form-control">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="details">@lang('layout.LoadingCars')</option> 
                                                        <option value="allLoadingCars">@lang('layout.AllLoadingCars')</option> 
                                                    </select>
                                                </div> 
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.Number') </label>
                                                    <input type="number" name="number" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('menu.Container'):</label>
                                                    <v-select label="name" :options="vehicles" v-model="selected_container" >
                                                    </v-select>
                                                    <input type="hidden" name="container_id" :value="!selected_container?null:selected_container.id" >
                                                </div>
                        
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                              :options="memberlist">
                                                    </v-select>
                                                    <input type="hidden" name="member_id"
                                                           v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                        
                                                <div class="col-md-2" v-show="selected_container">
                                                    <label class=" control-label">@lang('layout.ProfitAndLost'):</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="profitAndLost" value="on">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                        
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                        
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
    
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_loading_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button style="margin-top: 10px !important;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                {{-- <button style="margin-top: 10px !important;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_loadingOnHand_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('layout.OnHand')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportOnHand">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_transferAndLoading_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('layout.TransferAndLoading')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportTransferAndLoading">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_Delivery_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('menu.Delivery')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportDelivery">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_ItemExpense_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('menu.ItemExpense')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportItemExpense">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_AdjustmentList_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('layout.AdjustmentList')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportAdjustmentList">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                        <hr>
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="cargo_total_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <h4 style="margin-bottom: 30px;">  @lang('layout.Total')  </h4>
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportTotal">
                                                    <div class="form-group" style="margin: 1px;">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                {{-- <button style="margin-top: 10px;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                                <button style="margin-top: 10px;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
    
                        </div>
                    </div>
                </div>
    
    
            </div>
        </report-modal>
    </div>
    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'loading'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.Type') </label>
                            <select name="types" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="loading">@lang('layout.Loading')</option>
                                <option value="discharge">@lang('layout.Discharge')</option>
                                <option value="InventoryTransfer">@lang('layout.InventoryTransfer')</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.State') </label>
                            <select name="state" class="form-control">
                                <option value="">@lang('layout.SelectVehicleStatus')</option>
                                <option value="Loaded">@lang('type.fill')</option>
                                <option value="Empty">@lang('type.empty')</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.Details') </label>
                            <select name="details" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                <option value="details">@lang('layout.LoadingCars')</option> 
                                <option value="allLoadingCars">@lang('layout.AllLoadingCars')</option> 
                            </select>
                        </div> 
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.Number') </label>
                            <input type="number" name="number" class="form-control" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label">@lang('menu.Container'):</label>
                            <v-select label="name" :options="vehicles" v-model="selected_container" >
                            </v-select>
                            <input type="hidden" name="container_id" :value="!selected_container?null:selected_container.id" >
                        </div>

                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                        <div class="col-md-2" v-show="selected_container">
                            <label class=" control-label">@lang('layout.ProfitAndLost'):</label>
                            <div class="col-md-12 mt-checkbox">
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" name="profitAndLost" value="on">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.TransferAndLoadingList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoContract-onHand')
                    <a href="{{route('cargoContract.indexStock')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.InStock')
                        </button>
                    </a>
                    @endpermission
                    @permission('CargoLoading-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('CargoLoading-create')
                    <a href="{{route('cargoLoading.discharge_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Discharge')
                        </button>
                    </a>
                    <a href="{{route('cargoLoading.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Loading')
                        </button>
                    </a>
                    <a href="{{route('cargoLoading.change_site_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.InventoryTransfer')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
            
                <div id="sites">
                    <div class="col-md-3">
                        <div class="form-group">
                            <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                            <select name="site_id" @Click="getData()" v-model="types" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="loading">@lang('layout.Loading')</option>
                                <option value="discharge">@lang('layout.Discharge')</option>
                                <option value="InventoryTransfer">@lang('layout.InventoryTransfer')</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                            <select name="source" @Click="getData()" v-model="state" class="form-control">
                                <option value="">@lang('layout.SelectVehicleStatus')</option>
                                <option value="Loaded">@lang('type.fill')</option>
                                <option value="Empty">@lang('type.empty')</option>
                                
                            </select>
                        </div>
                    </div>
                </div>

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContracts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('menu.Container')</th>
                        <th>@lang('menu.Vehicle')</th>
                        <th>@lang('layout.TransitNumber')</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Responsible')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div> 
    <!-- END CONTENT BODY --> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts') 
    <script> 
        Vue.component("v-select", VueSelect.VueSelect);
        var cust_rep = {!!customeReportNewData('cargo_loading_index')!!}; 
        var cust_repOnHand = {!!customeReportNewData('cargo_loadingOnHand_index')!!}; 
        var cust_repTransferAndLoading = {!!customeReportNewData('cargo_transferAndLoading_index')!!}; 
        var cust_repDelivery = {!!customeReportNewData('cargo_Delivery_index')!!}; 
        var cust_repItemExpense = {!!customeReportNewData('cargo_ItemExpense_index')!!}; 
        var cust_repAdjustmentList = {!!customeReportNewData('cargo_AdjustmentList_index')!!}; 
        var cust_repTotal = {!!customeReportNewData('cargo_total_index')!!}; 
        let data_table ;
        function getRecord() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cargoContracts').DataTable({
                ajax: '{{route("cargoLoading.index")}}',

                ajax: {
                    ajax: '{{route("cargoLoading.index")}}',
                    data: {
                        types: vtr.types,
                        state: vtr.state
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'cargo_loadings.number'},
                    {data: 'type', name: 'cargo_loadings.type'},
                    {data: 'container', name: 'vehicles.vehicle_name', searchable: false},
                    {data: 'vehicle', name: 'vehicles.vehicle_name', searchable: false},
                    {data: 'transit_number', name: 'vehicles.transit_number', searchable: false},
                    {data: 'source_site', name: 'source_site', searchable: false},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'date', name: 'cargo_loadings.date', searchable: false},
                    {data: 'state', name: 'inventory_sites.name', orderable: false, searchable: false},
                    {data: 'employee', name: 'members.name'},
                    {data: 'description', name: 'cargo_loadings.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        }
        $(document).ready(function() {
            getRecord();
        });
        var vtr = new Vue({
            el: '#sites',
            data: {
                types: '',
                state: '',
                loadingDestinationSel: 0,
            },
            methods: {
                getData() {
                    getRecord();
                }
            }
        });
        var vehicles = {!!$vehicles!!};

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoLoading.report") !!}',
                excelRoute: '{!! route("cargoLoading.report") !!}',
                selected_container: null,
                vehicles: vehicles,
                selectedMember: null,
                member: null,
                selectedMember: null,
                memberlist: [], 
                customReportData:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.CustomerName")', column_name: 'customer_name',checkedColumn:(cust_rep.customer_name)?'checked':'',column_percentage:(cust_rep.customer_name___percent)?cust_rep.customer_name___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                    {Name: '@lang("layout.Fabric")', column_name: 'fabric',checkedColumn:(cust_rep.fabric)?'checked':'',column_percentage:(cust_rep.fabric___percent)?cust_rep.fabric___percent:''},
                    {Name: '@lang("layout.CartanQty")', column_name: 'carton_quantity',checkedColumn:(cust_rep.carton_quantity)?'checked':'',column_percentage:(cust_rep.carton_quantity___percent)?cust_rep.carton_quantity___percent:''},
                    {Name: '@lang("layout.TotalMetraj")', column_name: 'total_metraj',checkedColumn:(cust_rep.total_metraj)?'checked':'',column_percentage:(cust_rep.total_metraj___percent)?cust_rep.total_metraj___percent:''},
                    {Name: '@lang("layout.TotalWazn")', column_name: 'total_wazn',checkedColumn:(cust_rep.total_wazn)?'checked':'',column_percentage:(cust_rep.total_wazn___percent)?cust_rep.total_wazn___percent:''},
                    {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                    {Name: '@lang("layout.TotalPrice")', column_name: 'total_price',checkedColumn:(cust_rep.total_price)?'checked':'',column_percentage:(cust_rep.total_price___percent)?cust_rep.total_price___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                    {Name: '@lang("layout.ContainerNumber")', column_name: 'container_number',checkedColumn:(cust_rep.container_number)?'checked':'',column_percentage:(cust_rep.container_number___percent)?cust_rep.container_number___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''}, 
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''}, 
                    {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''}, 
                    {Name: '@lang("layout.Vehicle")', column_name: 'vehicle',checkedColumn:(cust_rep.vehicle)?'checked':'',column_percentage:(cust_rep.vehicle___percent)?cust_rep.vehicle___percent:''}, 
                    {Name: '@lang("layout.Source")', column_name: 'source',checkedColumn:(cust_rep.source)?'checked':'',column_percentage:(cust_rep.source___percent)?cust_rep.source___percent:''}, 
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''}, 
                    {Name: '@lang("layout.Responsible")', column_name: 'responsible',checkedColumn:(cust_rep.responsible)?'checked':'',column_percentage:(cust_rep.responsible___percent)?cust_rep.responsible___percent:''}, 
                    {Name: '@lang("layout.TransitNumber")', column_name: 'transite_number',checkedColumn:(cust_rep.transite_number)?'checked':'',column_percentage:(cust_rep.transite_number___percent)?cust_rep.transite_number___percent:''}, 
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''}, 
                ],
                cust_rep:cust_rep,
                customReportOnHand:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record1',checkedColumn:(cust_repOnHand.record1)?'checked':'',column_percentage:(cust_repOnHand.record1___percent)?cust_repOnHand.record1___percent:''},
                    {Name: '@lang("menu.Container")', column_name: 'container1',checkedColumn:(cust_repOnHand.container1)?'checked':'',column_percentage:(cust_repOnHand.container1___percent)?cust_repOnHand.container1___percent:''},
                    {Name: '@lang("layout.Source")', column_name: 'source1',checkedColumn:(cust_repOnHand.source1)?'checked':'',column_percentage:(cust_repOnHand.source1___percent)?cust_repOnHand.source1___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName1',checkedColumn:(cust_repOnHand.itemName1)?'checked':'',column_percentage:(cust_repOnHand.itemName1___percent)?cust_repOnHand.itemName1___percent:''},
                    {Name: '@lang("layout.Width")', column_name: 'width1',checkedColumn:(cust_repOnHand.width1)?'checked':'',column_percentage:(cust_repOnHand.width1___percent)?cust_repOnHand.width1___percent:''},
                    {Name: '@lang("layout.Length")', column_name: 'length1',checkedColumn:(cust_repOnHand.length1)?'checked':'',column_percentage:(cust_repOnHand.length1___percent)?cust_repOnHand.length1___percent:''},
                    {Name: '@lang("layout.Height")', column_name: 'height1',checkedColumn:(cust_repOnHand.height1)?'checked':'',column_percentage:(cust_repOnHand.height1___percent)?cust_repOnHand.height1___percent:''},
                    {Name: '@lang("layout.Volume")', column_name: 'volume1',checkedColumn:(cust_repOnHand.volume1)?'checked':'',column_percentage:(cust_repOnHand.volume1___percent)?cust_repOnHand.volume1___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight1',checkedColumn:(cust_repOnHand.weight1)?'checked':'',column_percentage:(cust_repOnHand.weight1___percent)?cust_repOnHand.weight1___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity1',checkedColumn:(cust_repOnHand.quantity1)?'checked':'',column_percentage:(cust_repOnHand.quantity1___percent)?cust_repOnHand.quantity1___percent:''},
                    {Name: '@lang("layout.Price")', column_name: 'price1',checkedColumn:(cust_repOnHand.price1)?'checked':'',column_percentage:(cust_repOnHand.price1___percent)?cust_repOnHand.price1___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency1',checkedColumn:(cust_repOnHand.currency1)?'checked':'',column_percentage:(cust_repOnHand.currency1___percent)?cust_repOnHand.currency1___percent:''},
                ],
                cust_repOnHand:cust_repOnHand,
                customReportTransferAndLoading:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record2',checkedColumn:(cust_repTransferAndLoading.record2)?'checked':'',column_percentage:(cust_repTransferAndLoading.record2___percent)?cust_repTransferAndLoading.record2___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number2',checkedColumn:(cust_repTransferAndLoading.number2)?'checked':'',column_percentage:(cust_repTransferAndLoading.number2___percent)?cust_repTransferAndLoading.number2___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date2',checkedColumn:(cust_repTransferAndLoading.date2)?'checked':'',column_percentage:(cust_repTransferAndLoading.date2___percent)?cust_repTransferAndLoading.date2___percent:''},
                    {Name: '@lang("layout.Type")', column_name: 'type2',checkedColumn:(cust_repTransferAndLoading.type2)?'checked':'',column_percentage:(cust_repTransferAndLoading.type2___percent)?cust_repTransferAndLoading.type2___percent:''},
                    {Name: '@lang("layout.Responsible")', column_name: 'responsible2',checkedColumn:(cust_repTransferAndLoading.responsible2)?'checked':'',column_percentage:(cust_repTransferAndLoading.responsible2___percent)?cust_repTransferAndLoading.responsible2___percent:''},
                    {Name: '@lang("menu.Container")', column_name: 'container2',checkedColumn:(cust_repTransferAndLoading.container2)?'checked':'',column_percentage:(cust_repTransferAndLoading.container2___percent)?cust_repTransferAndLoading.container2___percent:''},
                    {Name: '@lang("layout.Vehicle")', column_name: 'vehicle2',checkedColumn:(cust_repTransferAndLoading.vehicle2)?'checked':'',column_percentage:(cust_repTransferAndLoading.vehicle2___percent)?cust_repTransferAndLoading.vehicle2___percent:''},
                    {Name: '@lang("layout.Driver")', column_name: 'driver2',checkedColumn:(cust_repTransferAndLoading.driver2)?'checked':'',column_percentage:(cust_repTransferAndLoading.driver2___percent)?cust_repTransferAndLoading.driver2___percent:''},
                    {Name: '@lang("layout.WayBillNumber")', column_name: 'wayBillNumber2',checkedColumn:(cust_repTransferAndLoading.wayBillNumber2)?'checked':'',column_percentage:(cust_repTransferAndLoading.wayBillNumber2___percent)?cust_repTransferAndLoading.wayBillNumber2___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site2',checkedColumn:(cust_repTransferAndLoading.site2)?'checked':'',column_percentage:(cust_repTransferAndLoading.site2___percent)?cust_repTransferAndLoading.site2___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName2',checkedColumn:(cust_repTransferAndLoading.itemName2)?'checked':'',column_percentage:(cust_repTransferAndLoading.itemName2___percent)?cust_repTransferAndLoading.itemName2___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight2',checkedColumn:(cust_repTransferAndLoading.weight2)?'checked':'',column_percentage:(cust_repTransferAndLoading.weight2___percent)?cust_repTransferAndLoading.weight2___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity2',checkedColumn:(cust_repTransferAndLoading.quantity2)?'checked':'',column_percentage:(cust_repTransferAndLoading.quantity2___percent)?cust_repTransferAndLoading.quantity2___percent:''},
                ],
                cust_repTransferAndLoading:cust_repTransferAndLoading,
                customReportDelivery:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record3',checkedColumn:(cust_repDelivery.record3)?'checked':'',column_percentage:(cust_repDelivery.record3___percent)?cust_repDelivery.record3___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number3',checkedColumn:(cust_repDelivery.number3)?'checked':'',column_percentage:(cust_repDelivery.number3___percent)?cust_repDelivery.number3___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date3',checkedColumn:(cust_repDelivery.date3)?'checked':'',column_percentage:(cust_repDelivery.date3___percent)?cust_repDelivery.date3___percent:''},
                    {Name: '@lang("menu.Container")', column_name: 'container3',checkedColumn:(cust_repDelivery.container3)?'checked':'',column_percentage:(cust_repDelivery.container3___percent)?cust_repDelivery.container3___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description3',checkedColumn:(cust_repDelivery.description3)?'checked':'',column_percentage:(cust_repDelivery.description3___percent)?cust_repDelivery.description3___percent:''},
                    {Name: '@lang("menu.Item")', column_name: 'item3',checkedColumn:(cust_repDelivery.item3)?'checked':'',column_percentage:(cust_repDelivery.item3___percent)?cust_repDelivery.item3___percent:''},
                    {Name: '@lang("layout.Destination")', column_name: 'destination3',checkedColumn:(cust_repDelivery.destination3)?'checked':'',column_percentage:(cust_repDelivery.destination3___percent)?cust_repDelivery.destination3___percent:''},
                    {Name: '@lang("layout.Width")', column_name: 'width3',checkedColumn:(cust_repDelivery.width3)?'checked':'',column_percentage:(cust_repDelivery.width3___percent)?cust_repDelivery.width3___percent:''},
                    {Name: '@lang("layout.Height")', column_name: 'height3',checkedColumn:(cust_repDelivery.height3)?'checked':'',column_percentage:(cust_repDelivery.height3___percent)?cust_repDelivery.height3___percent:''},
                    {Name: '@lang("layout.Length")', column_name: 'length3',checkedColumn:(cust_repDelivery.length3)?'checked':'',column_percentage:(cust_repDelivery.length3___percent)?cust_repDelivery.length3___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight3',checkedColumn:(cust_repDelivery.weight3)?'checked':'',column_percentage:(cust_repDelivery.weight3___percent)?cust_repDelivery.weight3___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity3',checkedColumn:(cust_repDelivery.quantity3)?'checked':'',column_percentage:(cust_repDelivery.quantity3___percent)?cust_repDelivery.quantity3___percent:''},
                    {Name: '@lang("layout.Volume")', column_name: 'volume3',checkedColumn:(cust_repDelivery.volume3)?'checked':'',column_percentage:(cust_repDelivery.volume3___percent)?cust_repDelivery.volume3___percent:''},
                ],
                cust_repDelivery:cust_repDelivery,
                customReportItemExpense:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record4',checkedColumn:(cust_repItemExpense.record4)?'checked':'',column_percentage:(cust_repItemExpense.record4___percent)?cust_repItemExpense.record4___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date4',checkedColumn:(cust_repItemExpense.date4)?'checked':'',column_percentage:(cust_repItemExpense.date4___percent)?cust_repItemExpense.date4___percent:''},
                    {Name: '@lang("menu.Container")', column_name: 'container4',checkedColumn:(cust_repItemExpense.container4)?'checked':'',column_percentage:(cust_repItemExpense.container4___percent)?cust_repItemExpense.container4___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName4',checkedColumn:(cust_repItemExpense.itemName4)?'checked':'',column_percentage:(cust_repItemExpense.itemName4___percent)?cust_repItemExpense.itemName4___percent:''},
                    {Name: '@lang("layout.SiteName")', column_name: 'siteName4',checkedColumn:(cust_repItemExpense.siteName4)?'checked':'',column_percentage:(cust_repItemExpense.siteName4___percent)?cust_repItemExpense.siteName4___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight4',checkedColumn:(cust_repItemExpense.weight4)?'checked':'',column_percentage:(cust_repItemExpense.weight4___percent)?cust_repItemExpense.weight4___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity4',checkedColumn:(cust_repItemExpense.quantity4)?'checked':'',column_percentage:(cust_repItemExpense.quantity4___percent)?cust_repItemExpense.quantity4___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency4',checkedColumn:(cust_repItemExpense.currency4)?'checked':'',column_percentage:(cust_repItemExpense.currency4___percent)?cust_repItemExpense.currency4___percent:''},
                    {Name: '@lang("layout.Rate")', column_name: 'rate4',checkedColumn:(cust_repItemExpense.rate4)?'checked':'',column_percentage:(cust_repItemExpense.rate4___percent)?cust_repItemExpense.rate4___percent:''},
                    {Name: '@lang("layout.TotalExpenses")', column_name: 'totalExpenses4',checkedColumn:(cust_repItemExpense.totalExpenses4)?'checked':'',column_percentage:(cust_repItemExpense.totalExpenses4___percent)?cust_repItemExpense.totalExpenses4___percent:''},
                ],
                cust_repItemExpense:cust_repItemExpense,
                customReportAdjustmentList:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record5',checkedColumn:(cust_repAdjustmentList.record5)?'checked':'',column_percentage:(cust_repAdjustmentList.record5___percent)?cust_repAdjustmentList.record5___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number5',checkedColumn:(cust_repAdjustmentList.number5)?'checked':'',column_percentage:(cust_repAdjustmentList.number5___percent)?cust_repAdjustmentList.number5___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date5',checkedColumn:(cust_repAdjustmentList.date5)?'checked':'',column_percentage:(cust_repAdjustmentList.date5___percent)?cust_repAdjustmentList.date5___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName5',checkedColumn:(cust_repAdjustmentList.itemName5)?'checked':'',column_percentage:(cust_repAdjustmentList.itemName5___percent)?cust_repAdjustmentList.itemName5___percent:''},
                    {Name: '@lang("layout.SiteName")', column_name: 'siteName5',checkedColumn:(cust_repAdjustmentList.siteName5)?'checked':'',column_percentage:(cust_repAdjustmentList.siteName5___percent)?cust_repAdjustmentList.siteName5___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight5',checkedColumn:(cust_repAdjustmentList.weight5)?'checked':'',column_percentage:(cust_repAdjustmentList.weight5___percent)?cust_repAdjustmentList.weight5___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity5',checkedColumn:(cust_repAdjustmentList.quantity5)?'checked':'',column_percentage:(cust_repAdjustmentList.quantity5___percent)?cust_repAdjustmentList.quantity5___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency5',checkedColumn:(cust_repAdjustmentList.currency5)?'checked':'',column_percentage:(cust_repAdjustmentList.currency5___percent)?cust_repAdjustmentList.currency5___percent:''},
                    {Name: '@lang("layout.Rate")', column_name: 'rate5',checkedColumn:(cust_repAdjustmentList.rate5)?'checked':'',column_percentage:(cust_repAdjustmentList.rate5___percent)?cust_repAdjustmentList.rate5___percent:''},
                    {Name: '@lang("layout.Price")', column_name: 'price5',checkedColumn:(cust_repAdjustmentList.price5)?'checked':'',column_percentage:(cust_repAdjustmentList.price5___percent)?cust_repAdjustmentList.price5___percent:''},
                    {Name: '@lang("layout.Total")', column_name: 'total5',checkedColumn:(cust_repAdjustmentList.total5)?'checked':'',column_percentage:(cust_repAdjustmentList.total5___percent)?cust_repAdjustmentList.total5___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description5',checkedColumn:(cust_repAdjustmentList.description5)?'checked':'',column_percentage:(cust_repAdjustmentList.description5___percent)?cust_repAdjustmentList.description5___percent:''},
                ],
                cust_repAdjustmentList:cust_repAdjustmentList,
                customReportTotal:
                [ 
                    {Name: '@lang("layout.Currency")', column_name: 'currency5',checkedColumn:(cust_repTotal.currency5)?'checked':'',column_percentage:(cust_repTotal.currency5___percent)?cust_repTotal.currency5___percent:''},
                    {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_repTotal.amount)?'checked':'',column_percentage:(cust_repTotal.amount___percent)?cust_repTotal.amount___percent:''},
                    {Name: '@lang("layout.Adjustment")', column_name: 'adjustment',checkedColumn:(cust_repTotal.adjustment)?'checked':'',column_percentage:(cust_repTotal.adjustment___percent)?cust_repTotal.adjustment___percent:''},
                    {Name: '@lang("layout.TotalExpenses")', column_name: 'totalExpense',checkedColumn:(cust_repTotal.totalExpense)?'checked':'',column_percentage:(cust_repTotal.totalExpense___percent)?cust_repTotal.totalExpense___percent:''},
                    {Name: '@lang("layout.Income")', column_name: 'income',checkedColumn:(cust_repTotal.income)?'checked':'',column_percentage:(cust_repTotal.income___percent)?cust_repTotal.income___percent:''},
                ],
                cust_repTotal:cust_repTotal,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },  
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data; 
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()), 
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
