@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReport('contract_detail');
    $_name = in_array('name', $report);
    $_symbol = in_array('symbol', $report);
    $_quantity = in_array('quantity', $report);
    $_price = in_array('price', $report);
    $_total = in_array('total', $report);
    ?>
    <h3>@lang('layout.TransferAndLoadingReport')</h3>
    <table style="width: 100%; margin-bottom: 10px;" class="main-table">
        @if($deliveryInfo && $deliveryInfo !=[])
        <thead>
            <tr>
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.Type')</th>
                <th>@lang('menu.Container')</th>
                <th>@lang('menu.Vehicle')</th>
                <th>@lang('layout.Site')</th>
                <th>@lang('layout.Driver')</th>
                <th>@lang('layout.TransitNumber')</th>
                <th>@lang('layout.WayBillNumber')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Status')</th>
                <th>@lang('layout.Responsible')</th>
                <th>@lang('layout.Description')</th>
                <th>@lang('layout.User')</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class=""> {{ $deliveryInfo->number}}  </td>
                <td class=""> {!! __('layout.' . ucfirst($deliveryInfo->type)) !!} </td>
                <td class=""> {{ $deliveryInfo->container}}  </td>
                <td class=""> {{ $deliveryInfo->vehicle}}  </td>
                <td class=""> {{ $deliveryInfo->source_site}}  </td>
                <td class=""> {{ $deliveryInfo->driver}}  </td>
                <td class=""> {{ $deliveryInfo->transit_number}}  </td>
                <td class=""> {{ $deliveryInfo->cmr_number}}  </td>
                <td class=""> {{convertDate($deliveryInfo->date)}}  </td>
                <td class=""> @if($deliveryInfo->state == "Loaded") {{ __('layout.Active')}} @else  {{ __('layout.Empty')}} @endif </td>
                <td class="">  {{ $deliveryInfo->employee}}  </td>
                <td class="">  {{ $deliveryInfo->description}}  </td>
                <td class=""> {{ $deliveryInfo->user}}  </td>
            </tr>
        </tbody>
        @endif

    </table>


    <table class="main-table">
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record')  </div>
            </td>
            <th>@lang('layout.Customer')</th>
            <th>@lang('layout.Item')</th>
            <th>@lang('layout.Description') </th>
            <th>@lang('layout.Description') </th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Price') </th>
            <th>@lang('layout.Volume')</th>
        </tr>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$record->member}}</td>
            <td class="center">{{$record->name}}</td>
            <td class="center">{{$record->item_description2}}</td>
            <td class="center">{{$record->item_description3}}</td>
            <td class="center">{{$record->destination}}</td>
            <td class="center">{{$record->width}}</td>
            <td class="center">{{$record->height}}</td>
            <td class="center">{{$record->length}}</td>
            <td class="center">{{$record->weight}}</td>
            <td class="center">{{$record->quantity}}</td>
            <td class="center">{{$record->price}}</td>
            <td class="center">{{$record->volume}}</td>
        </tr>
        @endforeach
    </table>

    <table>
        <tr>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection