@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Transfer') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'cargoLoading.change_site_store','method' => 'POST','class' => 'form-horizontal','id'=>'contract-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-9  col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    {{Form::number('number',$number,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
										<div class="col-md-12">
											<label class="control-label">@lang('menu.Container'):</label>
											  <v-select label="name" :options="container"  @input="selectItems()" v-model="selected_container" >
											</v-select>
											<input type="hidden" name="container_id"
											   :value="!selected_container?null:selected_container.id"
											   v-validate="'required'" data-vv-as="@lang('menu.Container')" >
											<input type="hidden" name="cargo_loadings_id" :value="!selected_container?null:selected_container.cargo_loadings_id" >
                                               <span class="required">@{{ errors.first('container_id') }}</span>
										</div>
									</div>
                                </div>
                                <div class="col-md-3" v-if="((!selected_driver)?null:selected_driver.driver_type) == 'OwnDriver'">
                                    <div class="form-group">
										<div class="col-md-12">
											<label class="control-label">@lang('menu.Vehicle'):</label>
											  <v-select label="name" :options="vehicles" disabled
												v-model="selected_vehicle" >
											</v-select>
											<input type="hidden" name="vehicle_id" :value="!selected_vehicle?null:selected_vehicle.id" >
										</div>
									</div>
                                </div>
                                
                                <div class="col-md-3" v-if="((!selected_driver)?null:selected_driver.driver_type) == 'ForeignDriver'" >
                                    <div class="form-group">
										<div class="">
                                            <label class="control-label">@lang('layout.Driver')</label>
                                            <input type="text" name="other_driver_name" class="form-control" readonly :value="(!cargoLoading)?null:cargoLoading.other_driver_name" >
										</div>
									</div>
								</div> 
                                <div class="col-md-3" v-if="((!selected_driver)?null:selected_driver.driver_type) == 'ForeignDriver'" >
                                    <div class="form-group">
										<div class="">
                                            <label class="control-label">@lang('menu.Vehicle')</label>
                                            <input type="text" name="other_vehicle_name" class="form-control" readonly :value="(!cargoLoading)?null:cargoLoading.other_vehicle_name" >
										</div>
									</div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Destination')</label>
                                    <v-select class="vue-select2" v-model="selectedDestination" label="name"  :options="sites">
                                    </v-select>
                                    <input type="hidden" name="destination_id" autocomplete="off"
                                           v-model.number="(!selectedDestination)?null:selectedDestination.id"
                                           v-validate="'required'" data-vv-as="@lang('layout.Destination')">
                                    <span class="required">@{{ errors.first('destination_id') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Driver')</label>
                                    <v-select class="vue-select2" v-model="selected_driver" disabled label="name" :options="driver">
                                    </v-select>
                                    <input type="hidden" name="driver_id" v-model.number="(!selected_driver)?null:selected_driver.id" >
                                    <input type="hidden" name="driver_type" v-model.number="(!selected_driver)?null:selected_driver.driver_type" >
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.TransitNumber')</label>
                                    <input type="text" name="transit_number" class="form-control" readonly :value="(!cargoLoading)?null:cargoLoading.transit_number" >
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.WayBillNumber')</label>
                                    <input type="text" name="cmr_number" class="form-control" readonly :value="(!cargoLoading)?null:cargoLoading.cmr_number" >
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date"  name="date" autocomplete="off">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Responsible')</label>
                                    <v-select class="vue-select2" v-model="selectedEmployee" label="name" @search="EmployeeSearch" :options="employee">
                                    </v-select>
                                    <input type="hidden" name="employee_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                                
                            </div>
                            
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Quantity') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span data-counter="counterup" data-value="7800">
                                                @{{ format_number(Number.parseFloat(subtotal))}}
                                            </span>
                                            <small class="font-green-sharp">
                                                BX
                                            </small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Weight') @lang('layout.Package') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(package_weight))}}</span>
                                            <small class="font-green-sharp">
                                                KG
                                            </small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Volume') @lang('layout.Package') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                @{{ format_number(Number(package_volume))}}
                                            </span>
                                            <small class="font-green-sharp">
                                                m3
                                            </small>
                                        </td>
                                    </tr>
                                </table>

                            </div>
                            <!-- end total -->

                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 100px">@lang('layout.Customer')</th>
                                <th style="min-width: 100px">@lang('layout.Item') / @lang('layout.Source')</th>
                                <th style="min-width: 100px">@lang('layout.Description') En / Oth</th>
                                <th style="min-width: 100px">@lang('layout.Width') / @lang('layout.Length') </th>
                                <th style="min-width: 100px">@lang('layout.Height') / @lang('layout.Volume')</th>
                                <th style="min-width: 100px">@lang('layout.Weight') / @lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.Density') </th>
                                <th style="min-width: 100px"> @lang('layout.Weight') @lang('layout.Package') / @lang('layout.Volume') @lang('layout.Package')</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                
                                <td class="highlight">
                                        <!-- <v-select placeholder="@lang('layout.Customer') " label="name" @search="MemberSearch" :options="member" @click.native="addNew('inventory',index)" @keyup.native="addNew('inventory',index)" v-model="item.selectedMember"></v-select>
                                        <input type="hidden" :name="'member_id['+index+']'" :value="(item.selectedMember)?item.selectedMember.id:null"> -->
                                        <input type="text" readonly class="form-control"  :value="(item.item)?item.item.member:null">
                                </td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.Item') " label="name" disabled :options="temp_items" v-model="item.item"></v-select>
                                    <input type="hidden" :name="'item_id['+index+']'" :value="(item.item)?item.item.id:null">
                                    
                                    <input class="form-control" type="text" placeholder="@lang('layout.Source')"   :value="(item.item)?item.item.source:null" readonly class="form-control">
                                    <input  type="hidden" :name="'source_id['+index+']'" :value="(item.item)?item.item.source_id:null" >
                                </td>
                                <td class="highlight">
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') Fa" :value="(item.item)?item.item.item_description2:null" class="form-control">
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') En" :value="(item.item)?item.item.item_description3:null" class="form-control">
                                </td>
                                <td>
                                    <input type="number" :name="'width['+index+']'" :value="(item.item)?item.item.width:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Width')">
                                    <input type="number" :name="'length['+index+']'" :value="(item.item)?item.item.length:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Length')"> 
                                </td>
                                <td>
                                    <input type="number" :name="'height['+index+']'" :value="(item.item)?item.item.height:null" readonly class="form-control " placeholder="@lang('layout.Height')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'volume['+index+']'" :value="(item.item)?item.item.volume:null" readonly class="form-control " placeholder="@lang('layout.Volume')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>

                                <td>
                                    <input type="number" :name="'weight['+index+']'" :value="(item.item)?item.item.weight:null" readonly class="form-control " placeholder="@lang('layout.Weight')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <div class="input-group">
                                        <input type="number" :name="'quantity_in['+index+']'" v-validate="''" readonly
                                           data-vv-as="@lang('layout.Quantity')" v-model.number="item.quantity" @input="selectVolumeQu(index), selectPackageWeightQu(index)"
                                           class="form-control " placeholder="@lang('layout.Quantity')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                        <span class="input-group-addon">
                                            @{{(item.item)?item.item.quantity:0}}
                                        </span>
                                    </div>
                                    <span class="required">@{{ errors.first('quantity_in['+index+']') }}</span>
                                </td>
                                <td>
                                    @{{ (item==null)?null:getDensity(index) }}
                                </td>
                                <td>
                                    <input type="number" :name="'package_weight['+index+']'" :value="(item.item)?item.package_weight:null" readonly class="form-control " placeholder="@lang('layout.Weight') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'package_volume['+index+']'" :value="(item.item)?item.package_volume:null" readonly class="form-control " placeholder="@lang('layout.Volume') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>
                                <td>
                                    <!-- <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span> -->
                                </td>
                            </tr>
                            <!-- <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr> -->
                            </tbody>
                        </table>
                        <hr/>
                        <br/>
                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>
                    <!-- end item -->

                    <hr> 
                    <h3>@lang('layout.Location')</h3>
                    <div class="row" >
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th style="min-width: 100px">@lang('layout.Driver') </th>
                                <th style="min-width: 130px">@lang('menu.Container') </th>
                                <th style="min-width: 50px">@lang('layout.Location') </th>
                                <th style="min-width: 50px">@lang('layout.Source') </th>
                                <th style="min-width: 50px">@lang('layout.Destination') </th>
                                <th style="min-width: 50px">@lang('layout.Description') </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <span >
                                <td>
                                    @{{(selected_driver==null)?null:selected_driver.name}}
                                    <input type="hidden" name="loc_driver_id" class="form-control" :value="(selected_driver==null)?null:selected_driver.id" >
                                </td>
                                <td>
                                    @{{(!selected_container)?null:selected_container.name}}
                                    <input type="hidden" name="loc_vehicle_id" class="form-control" :value="(selected_container==null)?null:selected_container.id" >
                                </td>
                                <td>
                                    <input type="hidden" name="loc_state" class="form-control" value="fill" >
                                    <input type="text" name="loc_location" v-model="location" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_source" v-model="source" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_destination" v-model="destination" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_description" class="form-control input-style" >
                                </td>
                                </span>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('cargoContract.indexStock')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        var currency = {!! $currency!!}
        var inventorySite = {!! $inventorySite !!};
        // group of company
        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        var vehicles = {!!$vehicles!!};
        var container = {!!$container!!};
        var driver = {!!$driver!!};

        var v = new Vue({
            el: '#app',
            data: {
                currency: currency,
                selected_currency: homeCurrency,
                driver: driver,
                selected_driver: null,
                cargoLoading: null,
                employee: [],
                selectedEmployee: null,
                member: [],
                selectedMember: null,
                selectedDestination: null,
                location: null,
                source: null,
                destination: null,
                listAccounts: [],
                type: 'bank',
                rate: 0,
                temp_items: [],
                sites: inventorySite,
                inventory_category: inventorySite,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                container:container,
                vehicles:vehicles,
                selected_vehicle:null,
                selected_container:null,
                payments: [],
                inventories: [
                    {item: null, selectedMember: null, destination: null, density: null, height: null, length: null, price: null, quantity: null, 
                    volume: null, weight: null, width: null, package_volume: null, package_weight: null}
                ],
                discountFiled: 0,
                discountIsAmount: true,
                package_weight: 0,
                package_volume: 0,
            },
            computed: {

                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    return rates;

                },
                
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // check payed amount
                payeds: function() {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var package_weight = 0;
                    var package_volume = 0;
                    
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].quantity != null) {
                            var quantity = Number.parseFloat(this.inventories[i].quantity);
                            var temp = quantity;

                            if (this.inventories[i].package_weight > 0) {
                                package_weight += Number.parseFloat(this.inventories[i].package_weight);
                            }
                            if (this.inventories[i].package_volume > 0) {
                                package_volume += Number.parseFloat(this.inventories[i].package_volume);
                            }
                            
                            sum += temp;
                        }
                    }
                    this.package_weight = package_weight;
                    this.package_volume = package_volume;
                    return sum;
                },


                
            },
            mounted: function() {
                
            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // calculate item price based on measure change
                    getTolal(index) {
                        var temp = 0;
                        // console.log(222,this.inventories[index]);
                        if (this.inventories[index].quantity != null && this.inventories[index].price != null) {
                            var quantity = this.inventories[index].quantity;
                            var price = this.inventories[index].price;
                            temp = (quantity * price);

                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    getDensity(index) {
                        var temp = 0;
                        if (this.inventories[index].package_weight != null && this.inventories[index].package_volume != null) {
                            var package_weight = this.inventories[index].package_weight;
                            var package_volume = this.inventories[index].package_volume;
                            temp = (package_weight / package_volume);
                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    selectVolume(index) {
                        var temp = 0;
 
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].item.width != null && this.inventories[index].item.length != null && this.inventories[index].item.height != null) {
                                var width = Number.parseFloat(this.inventories[index].item.width);
                                var length = Number.parseFloat(this.inventories[index].item.length);
                                var height = Number.parseFloat(this.inventories[index].item.height);
                                var volume = (width * length * height);
                                this.inventories[index].volume = Number.parseFloat(volume).toFixed(precision());

                                if (this.inventories[index].item.quantity) {
                                    var quantity = Number.parseFloat(this.inventories[index].item.quantity);
                                    this.inventories[index].quantity = quantity;
                                    this.inventories[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                                }
                            }
                        }
                        // temp = Number.parseFloat(temp).toFixed(precision());
                        // return temp;
                    },

                    // calculate item price based on measure change
                    selectPackageWeight(index) {
                        // console.log(222,this.inventories[index]);
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].item.quantity != null && this.inventories[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories[index].item.quantity);
                                var package_weight = (weight * quantity);
                                this.inventories[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectVolumeQu(index) {
                        var temp = 0;
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].quantity != null && this.inventories[index].volume != null) {
                                var volume = Number.parseFloat(this.inventories[index].volume);
                                var quantity = Number.parseFloat(this.inventories[index].quantity);
                                this.inventories[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectPackageWeightQu(index) {
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].quantity != null && this.inventories[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories[index].quantity);
                                var package_weight = (weight * quantity);
                                this.inventories[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        }
                    },
                    // begin item search

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.member = [];
                                v.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    EmployeeSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Employee'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.employee = [];
                                v.employee = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    selectItems() {
                        if (v.selected_container) {

                            let container_id = v.selected_container.id;
                            let cargo_loading_id = v.selected_container.cargo_loadings_id;
                            axios.get("{{route('callcargoLoading.search')}}", {
                                params: {
                                    method_name: 'selectContainerItems',
                                    container_id: container_id,
                                    cargo_loading_id: cargo_loading_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    v.cargoLoading = response.data.cargoLoading;
                                    // console.log(312, v.cargoLoading);
                                    if (v.cargoLoading) {
                                        v.selected_vehicle = _.find(vehicles, (c) => c.id == v.cargoLoading.vehicle_id);
                                        v.selected_driver = _.find(driver, (c) => c.id == v.cargoLoading.driver_id);
                                    }
                                    
                                    var cargoLoadingDetail = response.data.data;

                                    if (cargoLoadingDetail) {
                                        v.inventories = [];
                                        for (var i = 0; i < cargoLoadingDetail.length; i++) {
                                            // console.log(123, cargoLoadingDetail[i]);
                                            
                                            var volume = 0;
                                            var package_volume = 0;
                                            var package_weight = 0;
                                            if (cargoLoadingDetail[i].item != null) {
                                                if (cargoLoadingDetail[i].item.width != null && cargoLoadingDetail[i].item.length != null && cargoLoadingDetail[i].item.height != null) {
                                                    var width = Number.parseFloat(cargoLoadingDetail[i].item.width);
                                                    var length = Number.parseFloat(cargoLoadingDetail[i].item.length);
                                                    var height = Number.parseFloat(cargoLoadingDetail[i].item.height);
                                                    var volume1 = (width * length * height);
                                                    volume = Number.parseFloat(volume1).toFixed(precision());
                                                    if (cargoLoadingDetail[i].item.quantity != null) {
                                                        var quantity = Number.parseFloat(cargoLoadingDetail[i].item.quantity);
                                                        package_volume = Number.parseFloat(volume1 * quantity).toFixed(precision());
                                                        if (cargoLoadingDetail[i].item.weight != null) {
                                                            var weight = Number.parseFloat(cargoLoadingDetail[i].item.weight);
                                                            package_weight = Number.parseFloat(weight * quantity).toFixed(precision());
                                                        }
                                                    }
                                                }
                                            }

                                            v.inventories.push({item: cargoLoadingDetail[i].item, selectedMember: cargoLoadingDetail[i].member, destination: cargoLoadingDetail[i].destination, density: 0, height: cargoLoadingDetail[i].height, length: cargoLoadingDetail[i].length, 
                                            quantity: cargoLoadingDetail[i].quantity, volume: volume, weight: cargoLoadingDetail[i].weight, width: cargoLoadingDetail[i].width, package_volume: package_volume, package_weight: package_weight});
                                            // console.log(123, v.inventories);
                                        }
                                    }

                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, selectedMember: null, destination: null, density: null, height: null, length: null, price: null, quantity: null, volume: null, weight: null, width: null, package_volume: null, package_weight: null});
                                }
                            }
                            
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            // console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, selectedMember: null, destination: null},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                var url="{{route('cargoLoading.change_site_store')}}";
                                form_id='contract-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush