@extends('layouts.factor-master')

@section('content')



    <h3 class="table-caption" style="text-align: center;">@lang('layout.Expense')</h3>
    <table style="width: 100%; margin-bottom: 10px;">
        @if($info && $info !=[])

            <tr>
                <td>
                    <span>@lang('layout.ContractNumber')</span>:
                    <span>{{$info->contract_no}}</span>
                </td>
                <td>
                    <span>@lang('layout.MemberName')</span>:
                    <span>{{$info->name}}</span>
                </td>
                <td>
                    <span>@lang('layout.ContractName')</span>:
                    <span>{{$info->company_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Amount')</span>:
                    <span>{{$info->amount}}</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$info->description}}</span>
                </td>
            </tr>

        @endif

    </table>


    <table class="main-table">
        <thead>
        <tr class="bg">


            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ExpenseCategory')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $totals = 0;
        ?>
        @foreach($data AS $record)
        <?php
        $totals += $record->baseAmount;
        ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{__('layout.' . ucfirst($record->type))}}</td>
                <td class="center">{{$record->amount}}</td>
                <td class="center">{{$record->Currency}}</td>
                <td class="center">{{$record->rate}}</td>
                <td class="center">{{convertDate($record->Date)}}</td>
                <td class="center">{{$record->description}}</td>


            </tr>
        @endforeach
        <tr class="bg">
            <td colspan="4" class="center"> @lang('layout.Total') </td>
            <td colspan="3" class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
        </tr>
    </table>


@endsection