@extends('layouts.factor-master') 
@section('content') 
<?php
$report = customeReportNew('cargo_loading_index');
$_customer_name= !in_array('customer_name', $report);
$_item_name= !in_array('item_name', $report);
$_fabric= !in_array('fabric', $report);
$_carton_quantity= !in_array('carton_quantity', $report);
$_total_metraj= !in_array('total_metraj', $report);
$_total_wazn= !in_array('total_wazn', $report);
$_price= !in_array('price', $report);
$_total_price= !in_array('total_price', $report);
$_site= !in_array('site', $report);
$_container_number= !in_array('container_number', $report);
$_date= !in_array('date', $report);
  
$report_percent = customeReportNewPercent('cargo_loading_index');
$_customer_name_percent= (array_key_exists('customer_name___percent', $report_percent))?$report_percent['customer_name___percent']:null; 
$_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null; 
$_fabric_percent= (array_key_exists('fabric___percent', $report_percent))?$report_percent['fabric___percent']:null; 
$_carton_quantity_percent= (array_key_exists('carton_quantity___percent', $report_percent))?$report_percent['carton_quantity___percent']:null; 
$_total_metraj_percent= (array_key_exists('total_metraj___percent', $report_percent))?$report_percent['total_metraj___percent']:null; 
$_total_wazn_percent= (array_key_exists('total_wazn___percent', $report_percent))?$report_percent['total_wazn___percent']:null; 
$_price_percent= (array_key_exists('price___percent', $report_percent))?$report_percent['price___percent']:null; 
$_total_price_percent= (array_key_exists('total_price___percent', $report_percent))?$report_percent['total_price___percent']:null; 
$_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null; 
$_container_number_percent= (array_key_exists('container_number___percent', $report_percent))?$report_percent['container_number___percent']:null; 
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null; 
?>
   
<h3 class="table-caption" style="text-align: center;">@lang('layout.LoadingDetailsReport')</h3>
<h3>@lang('layout.Loading')</h3> 
<table style="width: 100%; margin-bottom: 10px;"> 
    @if($member_name)
    <tr>
        <td class="center" style="width: 35%; border: 1px solid white; background-color: blue; padding: 3px; color: white" > @lang('layout.CustomerName'): {{$member_name}} </td> 
        <td class="center" style="width: 20%; border: 1px solid white; background-color: blue; padding: 3px; color: white" > @lang('layout.CodeNumber'): {{$member_code}} </td> 
        <td style="width: 50%;border: 1px solid white; color: blue; font-size: 23px;" > @lang('layout.LoadingItemList')  </td> 
    </tr> 
    @endif
</table> 
 <table class="main-table"> 
        <tr class="bg"> 
            <th style="width: 10%;">
                <div class="center"> @lang('layout.Number') </div>
            </th> 
            @if(!$member_name)  
            @if($_customer_name)
            <th style="border: 1px solid black; " @if($_customer_name_percent) width="{{$_customer_name_percent}}%" @endif>@lang('layout.CustomerName') </th>   
            @endif 
            @endif
            @if($_item_name)
            <th style="border: 1px solid black; " @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif>@lang('layout.ItemName') </th>
            @endif
            @if($_fabric)
            <th style="border: 1px solid black; " @if($_fabric_percent) width="{{$_fabric_percent}}%" @endif>@lang('layout.Fabric') </th> 
            @endif  
            @if($_carton_quantity) 
            <th style="border: 1px solid black; " @if($_carton_quantity_percent) width="{{$_carton_quantity_percent}}%" @endif>@lang('layout.CartanQty') </th>
            @endif
            @if($_total_metraj)
            <th style="border: 1px solid black; " @if($_total_metraj_percent) width="{{$_total_metraj_percent}}%" @endif>@lang('layout.TotalMetraj') </th>
            @endif
            @if($_total_wazn)
            <th style="border: 1px solid black; " @if($_total_wazn_percent) width="{{$_total_wazn_percent}}%" @endif>@lang('layout.TotalWazn') </th>
            @endif
            @if($_price)
            <th style="border: 1px solid black; " @if($_price_percent) width="{{$_price_percent}}%" @endif>@lang('layout.Price') </th>
            @endif
            @if($_total_price)
            <th style="border: 1px solid black; " @if($_total_price_percent) width="{{$_total_price_percent}}%" @endif>@lang('layout.TotalPrice') </th>
            @endif
            @if($_site)
            <th style="border: 1px solid black; " @if($_site_percent) width="{{$_site_percent}}%" @endif>@lang('layout.Site') </th>  
            @endif
            @if($_container_number)
            <th style="border: 1px solid black; " @if($_container_number_percent) width="{{$_container_number_percent}}%" @endif>@lang('layout.ContainerNumber') </th>  
            @endif
            @if($_date)
            <th style="border: 1px solid black; " @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date') </th> 
            @endif   
        </tr>    
    <?php
    $count = 0;
    $qty = 0;
    $package_volume = 0;
    $package_weight = 0;
    $total_amount = 0;
    $colspan = 4;

    
    ?>
    @foreach($data AS $srecord)
    <?php
    $qty += ($srecord->quantity);
    $package_volume += ($srecord->package_volume);
    $package_weight += ($srecord->package_weight);
    $total_amount += ($srecord->price * $srecord->package_volume);
    
    ?>
    <tr>
        <td style="border: 1px solid black" class="center">{{++$count}}</td>
        @if(!$member_name)  
        @if($_customer_name) 
        <td style="border: 1px solid black" class="center">{{$srecord->customer_name}}</td> 
        @endif
        @endif
        @if($_item_name) 
        <td style="border: 1px solid black" class="center">{{$srecord->item_description1}}</td>
        @endif
        @if($_fabric) 
        <td style="border: 1px solid black" class="center">{{$srecord->number}}</td>  
        @endif
        @if($_carton_quantity) 
        <td style="border: 1px solid black" class="center">{{$srecord->quantity}}</td>
        @endif
        @if($_total_metraj) 
        <td style="border: 1px solid black" class="center">{{$srecord->package_volume}}</td>
        @endif
        @if($_total_wazn) 
        <td style="border: 1px solid black" class="center">{{$srecord->package_weight}}</td>
        @endif
        @if($_price) 
        <td style="border: 1px solid black" class="center">{{$srecord->price}} {{$srecord->currency}} </td> 
        @endif
        @if($_total_price) 
        <td style="border: 1px solid black" class="center">{{$srecord->price * $srecord->package_volume}} {{$srecord->currency}} </td> 
        @endif
        @if($_site) 
        <td style="border: 1px solid black" class="center">{{$srecord->site}}</td> 
        @endif
        @if($_container_number) 
        <td style="border: 1px solid black" class="center">{{$srecord->container_number}}</td> 
        @endif
        @if($_date) 
        <td style="border: 1px solid black" class="center">{{convertDate($srecord->date)}}</td> 
        @endif
    </tr>
    @endforeach 

    @if($member_name || !$_customer_name)   <?php  $colspan = $colspan-1;  ?>    @endif

    
    @if(!$_item_name)   <?php  $colspan = $colspan-1;  ?>       @endif

    @if(!$_fabric)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_carton_quantity)   <?php  $colspan = $colspan-1;  ?>       @endif  
    
    <tr class="bg">      
        <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
        <td colspan="1" class="center">{{simpleRound($qty)}}</td>
        <td colspan="1" class="center">{{simpleRound($package_volume)}}</td>
        <td colspan="1" class="center">{{simpleRound($package_weight)}}</td>
        <td colspan="1"></td>
        <td colspan="1" class="center">{{$total_amount}}</td>
    </tr>
</table> 
@endsection