@extends('layouts.factor-master')
@section('content')
    <?php
        $report = customeReportNew('cargo_loading_index');
            $_record = !in_array('record', $report);
            $_number= !in_array('number', $report);
            $_description= !in_array('description', $report);
            $_item_name= !in_array('item_name', $report);
            $_type= !in_array('type', $report);
            $_carton_quantity= !in_array('carton_quantity', $report);
            $_vehicle= !in_array('vehicle', $report);
            $_source= !in_array('source', $report);
            $_responsible= !in_array('responsible', $report);
            $_status= !in_array('status', $report);
            $_site= !in_array('site', $report);
            $_container_number= !in_array('container_number', $report);
            $_date= !in_array('date', $report);
            $_transite_number= !in_array('transite_number', $report);
            $_user= !in_array('user', $report);  

        $report_percent = customeReportNewPercent('cargo_loading_index');
            $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null; 
            $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null; 
            $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null; 
            $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null; 
            $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null; 
            $_carton_quantity_percent= (array_key_exists('carton_quantity___percent', $report_percent))?$report_percent['carton_quantity___percent']:null; 
            $_vehicle_percent= (array_key_exists('vehicle___percent', $report_percent))?$report_percent['vehicle___percent']:null; 
            $_source_percent= (array_key_exists('source___percent', $report_percent))?$report_percent['source___percent']:null; 
            $_responsible_percent= (array_key_exists('responsible___percent', $report_percent))?$report_percent['responsible___percent']:null; 
            $_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null; 
            $_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null; 
            $_container_percent= (array_key_exists('container_number___percent', $report_percent))?$report_percent['container_number___percent']:null; 
            $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null; 
            $_transite_number_percent= (array_key_exists('transite_number___percent', $report_percent))?$report_percent['transite_number___percent']:null; 
            $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null; 
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.TransferAndLoadingReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                @if($_record)
                    <td class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif><div> @lang('layout.Record')  </div></td>
                @endif
                @if($_number)
                    <th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>
                @endif
                @if($_date)
                    <th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>
                @endif
                @if($_description)
                    <th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>
                @endif
                @if($_type)
                    <th @if($_type_percent) width="{{$_type_percent}}%" @endif>@lang('layout.Type')</th>
                @endif
                @if($_container_number)
                    <th @if($_container_percent) width="{{$_container_percent}}%" @endif>@lang('menu.Container')</th>
                @endif
                @if($_vehicle)
                    <th @if($_vehicle_percent) width="{{$_vehicle_percent}}%" @endif>@lang('menu.Vehicle')</th>
                @endif
                @if($_source)
                    <th @if($_source_percent) width="{{$_source_percent}}%" @endif>@lang('layout.Source')</th>
                @endif
                @if($_transite_number)
                    <th @if($_transite_number_percent) width="{{$_transite_number_percent}}%" @endif>@lang('layout.TransitNumber')</th>
                @endif
                @if($_carton_quantity)
                    <th @if($_carton_quantity_percent) width="{{$_carton_quantity_percent}}%" @endif>@lang('layout.Quantity')</th> 
                @endif
                @if($_status)
                    <th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</th>
                @endif
                @if($_responsible)
                    <th @if($_responsible_percent) width="{{$_responsible_percent}}%" @endif>@lang('layout.Responsible')</th> 
                @endif
                @if($_user)
                    <th @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</th>
                @endif
            </tr>
        </thead>
        <?php
            $count = 0;
            $total_home_currency = 0;
            $currencies = [];
            $totalQuantity = 0;
            $colspan = 9;
        ?>
        @foreach($data AS $record)
            <?php 
                $totalQuantity += $record->quantity;
            ?>
            <tr>
                @if($_record)
                    <td class="center">{{++$count}}</td>
                @endif
                @if($_number)
                    <td class="center">{{$record->number}}</td>
                @endif
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>
                @endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>
                @endif
                @if($_type)
                    <td class="center">{!! __('layout.' . ucfirst($record->type)) !!}</td>
                @endif
                @if($_container_number)
                    <td class="center">{{$record->container}}</td>
                @endif
                @if($_vehicle)
                    <td class="center"> @if($record->driver_type == 'ForeignDriver')  {{ $record->other_vehicle_name}} @else {{ $record->vehicle}} @endif </td>
                @endif
                @if($_source)
                    <td class="center">{{$record->source_site}}</td>
                @endif
                @if($_transite_number)
                    <td class="center">{{$record->transit_number}}</td>
                @endif
                @if($_carton_quantity)
                    <td class="center">{{$record->quantity}}</td> 
                @endif
                @if($_status)
                    <td class="center">
                        @if($record->state == "Loaded")
                        @lang('layout.Fill')
                        @else
                        @lang('layout.Empty')
                        @endif
                    </td>
                @endif
                @if($_responsible)
                    <td class="center">{{$record->employee}}</td> 
                @endif
                @if($_user)
                    <td class="center">{{$record->user}}</td>
                @endif
            </tr>
        @endforeach 
        @if(!$_record)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_number)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_date)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_description)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_type)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_container_number)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_vehicle)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_source)   <?php  $colspan = $colspan-1;  ?>       @endif
        @if(!$_transite_number)   <?php  $colspan = $colspan-1;  ?>       @endif
        <tr class="bg"> 
            <td class="center" colspan="{{$colspan}}" style="font-weight: bold;">@lang('layout.Total')</td>
            @if($_carton_quantity)
                <td class="center" style="font-weight: bold;">{{myRound($totalQuantity)}}</td>
            @endif
            @if($_status)
                <td></td>
            @endif
            @if($_responsible)
                <td></td>
            @endif
            @if($_user)
                <td></td>
            @endif
        </tr>
    </table>
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table>
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>                
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection