@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract');
    $_code = in_array('code', $report);
    $_date = in_array('date', $report);
    $_contract_name = in_array('contract_name', $report);
    $_vendor = in_array('vendor', $report);
    $_bank = in_array('bank', $report);
    $_price = in_array('price', $report);
    $_amount = in_array('amount', $report);
    $_currency = in_array('currency', $report);
    $_rate = in_array('rate', $report);
    $_total_in_home_currency = in_array('total_in_home_currency', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.DeliveryReport')</h3>

    <br>
    <table class="main-table">

        <thead>
            <tr class="bg">
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Description')</th>
                <th>@lang('layout.User')</th>
            </tr>
        </thead>
            <tr>
                <td class="center">{{$deliveryInfo->number}}</td>
                <td class="center">{{$deliveryInfo->member}}</td>
                <td class="center">{{convertDate($deliveryInfo->date)}}</td>
                <td class="center">{{$deliveryInfo->description}}</td>
                <td class="center">{{$deliveryInfo->user}}</td>
            </tr>
    </table>
    
    <br>
    <table class="main-table">

        <thead>
            <tr class="bg">
                <td class="center"><div> @lang('layout.Record') </div></td>
                <th>@lang('layout.Item')</th>
                <th>@lang('layout.Description') En</th>
                <th>@lang('layout.Description') Oth</th>
                <th>@lang('layout.Destination')</th>
                <th>@lang('layout.Width')</th>
                <th>@lang('layout.Height')</th>
                <th>@lang('layout.Length')</th>
                <th>@lang('layout.Weight')</th>
                <th>@lang('layout.Quantity')</th>
                <th>@lang('layout.Price') </th>
                <th>@lang('layout.Volume')</th>
            </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->name}}</td>
                <td class="center">{{$record->item_description2}}</td>
                <td class="center">{{$record->item_description3}}</td>
                <td class="center">{{$record->site}}</td>
                <td class="center">{{$record->width}}</td>
                <td class="center">{{$record->height}}</td>
                <td class="center">{{$record->length}}</td>
                <td class="center">{{$record->weight}}</td>
                <td class="center">{{myRound($record->quantity)}}</td>
                <td class="center">{{myRound($record->price)}}</td>
                <td class="center">{{$record->volume}}</td>
            </tr>
        @endforeach

    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection