@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <!-- new modal -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'contract'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.ContractNumber') </label>
                            <input type="number" name="number" class="form-control" autocomplete="off">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>

                                <div slot="date">
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InStock')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <a href="{{route('cargoContract.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.CargoContract')
                        </button>
                    </a>
                    @permission('contract-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('contract-create')
                    <a href="{{route('transferAndLoading.discharge_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Discharge')
                        </button>
                    </a>
                    <a href="{{route('transferAndLoading.loading_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Loading')
                        </button>
                    </a>
                    <a href="{{route('transferAndLoading.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.DischargeAndLoading')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContracts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Destination')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.Width')</th>
                        <th>@lang('layout.Length')</th>
                        <th>@lang('layout.Height')</th>
                        <th>@lang('layout.Volume')</th>
                        <th>@lang('layout.Weight')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Density')</th>
                        <th>@lang('layout.Weight') @lang('layout.Package')</th>
                        <th>@lang('layout.Volume') @lang('layout.Package')</th>
                        <th>@lang('layout.Price')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Expense')</th>
                        <th>@lang('layout.ExpenseDetails')</th>
                        <th>@lang('layout.Total')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cargoContracts').DataTable({
                ajax: '{{route("cargoContract.indexStock")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [{
                    data: 'number',
                    name: 'number'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'Customer',
                    name: 'Customer'
                },{
                    data: 'source_name',
                    name: 'source_name'
                },
                {
                    data: 'destination_name',
                    name: 'destination_name'
                },
                {
                    data: 'item',
                    name: 'item'
                },
                {
                    data: 'width',
                    name: 'width'
                },
                {
                    data: 'length',
                    name: 'length'
                },
                {
                    data: 'height',
                    name: 'height'
                },
                {
                    data: 'volume',
                    name: 'volume'
                },
                {
                    data: 'weight',
                    name: 'weight'
                },
                {
                    data: 'quantity_in',
                    name: 'quantity_in'
                },
                {
                    data: 'Density',
                    name: 'Density'
                },
                {
                    data: 'package_weight',
                    name: 'package_weight'
                },
                {
                    data: 'package_volume',
                    name: 'package_volume'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'discount',
                    name: 'discount'
                },
                {
                    data: 'ex_amount',
                    name: 'ex_amount'
                },
                {
                    data: 'ex_description',
                    name: 'ex_description'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
            ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoContract.report") !!}',
                excelRoute: '{!! route("cargoContract.report") !!}',
                selectedMember: null,
                member: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
