@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <!-- new modal -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'delivery'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <label class="control-label ">@lang('layout.Customer') </label>
                                        <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" placeholder="@lang('layout.Customer')" >
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" >
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.ContractNumber') </label>
                                        <input type="number" name="number" class="form-control" autocomplete="off">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label ">@lang('layout.Type') </label>
                                        <select class="form-control" name="report_type">
                                            <option value="">@lang('layout.Select')</option>
                                            <option value="detail">@lang('layout.Details')</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Date')</label>
                                            <div slot="date">
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
            
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="part_name" value="delivery_index">
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                            <div class="form-group" style="margin: 1px;">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                    <tr>
                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td style="text-align: center;">
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label>
                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="margiv-top-10">
                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                        <button style="margin-top: 10px !important;" type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        {{-- <button style="margin-top: 10px !important;" type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button> --}}
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('menu.Delivery')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoDelivery-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('CargoDelivery-create')
                    <a href="{{route('cargoDelivery.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
            
                <div id="sites">
                    <div class="col-md-3">
                        <div class="form-group">
                            <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" @input="getData()" placeholder="@lang('layout.Customer')" >
                            </v-select>
                            <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" >
                        </div>
                    </div>
                </div>

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContracts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        var cust_rep = {!!customeReportNewData('delivery_index')!!};

        function factorPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('cargoDeliveryFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;

        function getRecord() {
            if (vtr.selectedMember) {
                vtr.member_id = vtr.selectedMember.id;
            } else {
                vtr.member_id = '';
            }
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cargoContracts').DataTable({
                ajax: {
                    ajax: '{{route("cargoDelivery.index")}}',
                    data: {
                        member_id: vtr.member_id
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'cargo_deliveries.number'},
                    {data: 'member', name: 'members.name'},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'date', name: 'cargo_deliveries.date', searchable: false},
                    {data: 'description', name: 'cargo_deliveries.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        }

        $(document).ready(function() {
            getRecord();
        });
        var vtr = new Vue({
            el: '#sites',
            data: {
                types: '',
                state: '',
                member: [],
                selectedMember: null,
                member_id: '',
            },
            methods: {
                getData() {
                    getRecord();
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vtr.member = [];
                            vtr.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoDelivery.report") !!}',
                excelRoute: '{!! route("cargoDelivery.report") !!}',
                selectedMember: null,
                member: null,
                customReportData:
                [ 
                    {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    {Name: '@lang("layout.ContractNumber")', column_name: 'contractNumber',checkedColumn:(cust_rep.contractNumber)?'checked':'',column_percentage:(cust_rep.contractNumber___percent)?cust_rep.contractNumber___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName',checkedColumn:(cust_rep.itemName)?'checked':'',column_percentage:(cust_rep.itemName___percent)?cust_rep.itemName___percent:''},
                    {Name: '@lang("layout.Site")', column_name: 'site',checkedColumn:(cust_rep.site)?'checked':'',column_percentage:(cust_rep.site___percent)?cust_rep.site___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight',checkedColumn:(cust_rep.weight)?'checked':'',column_percentage:(cust_rep.weight___percent)?cust_rep.weight___percent:''},
                ],
                cust_rep:cust_rep,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
