@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.CompletedProjectsReport');
?>
@section('content')
<?php
  $report = customeReport('invoice', 'index');


  $total_amount = 0;
  $currency = null;
  foreach($data AS $records){
    $total_amount += (float)($records->quantity * $records->price);
    $currency = $records->currency;
  }
?>
<h4 style="text-align: center; ">@lang('layout.DeliveryItemBill')</h4>

<table style="width: 100%; border: 1px solid black;">
  <tr>
    <td style="font-size: 14px" width='20%' >@lang('layout.Date') : </td>
    <td style="font-size: 14px" width='40%' >{{$contract->date}}</td>
    <td style="font-size: 14px" width='20%' >@lang('layout.Number') : </td>
    <td style="font-size: 14px" width='20%' >{{$contract->number}}</td>
  </tr>
  <tr>
    <td style="font-size: 14px" width='20%' >@lang('layout.Customer') : </td>
    <td style="font-size: 14px" width='40%' >{{$member->name}}</td>
  </tr> 
  <tr>
    <td style="font-size: 14px" width='20%' >@lang('layout.surrender') : </td>
    <td style="font-size: 14px" width='40%' >{{$stock_man_name}}</td>
  </tr> 
  <tr>
    <td style="font-size: 14px" width='20%' >@lang('layout.Amount') : </td>
    <td style="font-size: 14px" width='40%' >{{$total_amount}}</td>
    <td style="font-size: 14px" width='20%' >@lang('layout.Currency') : </td>
    <td style="font-size: 14px" width='20%' >{{$currency}}</td>
  </tr>
  <tr>
    <td style="font-size: 14px" width='20%' >@lang('layout.recipient') : </td>
    <td style="font-size: 14px" width='40%' >{{$contract->recipient}}</td>
  </tr>
  
</table>
<table class="main-table">
  <tr>
    <td>
      <div class="center"> #</div>
    </td>
    <th>@lang('layout.ItemName')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Price')</th>
    <th>@lang('layout.Total')</th>
  </tr>
  <?php
  $count = 0;
  $empty = 0;
  $qtyTotal = 0;
  $discount = 0;
  $ex_amount = 0;
  $total_amount = 0;

  ?>
  @foreach($data AS $record)
  <?php
  $qtyTotal += (float)$record->quantity;
  $discount += (float)$record->discount;
  $total_amount += (float)($record->quantity * $record->price);
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->name}}</td>
    <td class="center">{{$record->quantity}} {{$record->measure}}</td>
    <td class="center">{{$record->price}}</td>
    <td class="center">{{myRound($record->quantity * $record->price)}} {{$currency}}</td>
  </tr>
  @endforeach

</table>

<table style="width: 100%; border: 1px solid black;" class="main-table">
  <tr>
    <td>@lang('layout.TotalQuantity'): {{$qtyTotal}}</td>
    <td>
      @if(getFactorLang()=='fa')
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($total_amount)),'fa')}}</b></div>
      @elseif(getFactorLang()=='pa')
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($total_amount)),'pa')}}</b></div>
      @else
      <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
              :&nbsp; {{notowo(abs(round($total_amount)),'en')}}</b></div>
      @endif
  </td>
    <td>@lang('layout.Amount'): {{myRound($total_amount)}} {{$currency}}</td>
  </tr>

</table>

<table width="100%" >
  <tr>
      <td width="33%" >@lang('layout.BossSign')</td>
      <td width="33%" >@lang('layout.ResponsibleSign')</td>
      <td width="34%" >@lang('layout.CustomerSign')</td>
  </tr>
</table>

<table width="100%" style="margin-top: 40px;" >
  <tr>
      <td></td>
  </tr>
</table>

@if(company()['invoice_message'])
    <table width="100%" style="border: 1px solid black;">
        <tr>
            <td style="font-size: 14px;"> {!!company()['invoice_message']!!}</td>
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
@endif

<!--  signature -->
{{-- <table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','invoice') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table> --}}
<!-- End signature -->


@endsection