@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewDelivery') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'cargoDelivery.store','method' => 'POST','class' => 'form-horizontal','id'=>'contract-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-9  col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    {{Form::number('number',$number,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
										<div class="col-md-12">
                                            <label class="control-label">@lang('layout.Customer'):</label>
                                            <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" @input="setRow()" placeholder="@lang('layout.Customer')" >
											</v-select>
                                            <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" >
                                            <span class="required">@{{ errors.first('member_id') }}</span>
										</div>
									</div>
								</div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date"  name="date" autocomplete="off">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.recipient')</label>
                                    {!! Form::text('recipient', null, array('placeholder' => __('layout.recipient'),'class' => 'form-control')) !!}
                                </div>
                            
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                                
                            </div>
                            
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Quantity') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span data-counter="counterup" data-value="7800">
                                                @{{ format_number(Number.parseFloat(subtotal))}}
                                            </span>
                                            <small class="font-green-sharp">
                                                BX
                                            </small>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Weight') @lang('layout.Package') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(package_weight))}}</span>
                                            <small class="font-green-sharp">
                                                KG
                                            </small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') @lang('layout.Volume') @lang('layout.Package') :</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                @{{ format_number(Number(package_volume))}}
                                            </span>
                                            <small class="font-green-sharp">
                                                m3
                                            </small>
                                        </td>
                                    </tr>
                                </table>

                            </div>
                            <!-- end total -->

                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 100px">@lang('menu.Container')</th>
                                <th style="min-width: 100px">@lang('layout.Item') / @lang('layout.Destination')</th>
                                <th style="min-width: 100px">@lang('layout.Description') En / Oth</th>
                                <th style="min-width: 100px">@lang('layout.Width') / @lang('layout.Length') </th>
                                <th style="min-width: 100px">@lang('layout.Height') / @lang('layout.Volume')</th>
                                <th style="min-width: 100px">@lang('layout.Weight') / @lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.Density') </th>
                                <th style="min-width: 100px"> @lang('layout.Weight') @lang('layout.Package') / @lang('layout.Volume') @lang('layout.Package')</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                
                                <td class="highlight">
                                        <v-select placeholder="@lang('menu.Container') " label="name" @input="selectItems(index)" :options="container" @click.native="addNew('inventory',index)" @keyup.native="addNew('inventory',index)" v-model="item.selected_container"></v-select>
                                        <input type="hidden" :name="'container_id['+index+']'" :value="(item.selected_container)?item.selected_container.id:null">
                                        <input type="hidden" :name="'cargo_loadings_id['+index+']'" :value="(item.selected_container)?item.selected_container.cargo_loadings_id:null">
                                        @lang('layout.TransitNumber') : @{{(item.selected_container)?item.selected_container.transit_number:null}}
                                </td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.Item') " label="name"  @input="selectVolume(index), selectPackageWeight(index)" :options="temp_items" v-model="item.item"></v-select>
                                    <input type="hidden" :name="'item_id['+index+']'" :value="(item.item)?item.item.cargo_item_id:null">
                                    
                                    <input class="form-control" type="text" placeholder="@lang('layout.Destination')"   :value="(item.item)?item.item.destination:null" readonly >
                                    <input type="hidden" :name="'site_id['+index+']'" :value="(item.item)?item.item.site_id:null">
                                </td>
                                <td class="highlight">
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') Fa" :value="(item.item)?item.item.item_description2:null" >
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') En" :value="(item.item)?item.item.item_description3:null" >
                                </td>
                                <td>
                                    <input type="number" :name="'width['+index+']'" :value="(item.item)?item.item.width:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Width')">
                                    <input type="number" :name="'length['+index+']'" :value="(item.item)?item.item.length:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Length')"> 
                                </td>
                                <td>
                                    <input type="number" :name="'height['+index+']'" :value="(item.item)?item.item.height:null" readonly class="form-control " placeholder="@lang('layout.Height')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'volume['+index+']'" :value="(item.item)?item.item.volume:null" readonly class="form-control " placeholder="@lang('layout.Volume')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>

                                <td>
                                    <input type="number" :name="'weight['+index+']'" :value="(item.item)?item.item.weight:null" readonly class="form-control " placeholder="@lang('layout.Weight')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <div class="input-group">
                                        <input type="number" :name="'quantity_in['+index+']'" v-validate="''"
                                           data-vv-as="@lang('layout.Quantity')" v-model.number="item.quantity" @input="selectVolumeQu(index), selectPackageWeightQu(index)"
                                           class="form-control " placeholder="@lang('layout.Quantity')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                        <span class="input-group-addon">
                                            @{{(item.item)?item.item.quantity:0}}
                                        </span>
                                    </div>
                                    <span class="required">@{{ errors.first('quantity_in['+index+']') }}</span>
                                </td>
                                <td>
                                    @{{ (item==null)?null:getDensity(index) }}
                                </td>
                                <td>
                                    <input type="number" :name="'package_weight['+index+']'" :value="(item.item)?item.package_weight:null" readonly class="form-control " placeholder="@lang('layout.Weight') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'package_volume['+index+']'" :value="(item.item)?item.package_volume:null" readonly class="form-control " placeholder="@lang('layout.Volume') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr/>
                        <br/>
                    </div>
                    <br/>
                    <hr/>
                    <!-- begin item -->
                    <div class="row" v-if="inventories2.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 100px">@lang('layout.Site')</th>
                                <th style="min-width: 100px">@lang('layout.Item') / @lang('layout.Destination')</th>
                                <th style="min-width: 100px">@lang('layout.Description') En / Oth</th>
                                <th style="min-width: 100px">@lang('layout.Width') / @lang('layout.Length') </th>
                                <th style="min-width: 100px">@lang('layout.Height') / @lang('layout.Volume')</th>
                                <th style="min-width: 100px">@lang('layout.Weight') / @lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.Density') </th>
                                <th style="min-width: 100px"> @lang('layout.Weight') @lang('layout.Package') / @lang('layout.Volume') @lang('layout.Package')</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories2">
                                <td>@{{index+1}}</td>
                                
                                <td class="highlight">
                                        <v-select placeholder="@lang('layout.Site') " label="name" @input="selectItems2(index)" :options="sites" @click.native="addNew('inventory2',index)" @keyup.native="addNew('inventory2',index)" v-model="item.selectedSite"></v-select>
                                        <input type="hidden" :name="'site_id2['+index+']'" :value="(item.selectedSite)?item.selectedSite.id:null">
                                </td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.Item') " label="name"  @input="selectVolume2(index), selectPackageWeight2(index)" :options="temp_items2" v-model="item.item"></v-select>
                                    <input type="hidden" :name="'item_id2['+index+']'" :value="(item.item)?item.item.id:null">
                                    
                                    <input class="form-control" type="text" placeholder="@lang('layout.Destination')"   :value="(item.item)?item.item.destination:null" readonly class="form-control">
                                </td>
                                <td class="highlight">
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') Fa" :value="(item.item)?item.item.item_description2:null" class="form-control">
                                    <input class="form-control" readonly placeholder="@lang('layout.Description') En" :value="(item.item)?item.item.item_description3:null" class="form-control">
                                </td>
                                <td>
                                    <input type="number" :name="'width2['+index+']'" :value="(item.item)?item.item.width:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Width')">
                                    <input type="number" :name="'length2['+index+']'" :value="(item.item)?item.item.length:null" readonly class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Length')"> 
                                </td>
                                <td>
                                    <input type="number" :name="'height2['+index+']'" :value="(item.item)?item.item.height:null" readonly class="form-control " placeholder="@lang('layout.Height')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'volume2['+index+']'" :value="(item.item)?item.item.volume:null" readonly class="form-control " placeholder="@lang('layout.Volume')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>

                                <td>
                                    <input type="number" :name="'weight2['+index+']'" :value="(item.item)?item.item.weight:null" readonly class="form-control " placeholder="@lang('layout.Weight')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <div class="input-group">
                                        <input type="number" :name="'quantity_in2['+index+']'" v-validate="''"
                                           data-vv-as="@lang('layout.Quantity')" v-model.number="item.quantity" @input="selectVolumeQu2(index), selectPackageWeightQu2(index)"
                                           class="form-control " placeholder="@lang('layout.Quantity')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                        <span class="input-group-addon">
                                            @{{(item.item)?item.item.quantity:0}}
                                        </span>
                                    </div>
                                    <span class="required">@{{ errors.first('quantity_in['+index+']') }}</span>
                                </td>
                                <td>
                                    @{{ (item==null)?null:getDensity2(index) }}
                                </td>
                                <td>
                                    <input type="number" :name="'package_weight2['+index+']'" :value="(item.item)?item.package_weight:null" readonly class="form-control " placeholder="@lang('layout.Weight') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'package_volume2['+index+']'" :value="(item.item)?item.package_volume:null" readonly class="form-control " placeholder="@lang('layout.Volume') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory2',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory2',1000)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr/>
                        <br/>
                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>
                    <span v-if="inventories2.length==0">
                         <button type="button" @click="addNew('inventory2',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>
                    <!-- end item -->

                    <hr> 
                    <h3>@lang('layout.Location')</h3>
                    <div class="row" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 100px">@lang('layout.Driver') </th>
                                <th style="min-width: 130px">@lang('menu.Vehicle') </th>
                                <th style="min-width: 50px">@lang('layout.State') </th>
                                <th style="min-width: 50px">@lang('layout.Location') </th>
                                <th style="min-width: 50px">@lang('layout.Source') </th>
                                <th style="min-width: 50px">@lang('layout.Destination') </th>
                                <th style="min-width: 50px">@lang('layout.Description') </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories" v-if="item.selected_container">
                                <span >
                                <td>@{{index+1}}</td>
                                <td>
                                    @{{(item.selected_container==null)?null:item.selected_container.driver}}
                                    <input type="hidden" name="loc_driver_id[]" class="form-control" :value="(item.selected_container==null)?null:item.selected_container.driver_id" >
                                </td>
                                <td>
                                    @{{(!item.selected_container)?null:item.selected_container.name}}
                                    <input type="hidden" name="loc_vehicle_id[]" class="form-control" :value="(item.selected_container==null)?null:item.selected_container.id" >
                                </td>
                                <td>
                                    <select name="loc_state[]" class="form-control">
                                        <option value="empty">@lang('layout.Empty')</option>
                                        <option value="fill">@lang('layout.Fill')</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="text" name="loc_location[]" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_source[]" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_destination[]" class="form-control input-style" >
                                </td>
                                <td>
                                    <input type="text" name="loc_description[]" class="form-control input-style" >
                                </td>
                                </span>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('cargoDelivery.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        var currency = {!! $currency!!}
        var inventorySite = {!! $inventorySite !!};
        // group of company
        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        var vehicles = {!!$vehicles!!};
        
        var v = new Vue({
            el: '#app',
            data: {
                currency: currency,
                selected_currency: homeCurrency,
                container: [],
                member: [],
                selectedMember: null,
                selectedSource: null,
                listAccounts: [],
                type: 'bank',
                rate: 0,
                temp_items: [],
                temp_items2: [],
                sites: inventorySite,
                inventory_category: inventorySite,
                selected_category: null,
                selected_iventory_category: null,
                selected_index: 0,
                vehicles:vehicles,
                selected_vehicle:null,
                selected_container:null,
                payments: [],
                inventories: [
                    {item: null, selected_container: null, site: null, quantity: null, package_volume: null, package_weight: null}
                ],
                inventories2: [
                    {item: null, selected_container: null, selectedSite: null, quantity: null, package_volume: null, package_weight: null}
                ],
                discountFiled: 0,
                discountIsAmount: true,
                package_weight: 0,
                package_volume: 0,
            },
            computed: {

                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    return rates;

                },
                
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // check payed amount
                payeds: function() {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var package_weight = 0;
                    var package_volume = 0;
                    
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].quantity != null) {
                            var quantity = Number.parseFloat(this.inventories[i].quantity);
                            var temp = quantity;

                            if (this.inventories[i].package_weight > 0) {
                                package_weight += Number.parseFloat(this.inventories[i].package_weight);
                            }
                            if (this.inventories[i].package_volume > 0) {
                                package_volume += Number.parseFloat(this.inventories[i].package_volume);
                            }
                            
                            sum += temp;
                        }
                    }

                    for (var i = 0; i < this.inventories2.length; i++) {
                        if (this.inventories2[i].quantity != null) {
                            var quantity = Number.parseFloat(this.inventories2[i].quantity);
                            var temp = quantity;

                            if (this.inventories2[i].package_weight > 0) {
                                package_weight += Number.parseFloat(this.inventories2[i].package_weight);
                            }
                            if (this.inventories2[i].package_volume > 0) {
                                package_volume += Number.parseFloat(this.inventories2[i].package_volume);
                            }
                            
                            sum += temp;
                        }
                    }
                    this.package_weight = package_weight;
                    this.package_volume = package_volume;
                    return sum;
                },


                
            },
            mounted: function() {
                
            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // calculate item price based on measure change
                    getTolal(index) {
                        var temp = 0;
                        // console.log(222,this.inventories[index]);
                        if (this.inventories[index].quantity != null && this.inventories[index].price != null) {
                            var quantity = this.inventories[index].quantity;
                            var price = this.inventories[index].price;
                            temp = (quantity * price);

                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    getDensity(index) {
                        var temp = 0;
                        if (this.inventories[index].package_weight != null && this.inventories[index].package_volume != null) {
                            var package_weight = this.inventories[index].package_weight;
                            var package_volume = this.inventories[index].package_volume;
                            temp = (package_weight / package_volume);
                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    getDensity2(index) {
                        var temp = 0;
                        if (this.inventories2[index].package_weight != null && this.inventories2[index].package_volume != null) {
                            var package_weight = this.inventories2[index].package_weight;
                            var package_volume = this.inventories2[index].package_volume;
                            temp = (package_weight / package_volume);
                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    selectVolume(index) {
                        var temp = 0;
                        this.inventories[index].volume = 0;
                        this.inventories[index].quantity = 0;
                        this.inventories[index].package_volume = 0;

                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].item.width != null && this.inventories[index].item.length != null && this.inventories[index].item.height != null) {
                                var width = Number.parseFloat(this.inventories[index].item.width);
                                var length = Number.parseFloat(this.inventories[index].item.length);
                                var height = Number.parseFloat(this.inventories[index].item.height);
                                var volume = (width * length * height);
                                if (volume == 0 && this.inventories[index].item.volume != 0) {
                                    volume = Number.parseFloat(this.inventories[index].item.volume);
                                }
                                this.inventories[index].volume = Number.parseFloat(volume).toFixed(precision());

                                if (this.inventories[index].item.quantity) {
                                    var quantity = Number.parseFloat(this.inventories[index].item.quantity);
                                    this.inventories[index].quantity = quantity;
                                    this.inventories[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                                }
                            }
                        }
                        // temp = Number.parseFloat(temp).toFixed(precision());
                        // return temp;
                    },

                    // calculate item price based on measure change
                    selectPackageWeight(index) {
                        // console.log(222,this.inventories[index]);
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].item.quantity != null && this.inventories[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories[index].item.quantity);
                                var package_weight = (weight * quantity);
                                this.inventories[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectVolumeQu(index) {
                        var temp = 0;
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].quantity != null && this.inventories[index].volume != null) {
                                var volume = Number.parseFloat(this.inventories[index].volume);
                                var quantity = Number.parseFloat(this.inventories[index].quantity);
                                this.inventories[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectPackageWeightQu(index) {
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].quantity != null && this.inventories[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories[index].quantity);
                                var package_weight = (weight * quantity);
                                this.inventories[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectVolume2(index) {
                        var temp = 0;
                        this.inventories2[index].volume = 0;
                        this.inventories2[index].quantity = 0;
                        this.inventories2[index].package_volume = 0;

                        if (this.inventories2[index].item != null) {
                            if (this.inventories2[index].item.width != null && this.inventories2[index].item.length != null && this.inventories2[index].item.height != null) {
                                var width = Number.parseFloat(this.inventories2[index].item.width);
                                var length = Number.parseFloat(this.inventories2[index].item.length);
                                var height = Number.parseFloat(this.inventories2[index].item.height);
                                var volume = (width * length * height);
                                if (volume == 0 && this.inventories2[index].item.volume != 0) {
                                    volume = Number.parseFloat(this.inventories2[index].item.volume);
                                }
                                this.inventories2[index].volume = Number.parseFloat(volume).toFixed(precision());

                                if (this.inventories2[index].item.quantity) {
                                    var quantity = Number.parseFloat(this.inventories2[index].item.quantity);
                                    this.inventories2[index].quantity = quantity;
                                    this.inventories2[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                                }
                            }
                        }
                        // temp = Number.parseFloat(temp).toFixed(precision());
                        // return temp;
                    },

                    // calculate item price based on measure change
                    selectPackageWeight2(index) {
                        // console.log(222,this.inventories2[index]);
                        if (this.inventories2[index].item != null) {
                            if (this.inventories2[index].item.quantity != null && this.inventories2[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories2[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories2[index].item.quantity);
                                var package_weight = (weight * quantity);
                                this.inventories2[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectVolumeQu2(index) {
                        var temp = 0;
                        if (this.inventories2[index].item != null) {
                            if (this.inventories2[index].quantity != null && this.inventories2[index].volume != null) {
                                var volume = Number.parseFloat(this.inventories2[index].volume);
                                var quantity = Number.parseFloat(this.inventories2[index].quantity);
                                this.inventories2[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                            }
                        }
                    },

                    // calculate item price based on measure change
                    selectPackageWeightQu2(index) {
                        if (this.inventories2[index].item != null) {
                            if (this.inventories2[index].quantity != null && this.inventories2[index].item.weight != null) {
                                var weight = Number.parseFloat(this.inventories2[index].item.weight);
                                var quantity = Number.parseFloat(this.inventories2[index].quantity);
                                var package_weight = (weight * quantity);
                                this.inventories2[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                            }
                        }
                    },

                    // set new price
                    setNewRate(index) {

                        if (this.inventories[index].item) {
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        }
                    },
                    // begin item search

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.member = [];
                                v.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    selectItems(index) {
                        v.temp_items = [];
                        v.inventories[index]['item'] = null
                        if (v.inventories[index]['selected_container'] != null && v.selectedMember) {
                            let container_id = v.inventories[index]['selected_container'].id;
                            let cargo_loading_id = v.inventories[index]['selected_container'].cargo_loadings_id;
                            let member_id = v.selectedMember.id;
                            axios.get("{{route('callcargoDelivery.search')}}", {
                                params: {
                                    method_name: 'selectContainerItems',
                                    container_id: container_id,
                                    member_id: member_id,
                                    cargo_loading_id: cargo_loading_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.data) {
                                            // console.log(312, response);
                                            v.temp_items = response.data.data;
                                    }
                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    selectItems2(index) {
                        v.temp_items2 = [];
                        if (v.selectedMember && v.inventories2[index]['selectedSite'] != null) {

                            let memeber_id = v.selectedMember.id;
                            let source_id = v.inventories2[index]['selectedSite'].id;
                            // console.log(source_id, memeber_id);
                            axios.get("{{route('callcargoLoading.search')}}", {
                                params: {
                                    method_name: 'selectItems',
                                    source_id: source_id,
                                    memeber_id: memeber_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                        // console.log(312, response);
                                        v.temp_items2 = response.data;
                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    setRow() {
                        v.inventories = [];
                        v.container = [];
                        if (v.selectedMember) {
                            axios.get("{{route('callcargoDelivery.search')}}", {
                                params: {
                                    method_name: 'SearchContainer', 
                                    member_id: v.selectedMember.id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    console.log(123,response.data);
                                    v.container = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }

                        v.inventories.push({item: null, selected_container: null, site: null, quantity: null, package_volume: null, package_weight: null});
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        this.temp_items2 = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, selected_container: null, site: null, quantity: null, package_volume: null, package_weight: null});
                                }
                            }
                            if (type == 'inventory2') {
                                if (this.inventories2[index + 1] == undefined) {
                                    this.temp_items2 = [];
                                    this.inventories2.push({item: null, selected_container: null, selectedSite: null, quantity: null, package_volume: null, package_weight: null});
                                }
                            }
                            
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            // console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'inventory2') {
                                this.inventories2.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, selected_container: null, destination: null},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                        this.temp_items2 = [];
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                var url="{{route('cargoDelivery.store')}}";
                                form_id='contract-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush