@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>

@if($wagon_number)
<span>@lang('layout.WagonNumber'): {{$wagon_number}}</span>
@endif

<table class="main-table">
    <thead>
        <tr class="bg">
            <th class="">
                <div class="center"> @lang('layout.ContractNumber') </div>
            </th>
            <th class="">
                <div class="center"> @lang('layout.ContractName') </div>
            </th>
            <th class="">
                <div class="center"> @lang('layout.Vendor') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Phone') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Address') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Email') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Description') </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $contract->contract_no}} </td>
            <td class=""> {{ $contract->company_name}} </td>
            <td class=""> {{ $contract->name}} </td>
            <td class=""> {{ $contract->phone}}</td>
            <td class=""> {{ $contract->address}}</td>
            <td class=""> {{ $contract->email}}</td>
            <td class=""> {{ $contract->description}}</td>
        </tr>
    </tbody>
</table>

<hr />
<h3>@lang('layout.ItemDetails') </h3>
<table class="main-table">
    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <th>
                <div class="center"> @lang('layout.ItemName')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Measure')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.SiteName')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Cost')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Quantity')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.PurchasedQuantity')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Remain')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Description')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Total')</div>
            </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_curr = 0;
    ?>
    @foreach($contractItem AS $rowItem)
    <tr>
        <?php
        $total_home_curr += ($rowItem->cost * $rowItem->qty);
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$rowItem->item_name}}</td>
        <td class="center">{{$rowItem->item_measure}}</td>
        <td class="center">{{$rowItem->site_name}}</td>
        <td class="center">{{myRound($rowItem->cost)}}</td>
        <td class="center">{{myRound($rowItem->qty)}}</td>
        <td class="center">{{myRound($rowItem->qut_in)}}</td>
        <td class="center">{{myRound($rowItem->remain)}}</td>
        <td class="center">{{$rowItem->description}}</td>
        <td class="center">{{myRound($rowItem->cost * $rowItem->qty)}}</td>
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="3" class="center">@lang('layout.Total')</td>
        <td colspan="3" class="center">{{myRound($total_home_curr)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>

<hr />
<h3>@lang('layout.Purchase')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.PurchaseNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Description')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.Rate')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Cost')</div>
            </td>
            @if(systemConfig()[7] == 0)
            <td>
                <div class="center"> @lang('layout.Expense')</div>
            </td>
            @endif
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
            @if(getDriverInfo()=="true")
            <th>@lang('layout.WayBillNumber') </th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.PaletNumber')</th>
            @endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalp = 0;
    $total2 = 0;
    $total_home_currency = 0;
    $currencies = [];
    $measures = [];
    ?>
    @foreach($purchaseData AS $record)
    <tr>
        <?php
        $totalp += $record->total_base + ($record->expense_cost * $record->qut_in);
        $total2 += $record->total_base;
        $total_home_currency += $record->Amount / $record->rate;
        if (array_key_exists($record->currency, $currencies)) {
            $currencies[$record->currency] = $currencies[$record->currency] + $record->Amount;
        } else {
            $currencies[$record->currency] = $record->Amount;
        }
        if (array_key_exists($record->Measure, $measures)) {
            $measures[$record->Measure] = $measures[$record->Measure] + $record->qut_in;
        } else {
            $measures[$record->Measure] = $record->qut_in;
        }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$record->number}}</td>
        <td class="center">
        <?php
            $wag = wordwrap($record->wagon_number, 40, "<br/>\n", false);
            echo $wag;
        ?>

        </td>
        <td class="center">
            {{convertDate($record->Date)}}
        </td>
        <td class="center">
        <?php
            $des = wordwrap($record->description, 40, "<br/>\n", false);
            echo $des;
        ?>
        </td>
        <td class="center">{{$record->Item}}</td>
        <td class="center">{{$record->Measure}}</td>
        <td class="center">{{$record->currency}}</td>
        <td class="center">{{$record->qut_in}}</td>
        <td class="center">{{$record->rate}}</td>
        <td class="center">{{$record->cost}}</td>
        @if(systemConfig()[7] == 0)
        <td class="center">{{($record->expense_cost*$record->rate)}}</td>
        <td class="center">{{(($record->total_base+($record->expense_cost*$record->qut_in))*$record->rate)}}</td>
        @endif
        @if(systemConfig()[7] != 0)
        <td class="center">{{($record->total_base*$record->rate)}}</td>
        <td class="center">{{$record->cmr_number}}</td>
        @if($record->driver_type == 'OwnDriver')
        <td class="center">{{$record->driver}}</td>
        <td class="center">{{$record->palet_number}}</td>
        @else
        <td class="center">{{$record->other_driver_name}}</td>
        <td class="center">{{$record->other_vehicle_name}}</td>
        @endif
        @endif
        @if(systemConfig()[7] != 1)
        @if(getDriverInfo()=="true")
        <td class="center">{{$record->way_bill_number}}</td>
        <td class="center">{{$record->transporter_name}}</td>
        <td class="center">{{$record->plate_number}}</td>
        @endif
        @endif
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="4">
            <div class="center">@lang('layout.PerUnit')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="2">
            <div class="center"> @lang('layout.Measure') </div>
        </td>
        <td colspan="2">
            <div class="center"> @lang('layout.Quantity') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($measures as $key => $meas) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="2">
                <div class="center">{{$key}}</div>
            </td>
            <td colspan="2">
                <div class="center">{{round($meas,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr class="bg">
        <td colspan="7" class="center">@lang('layout.Total')</td>
        @if(systemConfig()[7] == 0)
        <td colspan="3" class="center">{{myRound($totalp)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        @endif
        @if(systemConfig()[7] != 0)
        <td colspan="3" class="center">{{myRound($total2)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        @endif
    </tr>
</table>

<hr />
<h3>@lang('layout.OnHand') @lang('layout.Inventory') </h3>
<table class="main-table">
    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Site')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.OnHand')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.UnitCost')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_curr = 0;
    $site_item = [];
    ?>
    @foreach($inventoryWithOnhund AS $rows)
    <tr>
        <?php
        $total_home_curr += ($rows->Cost * $rows->Quantity);

        if (array_key_exists($rows->site, $site_item)) {
            $site_item[$rows->site] = $site_item[$rows->site] + $rows->Quantity;
        } else {
            $site_item[$rows->site] = $rows->Quantity;
        }

        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$rows->wagon_number}}</td>
        <td class="center">{{$rows->Name}}</td>
        <td class="center">{{$rows->site}}</td>
        <td class="center">{{$rows->Measure}}</td>
        <td class="center">{{myRound($rows->Quantity)}}</td>
        <td class="center">{{myRound($rows->Cost)}}</td>
        <td class="center">{{myRound($rows->Cost * $rows->Quantity)}}</td>
    </tr>

    @endforeach
    
</table>
<table class="main-table">
    <tr class="bg">
        <td colspan="5">
            <div class="center">@lang('layout.Per') @lang('layout.Site')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> #</div>
        </td>
        <td colspan="2">
            <div class="center"> @lang('layout.Measure') </div>
        </td>
        <td colspan="2">
            <div class="center"> @lang('layout.Quantity') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    if ($site_item) {
    foreach ($site_item as $keySS => $Itmm) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td colspan="2">
                <div class="center">{{$keySS}}</div>
            </td>
            <td colspan="2">
                <div class="center">{{round($Itmm,2)}}</div>
            </td>
        </tr>
    <?php
    }
    }
    ?>
    <tr class="bg">
        <td  class="center"></td>
        <td colspan="2" class="center">@lang('layout.Total')</td>
        <td colspan="2" class="center">{{myRound($total_home_curr)}}  {{getHomeCurrency()[getCurrencyType()]}} </td>
    </tr>
</table>

@if($inventoryTransfer)
<hr />
<h3>@lang('layout.InventoryTransfer') </h3>
<table class="main-table">
    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Transfer') #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.From') @lang('layout.Contract')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.to') @lang('layout.Contract')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.FromSite')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ToSite')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <dev calss="center"> @lang('layout.UnitCost')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_curr_tr = 0;
    $total_in_tr = 0;
    $total_out_tr = 0;
    $site_item = [];
    ?>
    @foreach($inventoryTransfer AS $rowtr)
    <tr>
        <?php
        $total_home_curr_tr += ($rowtr->AssetValue);
        
        if ($rowtr->to_conract_id == $contract->id) {
            $total_in_tr += ($rowtr->AssetValue);
        } else {
            $total_out_tr += ($rowtr->AssetValue);
        }

        $cost = 0;
        if ($rowtr->quantity != 0) {
            $cost = ($rowtr->AssetValue / $rowtr->quantity);
        }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$rowtr->id}}</td>
        <td class="center">{{convertDate($rowtr->Date)}}</td>
        <td class="center">{{$rowtr->from_conract}}</td>
        <td class="center">{{$rowtr->from_wagon_number}}</td>
        <td class="center">{{$rowtr->to_conract}}</td>
        <td class="center">{{$rowtr->to_wagon_number}}</td>
        <td class="center">{{$rowtr->ItemName}}</td>
        <td class="center">{{$rowtr->from_site}}</td>
        <td class="center">{{$rowtr->to_site}}</td>
        <td class="center">{{$rowtr->Measure}}</td>
        <td class="center">{{myRound($rowtr->quantity)}}</td>
        <td class="center">{{myRound($cost)}}</td>
        <td class="center">{{myRound($rowtr->AssetValue)}}</td>
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="5" class="center">@lang('layout.TotalIn') : {{myRound($total_in_tr)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td colspan="5" class="center">@lang('layout.TotalOut') : {{myRound($total_out_tr)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td colspan="4" class="center">@lang('layout.Differ') : {{myRound($total_in_tr - $total_out_tr)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
    <tr class="bg">
        <td colspan="3" class="center"></td>
        <td colspan="5" class="center">@lang('layout.Total')</td>
        <td colspan="5" class="center">{{myRound($total_home_curr_tr)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
    
</table>

@endif

@if($builds)
<hr />
<h3>@lang('layout.Build') </h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Number')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.ItemName')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Measure')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Quantity')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Cost')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.ItemExpense')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Description')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Date')</div>
            </th>
            <th>
                <div class="center"> @lang('layout.Total')</div>
            </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_curr = 0;
    ?>
    @foreach($builds AS $rowBuild)
    <tr>
        <?php
        $total_home_curr += $rowBuild->totalCost;
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$rowBuild->wagon_number}}</td>
        <td class="center">{{$rowBuild->number}}</td>
        <td class="center">{{$rowBuild->item_name}}</td>
        <td class="center">{{$rowBuild->measure}}</td>
        <td class="center">{{myRound($rowBuild->quantity)}}</td>
        <td class="center">{{myRound($rowBuild->cost)}}</td>
        <td class="center">{{myRound($rowBuild->expense_cost)}}</td>
        <td class="center">{{$rowBuild->description}}</td>
        <td class="center">{{convertDate($rowBuild->build_date)}}</td>
        <td class="center">{{myRound($rowBuild->totalCost)}}</td>
    </tr>

    @endforeach
    <tr class="bg">
        <td colspan="3" class="center">@lang('layout.Total')</td>
        <td colspan="3" class="center">{{myRound($total_home_curr)}}  {{getHomeCurrency()[getCurrencyType()]}}  </td>
    </tr>
</table>
@endif

@if(systemConfig()[7] != 0)
<hr />
<h3>@lang('layout.Loading')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th style="min-width: 100px">@lang('layout.Driver') </th>
            <!-- <th style="min-width: 100px">@lang('layout.Transporter_name') </th> -->
            <th style="min-width: 100px">@lang('layout.PaletNumber')</th>
            <th style="min-width: 100px">@lang('layout.TankerNumber')</th>
            <th style="min-width: 100px">@lang('layout.DriverType')</th>
            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
            <!-- <th style="min-width: 100px">@lang('layout.TransitNumber') </th> -->
            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
            <th style="min-width: 100px">@lang('layout.Destination') </th>
            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
            <th style="min-width: 100px">@lang('layout.Discharge') </th>
            <th style="min-width: 100px">@lang('layout.ItemName') </th>
            <th style="min-width: 100px">@lang('layout.Site') </th>
            <th style="min-width: 100px">@lang('layout.Measure') </th>
            <th>@lang('layout.LoadQuantity') </th>

            <th>@lang('layout.Price') </th>
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Rate') </th>
            <th>@lang('layout.TotalTransferFee') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totales = 0;
    ?>
    @foreach($loadingDetails AS $srecord)
    <?php
    $totales += ($srecord->Total / $srecord->Rate);
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        @if($srecord->driver_type == 'OwnDriver')
        <td class="center">{{$srecord->driver_name}}</td>
        <td class="center">{{$srecord->vehicle_palet_number}}</td>
        @else
        <td class="center">{{$srecord->other_driver_name}}</td>
        <td class="center">{{$srecord->other_vehicle_name}}</td>
        @endif
        <td class="center">{{$srecord->tanker_palet_number}}</td>
        <td class="center">{{ __('layout.' . $srecord->driver_type)  }}</td>
        <td class="center">{{$srecord->cmr_number}}</td>
        <!-- <td class="center">{{$srecord->transit_number}}</td> -->
        <td class="center">{{$srecord->source}}</td>
        <td class="center">{{$srecord->destination}}</td>
        <td class="center"> {{convertDate($srecord->loading_date)}} </td>
        @if($srecord->state == 'On')
        <td class="center">@lang('layout.Not')</td>
        @else
        <td class="center">@lang('layout.yes')</td>
        @endif
        <td class="center">{{$srecord->items}}</td>
        <td class="center">{{$srecord->site}}</td>
        <td class="center">{{$srecord->measure}}</td>
        <td class="center">{{myRound($srecord->qty)}}</td>
        <td class="center">{{$srecord->total_transfer_fee}}</td>
        <td class="center">{{$srecord->Currency}}</td>
        <td class="center">{{$srecord->Rate}}</td>
        <td class="center">{{myRound($srecord->Total)}}</td>

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td colspan="6" class="center">{{myRound($totales)}}  {{getHomeCurrency()[getCurrencyType()]}}  </td>
    </tr>
</table>

<hr />
<h3>@lang('layout.OverLoad')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.PaletNumber')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    ?>
    @foreach($ContractOverloadData AS $record1)
    <tr>
        <?php
        $totals += $record1->total;
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">
            {{convertDate($record1->Date)}}
        </td>
        <td class="center">{{$record1->item_name}}</td>
        <td class="center">{{$record1->Measure}}</td>
        <td class="center">{{$record1->qut_in}}</td>
        <td class="center">{{$record1->price}}</td>
        <td class="center">{{myRound($record1->total)}}</td>
        @if($record1->driver_type == 'OwnDriver')
        <td class="center">{{$record1->palet_number}}</td>
        @else
        <td class="center">{{$record1->other_vehicle_name}}</td>
        @endif

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td class="center">{{myRound($totals)}}  {{getHomeCurrency()[getCurrencyType()]}} </td>
    </tr>
</table>


<hr />
<h3>@lang('layout.LoadDrop')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.PaletNumber')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    ?>
    @foreach($adjasmentData AS $record2)
    <tr>
        <?php
        $totals += $record2->total;
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">
            {{convertDate($record2->Date)}}
        </td>
        <td class="center">{{$record2->item_name}}</td>
        <td class="center">{{$record2->Measure}}</td>
        <td class="center">{{$record2->qut_out}}</td>
        <td class="center">{{$record2->price}}</td>
        <td class="center">{{myRound($record2->total)}}</td>
        @if($record2->driver_type == 'OwnDriver')
        <td class="center">{{$record2->palet_number}}</td>
        @else
        <td class="center">{{$record2->other_vehicle_name}}</td>
        @endif

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>


<hr />
<h3>@lang('layout.Fine')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.PaletNumber')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    ?>
    @foreach($finedData AS $record3)
    <tr>
        <?php
        $totals += $record3->total;
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">
            {{convertDate($record3->Date)}}
        </td>
        <td class="center">{{$record3->item_name}}</td>
        <td class="center">{{$record3->Measure}}</td>
        <td class="center">{{$record3->qut_out}}</td>
        <td class="center">{{myRound($record3->price)}}</td>
        <td class="center">{{myRound($record3->total)}}</td>
        @if($record3->driver_type == 'OwnDriver')
        <td class="center">{{$record3->palet_number}}</td>
        @else
        <td class="center">{{$record3->other_vehicle_name}}</td>
        @endif

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>

@endif

<hr />
<h3>@lang('layout.AdjustmentList')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ReferenceNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ItemName')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    ?>
    @foreach($contractAdjasment AS $recor4)
    <tr>
        <?php
        $totals += $recor4->total;
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$recor4->ref_no}}</td>
        <td class="center">
            {{convertDate($recor4->Date)}}
        </td>
        <td class="center">{{$recor4->item_name}}</td>
        <td class="center">{{$recor4->Measure}}</td>
        <td class="center">{{myRound($recor4->qut_out)}}</td>
        <td class="center">{{$recor4->price}}</td>
        <td class="center">{{myRound($recor4->total)}}</td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>

<hr />
<h3>@lang('layout.Expense')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ExpenseCategory')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    ?>
    @foreach($expense AS $record5)
    <tr>
        <?php
        $totals += $record5->baseAmount;
        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{__('layout.' . ucfirst($record5->type))}}</td>
        <td class="center">{{myRound($record5->amount)}}</td>
        <td class="center">{{$record5->Currency}}</td>
        <td class="center">{{$record5->rate}}</td>
        <td class="center"> {{convertDate($record5->Date)}} </td>
        <td class="center">{{$record5->description}}</td>

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="4" class="center"> @lang('layout.Total') </td>
        <td colspan="3" class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>


<hr />
<h3>@lang('layout.ItemExpense')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.PartNumber')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.ExpenseType')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Total')</th>
            @if(systemConfig()[7] != 0)
            <th>@lang('layout.PaletNumber')</th>
            @endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    $category = [];
    ?>
    @foreach($itemExpense AS $record7)
    <tr>
        <?php
        $amount = 0;
        if ($record7->category == 'perUnit') {
            $amount = $record7->amount * $record7->quantity;
        } else {
            $amount = $record7->amount;
        }
        $totals += ($amount / $record7->rate);

        if (array_key_exists($record7->itemExpenseCategory, $category)) {
            $category[$record7->itemExpenseCategory] = $category[$record7->itemExpenseCategory] + ($amount / $record7->rate);
        } else {

            $category[$record7->itemExpenseCategory] = ($amount / $record7->rate);
        }

        ?>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record7->number}}</td>
        <td class="center">{{$record7->part_number}}</td>
        <td class="center">{{$record7->description}}</td>
        <td class="center">{{$record7->item_name}}</td>
        <td class="center">{{$record7->measure}}</td>
        <td class="center">{{$record7->quantity}}</td>
        <td class="center">{{__('layout.' . ucfirst($record7->category))}}</td>
        <td class="center">{{$record7->currency}}</td>
        <td class="center">{{$record7->rate}}</td>
        <td class="center">{{myRound($record7->amount)}}</td>
        <td class="center"> {{convertDate($record7->Date)}} </td>
        <td class="center">{{$record7->itemExpenseCategory}}</td>
        <td class="center">{{myRound($amount)}}</td>
        @if(systemConfig()[7] != 0)
        @if($record7->driver_type == 'OwnDriver')
        <td class="center">{{$record7->palet_number}}</td>
        @else
        <td class="center">{{$record7->other_vehicle_name}}</td>
        @endif
        @endif
    </tr>
    @endforeach
</table>

<table class="main-table">
    <tr class="bg">
        <td>
            <div class="center"> #</div>
        </td>
        <td>
            <div class="center"> @lang('layout.Category') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($category as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{myRound($currency)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>

    </tr>

</table>


<hr />
<h3>@lang('layout.Sale') @lang('layout.Service')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.SaleNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Customer')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Description')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Service')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    $total_home_currency = 0;
    $currencies = [];
    ?>
    @foreach($saleService AS $recordser)
    <tr>
        <?php

        $totals += $recordser->total
        // $total_home_currency += $record->Amount / $record->rate;
        // if (array_key_exists($record->currency, $currencies)) {
        //     $currencies[$record->currency] = $currencies[$record->currency] + $record->Amount;
        // } else {

        //     $currencies[$record->currency] = $record->Amount;
        // }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$recordser->number}}</td>
        <td class="center">{{$recordser->customer}}</td>
        <td class="center">
        <?php
            $wag = wordwrap($recordser->wagon_number, 40, "<br/>\n", false);
            echo $wag;
        ?>
        </td>
        <td class="center">
            {{convertDate($recordser->date)}}
        </td>
        <td class="center">{{$recordser->description}}</td>
        <td class="center">{{$recordser->name}}</td>
        <td class="center">{{$recordser->measure}}</td>
        <td class="center">{{myRound($recordser->qty)}}</td>
        <td class="center">{{myRound($recordser->price)}}</td>
        <td class="center">{{myRound($recordser->total)}}</td>
    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="6" class="center"> @lang('layout.Total') </td>
        <td class="center">{{myRound($totals)}}   {{getHomeCurrency()[getCurrencyType()]}} </td>
    </tr>
</table>


<hr />
<h3>@lang('layout.Sales')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.SaleNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Customer')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.WagonNumber')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Description')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <!-- <td>
                <div class="center"> @lang('layout.Price')</div>
            </td> -->
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
            @if(systemConfig()[7] != 0)
            <td>
                <div class="center"> @lang('layout.Driver')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.VehicleName')</div>
            </td>
            @endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $totals = 0;
    $total_home_currency = 0;
    $currencies = [];
    ?>
    @foreach($saleData AS $record8)
    <tr>
        <?php

        $totals += $record8->total;
        // $total_home_currency += $record->Amount / $record->rate;
        // if (array_key_exists($record->currency, $currencies)) {
        //     $currencies[$record->currency] = $currencies[$record->currency] + $record->Amount;
        // } else {

        //     $currencies[$record->currency] = $record->Amount;
        // }
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$record8->number}}</td>
        <td class="center">{{$record8->customer}}</td>
        <td class="center">
        <?php
            $wag = wordwrap($record8->wagon_number, 40, "<br/>\n", false);
            echo $wag;
        ?>
        </td>
        <td class="center">
            {{convertDate($record8->date)}}
        </td>
        <td class="center">{{$record8->description}}</td>
        <td class="center">{{$record8->item_name}}</td>
        <td class="center">{{$record8->measure}}</td>
        <td class="center">{{myRound($record8->qut_out)}}</td>
        <td class="center">{{myRound($record8->price)}}</td>
        <!-- <td class="center">{{$record8->assetAmount}}</td> -->
        <td class="center">{{myRound($record8->total)}}</td>
        @if(systemConfig()[7] != 0)
        <td class="center">{{$record8->driver_name}}</td>
        <td class="center">{{$record8->vehicle_name}}</td>
        @endif
    </tr>
    @endforeach
    <!-- <tr class="bg">
            <td colspan="6" class="center"> @lang('layout.Total') </td>
            <td class="center">{{$totals}} {{getReportCurrency()}}</td>
        </tr> -->
</table>

<h3 class="table-caption" style="text-align: center;">@lang('layout.TotalSale')</h3>
<table class="main-table">

    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>


            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ItemName')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Unit')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.SaleQty')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.TotalSale')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.TotalCostOfSale')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.GrossProfitORLost')</div>
            </td>

        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_currency = 0;
    $tat = 0;
    $tat1 = 0;
    $TotalLostAsset = 0;
    ?>
    @foreach($saleDataSummary AS $record9)
    <tr>
        <?php
        $total_home_currency += $record9->exchanged_amount;
        $tat += $record9->exchanged_amount;
        $tat1 += $record9->assetAmount;
        $TotalLostAsset += ($record9->exchanged_amount - $record9->assetAmount);
        ?>

        <td class="center">{{++$count}}</td>
        <td class="center">{{convertDate($record9->Date)}}</td>
        <td class="center">{{$record9->item_name}}</td>
        <td class="center">{{$record9->um}}</td>
        <td class="center">{{$record9->quantityOut}}</td>
        <td class="center">{{myRound($record9->Amount)}}</td>
        <td class="center">{{myRound($record9->assetAmount)}}</td>
        <td class="center">{{myRound($record9->Amount - $record9->assetAmount)}}</td>

    </tr>
    @endforeach
</table>


@if(count($summaryRefund)>0)
<br/>
<h3 style="text-align: center;">@lang('layout.Total') @lang('layout.Refund')</h3>

<table class="main-table">

    <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.ItemName')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Unit')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Unit')</div>
            </td>

        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_currency = 0;
    ?>
    @foreach($summaryRefund AS $record)

    <?php
    $total_home_currency += $record->Amount;
    ?>

    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{convertDate($record->Date)}}</td>
        <td class="center">{{$record->item_name}}</td>
        <td class="center">{{$record->quantityIn}}</td>
        <td class="center">{{$record->um}}</td>
        <td class="center">{{myRound($record->Amount)}}</td>
        <td class="center">{{getHomeCurrency()["code"]}}</td>
    </tr>
    @endforeach
    <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.Total')</div>
            </td>
            <td colspan="3">
                <div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()["code"]}}</div>
            </td>

        </tr>
</table>
<br/>
@endif

<table class="main-table">
    <tr class="bg">
        <td colspan="6">
            <center><span class="table-caption" style="text-align: center; font-size:22px;">@lang('layout.Total')</span></center>
        </td>
    </tr>
    <tr>
        <th colspan="2">
            <div class="center"> @lang('layout.TotalSale')</div>
        </th>
        <th colspan="2">
            <div class="center"> @lang('layout.TotalCostOfSale')</div>
        </th>
        <th colspan="2">
            <div class="center"> @lang('layout.Total') @lang('layout.GrossProfitORLost')</div>
        </th>
    </tr>
    <tr>
        <td colspan="2" class="center">{{myRound($tat)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td colspan="2" class="center">{{myRound($tat1)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td colspan="2" class="center">{{myRound($TotalLostAsset)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>

</table>


<br>
<table class="main-table bg">

    <tr>
        <td class="center">@lang('layout.GrossProfit'): {{myRound($grossProfit)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        <td class="center">@lang('layout.NetProfit'): {{myRound($all_benifed)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>


@endsection