@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract', 'index');
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.OverLoad')</h3>

    <hr/>
    <table class="main-table">

        <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Date')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Item')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Measure')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Quantity')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Price')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Total')</div>
            </td>
        </tr>
        </thead>
        <?php
        $count = 0;
        $totals = 0;
        ?>
        @foreach($data AS $srecord)
            <tr>
                <?php
                $totals += $srecord->total;
                ?>

                <td class="center">{{++$count}}</td>
                <td class="center">
                    {{convertDate($srecord->Date)}}
                </td>
                <td class="center">{{$srecord->item_name}}</td>
                <td class="center">{{$srecord->Measure}}</td>
                <td class="center">{{$srecord->qut_in}}</td>
                <td class="center">{{$srecord->price}}</td>
                <td class="center">{{myRound($srecord->total)}}</td>

            </tr>
        @endforeach
        <tr>
            <td colspan="6" class="center"> @lang('layout.Total') </td>
            <td class="center">{{$totals}}  {{getHomeCurrency()[getCurrencyType()]}} </td>
        </tr>
    </table>

@endsection