@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ContructReport')</h3>

<table class="main-table">
    <thead>
        <tr class="bg">
            <th  class="center" >
                <div > @lang('layout.ContractNumber') </div>
            </th>
            <th   class="center">
                <div > @lang('layout.ContractName') </div>
            </th>
            <th  class="center" >
                <div > @lang('layout.Vendor') </div>
            </th>
            <th  class="center">
                <div > @lang('layout.Phone') </div>
            </th>
            <th  class="center">
                <div > @lang('layout.Address') </div>
            </th>
            <th  class="center">
                <div > @lang('layout.Email') </div>
            </th>
            <th  class="center">
                <div > @lang('layout.Description') </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $contract->contract_no}} </td>
            <td class=""> {{ $contract->company_name}} </td>
            <td class=""> {{ $contract->name}} </td>
            <td class=""> {{ $contract->phone}}</td>
            <td class=""> {{ $contract->address}}</td>
            <td class=""> {{ $contract->email}}</td>
            <td class=""> {{ $contract->description}}</td>
        </tr>
    </tbody>
</table>

<hr />
<h3>@lang('layout.Loading')</h3>
<table class="main-table">

    <thead>


        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th style="min-width: 100px">@lang('layout.Driver') </th>
            <!-- <th style="min-width: 100px">@lang('layout.Transporter_name') </th> -->
            <th style="min-width: 100px">@lang('layout.PaletNumber')</th>
            <!-- <th style="min-width: 100px">@lang('layout.TankerNumber')</th>
            <th style="min-width: 100px">@lang('layout.DriverType')</th>
            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th> -->
            <!-- <th style="min-width: 100px">@lang('layout.TransitNumber') </th> -->
            <th style="min-width: 100px">@lang('layout.SourcePlace') </th>
            <th style="min-width: 100px">@lang('layout.Destination') </th>
            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
            <th style="min-width: 100px">@lang('layout.Discharge') </th>
            <th style="min-width: 100px">@lang('layout.ItemName') </th>
            <th style="min-width: 100px">@lang('layout.Site') </th>
            <th style="min-width: 100px">@lang('layout.Measure') </th>
            <th>@lang('layout.LoadQuantity') </th>
            <th>@lang('layout.DischargeQuantity') </th>
            <th>@lang('layout.Differ') </th>
            <th>@lang('layout.OverLoad') </th>
            <th>@lang('layout.LoadDrop') </th>
            <th>@lang('layout.FinedAmount') </th>
        </tr>
    </thead>
    <?php
    $count = 0;
    $totales = 0;
    $qty = 0;
    $QtyOut = 0;
    $Differ = 0;
    $overLoad = 0;
    $leakage = 0;
    $fined = 0;
    ?>
    @foreach($loadingDetails AS $srecord)
    <?php
    $totales += ($srecord->Total / $srecord->Rate);
    $qty += ($srecord->qty);
    $QtyOut += ($srecord->QtyOut + $srecord->overLoad);
    $Differ += (($srecord->QtyOut + $srecord->overLoad) - $srecord->qty);
    $overLoad += ($srecord->overLoad);
    $leakage += ($srecord->leakage);
    $fined += ($srecord->fined);
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        @if($srecord->driver_type == 'OwnDriver')
        <td class="center">{{$srecord->driver_name}}</td>
        <td class="center">{{$srecord->vehicle_palet_number}}</td>
        @else
        <td class="center">{{$srecord->other_driver_name}}</td>
        <td class="center">{{$srecord->other_vehicle_name}}</td>
        @endif
        <!-- <td class="center">{{$srecord->tanker_palet_number}}</td> -->
        <!-- <td class="center">{{ __('layout.' . $srecord->driver_type)  }}</td> -->
        <!-- <td class="center">{{$srecord->cmr_number}}</td> -->
        <!-- <td class="center">{{$srecord->transit_number}}</td> -->
        <td class="center">{{$srecord->source}}</td>
        <td class="center">{{$srecord->destination}}</td>
        <td class="center"> {{convertDate($srecord->loading_date)}} </td>
        @if($srecord->state == 'On')
        <td class="center">@lang('layout.Not')</td>
        @else
        <td class="center">@lang('layout.yes')</td>
        @endif
        <td class="center">{{$srecord->items}}</td>
        <td class="center">{{$srecord->site}}</td>
        <td class="center">{{$srecord->measure}}</td>
        <td class="center">{{myRound($srecord->qty)}}</td>
        <td class="center">{{myRound($srecord->QtyOut + $srecord->overLoad)}}</td>
        <td class="center">{{myRound(($srecord->QtyOut + $srecord->overLoad) - ($srecord->qty))}}</td>
        <td class="center">{{myRound($srecord->overLoad)}}</td>
        <td class="center">{{myRound($srecord->leakage)}}</td>
        <td class="center">{{myRound($srecord->fined)}}</td>

    </tr>
    @endforeach
    <tr class="bg">
        <td colspan="10" class="center"> @lang('layout.Total') </td>
        <td colspan="1" class="center">{{myRound($qty)}}</td>
        <td colspan="1" class="center">{{myRound($QtyOut)}}</td>
        <td colspan="1" class="center">{{myRound($Differ)}}</td>
        <td colspan="1" class="center">{{myRound($overLoad)}}</td>
        <td colspan="1" class="center">{{myRound($leakage)}}</td>
        <td colspan="1" class="center">{{myRound($fined)}}</td>
        <!-- <td colspan="6" class="center">{{myRound($totales)}} {{getReportCurrency()}}</td> -->
    </tr>
</table>



@endsection