@extends('layouts.factor-master')

@section('content')
    <?php
        $report = customeReport('contract');
            $_code = in_array('code', $report);
            $_date = in_array('date', $report);
            $_contract_name = in_array('contract_name', $report);
            $_vendor = in_array('vendor', $report);
            $_bank = in_array('bank', $report);
            $_price = in_array('price', $report);
            $_amount = in_array('amount', $report);
            $_currency = in_array('currency', $report);
            $_rate = in_array('rate', $report);
            $_total_in_home_currency = in_array('total_in_home_currency', $report);

        $report_delivery = customeReportNew('delivery_index');
            $_record = !in_array('record', $report_delivery);
            $_number = !in_array('number', $report_delivery);
            $_date = !in_array('date', $report_delivery);
            $_description = !in_array('description', $report_delivery);
            $_customer = !in_array('customer', $report_delivery);
            $_quantity = !in_array('quantity', $report_delivery);
            $_user = !in_array('user', $report_delivery);
        // percent start 
        $report_delivery_percent = customeReportNewPercent('delivery_index');
            $_record_percent = (array_key_exists('record___percent', $report_delivery_percent))?$report_delivery_percent['record___percent']:null;
            $_number_percent = (array_key_exists('number___percent', $report_delivery_percent))?$report_delivery_percent['number___percent']:null;
            $_date_percent = (array_key_exists('date___percent', $report_delivery_percent))?$report_delivery_percent['date___percent']:null;
            $_description_percent = (array_key_exists('description___percent', $report_delivery_percent))?$report_delivery_percent['description___percent']:null;
            $_customer_percent = (array_key_exists('customer___percent', $report_delivery_percent))?$report_delivery_percent['customer___percent']:null;
            $_quantity_percent = (array_key_exists('quantity___percent', $report_delivery_percent))?$report_delivery_percent['quantity___percent']:null;
            $_user_percent = (array_key_exists('user___percent', $report_delivery_percent))?$report_delivery_percent['user___percent']:null;
        // percent end
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.DeliveryReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                @if($_record)
                    <th class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif><div> @lang('layout.Record')</div></th>
                @endif
                @if($_number)
                    <th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>
                @endif
                @if($_date)
                    <th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>
                @endif
                @if($_description)
                    <th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>
                @endif
                @if($_customer)
                    <th @if($_customer_percent) width="{{$_customer_percent}}%" @endif>@lang('layout.Customer')</th>
                @endif
                @if($_quantity)
                    <th @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif>@lang('layout.Quantity')</th>
                @endif
                @if($_user)
                    <th @if($_user_percent) width="{{$_user_percent}}%" @endif>@lang('layout.User')</th>
                @endif
            </tr>
        </thead>
        <?php
            $count = 0;
            $total_home_currency = 0;
            $currencies = [];
            $totalQuantity = 0;
            $colspan = 5;
        ?>
        @foreach($data AS $record)
            <?php 
                $totalQuantity += $record->quantity;
            ?>
            <tr>
                @if($_record)
                    <td class="center">{{++$count}}</td>
                @endif
                @if($_number)
                    <td class="center">{{$record->number}}</td>
                @endif
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>
                @endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>
                @endif
                @if($_customer)
                    <td class="center">{{$record->member}}</td>
                @endif
                @if($_quantity)
                    <td class="center">{{myRound($record->quantity)}}</td>
                @endif
                @if($_user)
                    <td class="center">{{$record->user}}</td>
                @endif
            </tr>
        @endforeach
        @if(!$_record)      <?php  $colspan = $colspan-1;  ?> @endif
        @if(!$_number)      <?php  $colspan = $colspan-1;  ?> @endif
        @if(!$_date)        <?php  $colspan = $colspan-1;  ?> @endif
        @if(!$_description) <?php  $colspan = $colspan-1;  ?> @endif
        @if(!$_customer)    <?php  $colspan = $colspan-1;  ?> @endif
        <tr class="bg">
            <td colspan="{{$colspan}}" style="text-align: center; font-weight: bold;">@lang('layout.Total')</td>
            @if($_quantity)
                <td class="center" style="font-weight: bold;">{{myRound($totalQuantity)}}</td>
            @endif
            @if($_user)
                <td></td>
            @endif
        </tr>
    </table>
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >           
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection