@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('contract');
    $_code = in_array('code', $report);
    $_date = in_array('date', $report);
    $_contract_name = in_array('contract_name', $report);
    $_vendor = in_array('vendor', $report);
    $_bank = in_array('bank', $report);
    $_price = in_array('price', $report);
    $_amount = in_array('amount', $report);
    $_currency = in_array('currency', $report);
    $_rate = in_array('rate', $report);
    $_total_in_home_currency = in_array('total_in_home_currency', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CargoContractReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td><div class="center"> #</div></td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Customer')</th>
            <th>@lang('layout.Source')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Volume')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Weight') @lang('layout.Package')</th>
            <th>@lang('layout.Volume') @lang('layout.Package')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Discount')</th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.ExpenseDetails')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_home_currency = 0;
        $currencies = [];
        ?>
        @foreach($data AS $record)
            <tr>
            <?php
            $total = 0;

            // $total = ($record->amount + (($record->ex_amount)?$record->ex_amount:0) - (($record->discount)?$record->discount:0));
            $total = ($record->amount);

            $total_home_currency += $total / $record->rate;
            if (array_key_exists($record->currency, $currencies)) {
                $currencies[$record->currency] = $currencies[$record->currency] + $total;
            } else {

                $currencies[$record->currency] = $total;
            }
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->Customer}}</td>
                <td class="center">{{$record->source_name}}</td>
                <td class="center">{{$record->destination_name}}</td>
                <td class="center">{{$record->item_description1}}</td>
                <td class="center">{{$record->width}}</td>
                <td class="center">{{$record->length}}</td>
                <td class="center">{{$record->height}}</td>
                <td class="center">{{$record->volume}}</td>
                <td class="center">{{$record->weight}}</td>
                <td class="center">{{$record->quantity_in}}</td>
                <td class="center">{{myRound($record->weight * $record->quantity_in)}}</td>
                <td class="center">{{myRound($record->volume * $record->quantity_in)}}</td>
                <td class="center">{{$record->currency}}</td>
                <td class="center">{{myRound($record->price)}}</td>
                <td class="center">{{myRound($record->discount)}}</td>
                <td class="center">{{myRound($record->ex_amount)}}</td>
                <td class="center">{{$record->ex_description}}</td>
                <td class="center">{{myRound($total)}}</td>
            </tr>
        @endforeach

    </table>
    <table class="main-table">
        <tr class="bg">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>
        <tr>
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency )
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
        <?php
        }
        ?>
        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->


@endsection