@extends('layouts.app')

@section('content')
@include('contracts.modal')

<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}

    <input type="hidden" name="type" value="contract_profitandlost" />
    <input type="hidden" name="id" value="{{$contract->id}}" />

    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group"> 
                </div>
            </div>
            <div class="row"> 
                <!-- <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>
                </div> --> 
                <div class="form-group">
                    <div class="col-md-12">
                        <label class="control-label">@lang('layout.WagonNumber')</label>
                        <input type="hidden" name="wagon_number" :value="(this.selected_wagon==null)?null:selected_wagon.name">
                    </div>
                </div>
                <div class="form-group">
                    <!--    <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date">
                          
                        </div>
                    </div>
                </div> -->
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->

<div id="print-modal1" v-cloak>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show1" :value-type="'loading'" @closed="closeModal">

        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

<!-- END PAGE HEADER-->


<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}


    <input type="hidden" name="type" value="contract_profitandlost" />
    <input type="hidden" name="id" value="{{$contract->id}}" />

    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>
            <div class="row">
                <div class="form-group">

                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>

                </div>
                <div class="form-group">
                    <!--    <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" name="to_date">
                          
                        </div>
                    </div>
                </div> -->
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->


<div id="loading_app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}


    <input type="hidden" name="type" value="contract_loading" />
    <input type="hidden" name="id" value="{{$contract->id}}" />

    <button id="loading-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Site') </label>
                        <select name="site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectSite')</option>
                            @foreach($inventorySite as $row)
                            <option value="{{$row['id']}}">{{$row['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Location') </label>
                        <v-select label="name" v-model="loadingLocationSel" :options="loadingLocation"></v-select>
                        <input type="hidden" name="location" :value="(!loadingLocationSel)?null:loadingLocationSel.name">
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Source') </label>
                        <v-select label="name" v-model="loadingSourceSel" :options="loadingSource"></v-select>
                        <input type="hidden" name="source" :value="(!loadingSourceSel)?null:loadingSourceSel.name">
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.Destination') </label>
                        <v-select label="name" v-model="loadingDestinationSel" :options="loadingDestination"></v-select>
                        <input type="hidden" name="destination" :value="(!loadingDestinationSel)?null:loadingDestinationSel.name">
                    </div>
                    <div class="col-md-6">
                        <label>@lang('layout.Discharged')</label>
                        <input class="mt-checkbox" type="checkbox" name="discharged">
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->


<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_item_expense" />


    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>

            <div class="row">
                <div class="form-group">

                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>

                </div>

                <div class="form-group">
                    <div class="col-md-12">
                        <!--  <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                          
                        </div>
                    </div> -->
                    </div>
                </div>
            </div>

        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>



<!-- app -->
<div id="app3" v-cloak>
    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="contract_item_expense" />


    <input type="hidden" name="id" value="{{$contract->id}}" />
    <button id="show-modal3" style="display: none" type="button" @click="editExample3">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">

                </div>
            </div>

            <div class="row">
                <div class="form-group">

                    <div class="col-md-12">
                        <label class="control-label ">@lang('layout.WagonNumber') </label>
                        <input type="text" name="wagon_number" class="form-control">

                    </div>

                </div>

                <div class="form-group">
                    <div class="col-md-12">
                        <!--  <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example2" name="from_date">
                           
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example2" name="to_date">
                          
                        </div>
                    </div> -->
                    </div>
                </div>
            </div>

        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>



<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.CargoContractOrderShow')
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $contract->number}} </td>
                        <td class=""> {{ $contract->ref_no}} </td>
                        <td class=""> {{ $contract->Customer}} </td>
                        <td class=""> {{ $contract->amount}} {{ $contract->currency}}</td>
                        <td class=""> {{ $contract->rate}}</td>
                        <td class=""> {{ $contract->date}}</td>
                        <td class="">
                            @if($contract->status == "Active")
                            @lang('layout.Active')
                            @else
                            @lang('layout.Closed')
                            @endif
                        </td>
                        <td class=""> {{ $contract->user}}</td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
                <thead>
                    <tr>
                        <th>@lang('layout.DeliveryDate')</th>
                        <th>@lang('layout.Description')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $contract->delivery_date}} </td>
                        <td class=""> {{ $contract->description}}</td>
                    </tr>
                </tbody>
            </table>
            <!-- '''''''''''''''''''''''' -->
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            {{-- <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ContractDetails')</span>
                </div>
                <div class="tools"></div>
                <div class="actions">
                    
                    {{Form::open(['route' => 'cargoContractOrder.report','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="profitAndLost" />
                    <input type="hidden" name="report_format" value="pdf" />
                    <input type="hidden" name="id" value="{{$contract->id}}" />
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.ProfitAndLost') </button>
                    {{Form::close()}}
                </div>
            </div> --}}
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#contract-items" data-toggle="tab" id="contract-item"> @lang('layout.ItemDetails') <i class="fa "></i> </a>
                    </li>
                    {{-- <li>
                        <a href="#in_stock_item" data-toggle="tab" id="in_stock_items"> @lang('layout.OnHand') <i class="fa "></i> </a>
                    </li>
                    <li>
                        <a href="#load_item" data-toggle="tab" id="load_items"> @lang('layout.TransferAndLoading') <i class="fa "></i> </a>
                    </li>
                    <li>
                        <a href="#Westage" data-toggle="tab" id="Westages"> @lang('layout.Westage') <i class="fa "></i> </a>
                    </li>
                    <li>
                        <a href="#delivery_item_tab" data-toggle="tab" id="delivery_item"> @lang('menu.Delivery') </a>
                    </li>
                    <li>
                        <a href="#item_expense_tab" data-toggle="tab" id="item_expense"> @lang('layout.ItemExpense') </a>
                    </li> --}}
                    <li>
                        <a href="#attachments_tab" data-toggle="tab" id="attachments"> @lang('layout.Attachments') </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane" id="load_item">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.TransferAndLoadingList')</span>
                                </div>
                                <div class="pull-right">
                                    <span id="anchore-modal1">
                                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                            <i class="fa fa-print"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="load-item-table">
                                    <thead>
                                        <tr>
                                        <th>@lang('layout.Number')</th>
                                        <th>@lang('layout.Type')</th>
                                        <th>@lang('menu.Container')</th>
                                        <th>@lang('menu.Vehicle')</th>
                                        <th>@lang('layout.TransitNumber')</th>
                                        <th>@lang('layout.Source')</th>
                                        <th>@lang('layout.Quantity')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Status')</th>
                                        <th>@lang('layout.Responsible')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.User')</th>
                                        <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="Westage">
                        <div class="tab-pane" id="tab_15_1">

                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.AdjustmentList')</span>
                                    </div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'cargoWastage.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="wastage" />
                                        <input type="hidden" name="report_format" value="excel"/>
                                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                        </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'cargoWastage.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="wastage" />
                                        <input type="hidden" name="report_format" value="pdf"/>
                                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="Westage-table">
                                        <thead>
                                            <tr>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.Customer')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Amount')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.User')</th>
                                            <th>@lang('layout.Actions')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->

                        </div>
                    </div>

                    <div class="tab-pane active" id="contract-items">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ItemDetails')</span>
                                </div>
                                <div class="actions">
                                    {{Form::open(['route' => 'cargoContractOrder.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="contract_item_detail" />
                                    <input type="hidden" name="report_format" value="excel" />
                                    <input type="hidden" name="id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                    </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'cargoContractOrder.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="contract_item_detail" />
                                    <input type="hidden" name="report_format" value="pdf" />
                                    <input type="hidden" name="id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="contract-item-table">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Source')</th>
                                            <th>@lang('layout.Destination')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Length')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.Volume')</th>
                                            <th>@lang('layout.Weight')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.QutOut')</th>
                                            <th>@lang('layout.RemainQuantity')</th>
                                            <th>@lang('layout.Density')</th>
                                            <th>@lang('layout.Weight') @lang('layout.Package')</th>
                                            <th>@lang('layout.Volume') @lang('layout.Package')</th>
                                            <th>@lang('layout.Price')</th>
                                            <th>@lang('layout.Discount')</th>
                                            <th>@lang('layout.Total')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="in_stock_item">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ItemDetails')</span>
                                </div>
                                <div class="actions">
                                    {{Form::open(['route' => 'cargoContractOrder.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="contract_in_stock_item" />
                                    <input type="hidden" name="report_format" value="excel" />
                                    <input type="hidden" name="id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                    </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'cargoContractOrder.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="contract_in_stock_item" />
                                    <input type="hidden" name="report_format" value="pdf" />
                                    <input type="hidden" name="id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="in_stock_item-table">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Source')</th>
                                            <th>@lang('layout.Destination')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Width')</th>
                                            <th>@lang('layout.Length')</th>
                                            <th>@lang('layout.Height')</th>
                                            <th>@lang('layout.Volume')</th>
                                            <th>@lang('layout.Weight')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Density')</th>
                                            <th>@lang('layout.Weight') @lang('layout.Package')</th>
                                            <th>@lang('layout.Volume') @lang('layout.Package')</th>
                                            <th>@lang('layout.Price')</th>
                                            <th>@lang('layout.Discount')</th>
                                            <th>@lang('layout.Expense')</th>
                                            <th>@lang('layout.ExpenseDetails')</th>
                                            <th>@lang('layout.Total')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="delivery_item_tab">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('menu.Delivery')</span>
                                </div>
                                <div class="actions">
                                    {{Form::open(['route' => 'cargoDelivery.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="delivery" />
                                    <input type="hidden" name="report_type" value="detail" />
                                    <input type="hidden" name="report_format" value="excel"/>
                                    <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                    </button>
                                    {{Form::close()}}
                                    {{Form::open(['route' => 'cargoDelivery.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="delivery" />
                                    <input type="hidden" name="report_type" value="detail" />
                                    <input type="hidden" name="report_format" value="pdf"/>
                                    <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    {{Form::close()}}
                                </div>

                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="delivery_item_table">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Number')</th>
                                            <th>@lang('layout.Customer')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.User')</th>
                                            <th>@lang('layout.Actions')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="item_expense_tab">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
                                    </div>
                                    <!-- <div class="actions">
                                        <button type="button" id="contract_item_expense_excel" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                        </button>
                                        <button type="button" id="contract_item_expense_pdf" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                    </div> -->
                                    <div class="actions">
                                        {{Form::open(['route' => 'cargoItemExpense.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail_contract" />
                                        <input type="hidden" name="report_format" value="excel" />
                                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')
                                        </button>
                                        {{Form::close()}}
                                        {{Form::open(['route' => 'cargoItemExpense.report','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_expense_detail_contract" />
                                        <input type="hidden" name="report_format" value="pdf" />
                                        <input type="hidden" name="contract_id" value="{{$contract->id}}" />
                                        <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="item_expense_table">
                                        <thead>
                                            <tr>
                                            <th>@lang('layout.Customer') </th>
                                            <th>@lang('layout.ItemName') </th>
                                            <th>@lang('layout.SiteName') </th>
                                            <th>@lang('layout.Quantity') </th>
                                            <th>@lang('layout.Weight') </th>
                                            <th>@lang('layout.Currency') </th>
                                            <th>@lang('layout.Rate') </th>
                                            <th>@lang('layout.Total')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="attachments_tab">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                </div>

                            </div>
                            <div class="portlet-body">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">

                                        <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="redirect_route" value="cargoContractOrder.show">
                                            <input type="hidden" name="foreign_data_id" value="{{$contract->id}}">
                                            <input type="hidden" name="path" value="uploads/cargoContractOrder">
                                            <input type="hidden" name="table_name" value="cargo_contract_order">

                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                        <input type="text" name="title" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-7">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="" alt=""> </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                            <div>
                                                                <span class="btn default btn-file">
                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                    <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="margiv-top-10">
                                                <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <table class="table table-striped table-bordered table-hover" id="attachment">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.AttachmentTitle')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Action')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>


                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#item_expense').on('shown.bs.tab', function(event) {
            $('#item_expense_table').DataTable({
                scrollCollapse: true,
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("cargoContractOrder.show",$contract->id)}}',
                    data: {
                        type: 'item_expense'
                    }
                },
                columns: [
                    {data: 'member', name: 'member'},
                    {data: 'name', name: 'name'},
                    {data: 'destination', name: 'destination'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'weight', name: 'weight'},
                    {data: 'currency', name: 'currency'},
                    {data: 'rate', name: 'rate'},
                    {data: 'total', name: 'total', orderable: false, searchable: false},
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#delivery_item').on('shown.bs.tab', function(event) {
            $('#delivery_item_table').DataTable({
                scrollCollapse: true,
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("cargoContractOrder.show",$contract->id)}}',
                    data: {
                        type: 'delivery_item'
                    }
                },
                columns: [
                    {data: 'number', name: 'cargo_deliveries.number'},
                    {data: 'member', name: 'members.name'},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'date', name: 'cargo_deliveries.date', searchable: false},
                    {data: 'description', name: 'cargo_deliveries.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        });

    });
    
    
    // Contract Date

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#load_items').on('shown.bs.tab', function(event) {
            $('#load-item-table').DataTable({
                scrollCollapse: true,
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("cargoContractOrder.show",$contract->id)}}',
                    data: {
                        type: 'load_item'
                    }
                },
                columns: [
                    {data: 'number', name: 'cargo_loadings.number'},
                    {data: 'type', name: 'cargo_loadings.type'},
                    {data: 'container', name: 'vehicles.vehicle_name', searchable: false},
                    {data: 'vehicle', name: 'vehicles.vehicle_name', searchable: false},
                    {data: 'transit_number', name: 'transit_number', searchable: false},
                    {data: 'source_site', name: 'source_site', searchable: false},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'date', name: 'cargo_loadings.date', searchable: false},
                    {data: 'state', name: 'inventory_sites.name', orderable: false, searchable: false},
                    {data: 'employee', name: 'members.name'},
                    {data: 'description', name: 'cargo_loadings.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#Westages').on('shown.bs.tab', function(event) {
            $('#Westage-table').DataTable({
                scrollCollapse: true,
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("cargoContractOrder.show",$contract->id)}}',
                    data: {
                        type: 'Westage'
                    }
                },
                columns: [
                    {data: 'number', name: 'cargo_wastages.number'},
                    {data: 'member', name: 'members.name'},
                    {data: 'quantity', name: 'quantity', searchable: false},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'date', name: 'cargo_wastages.date', searchable: false},
                    {data: 'description', name: 'cargo_wastages.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        });

    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#contract-item-table').DataTable({
            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("cargoContractOrder.show",$contract->id)}}',
                data: {
                    type: 'contract_item'
                }
            },
            columns: [{
                    data: 'source_name',
                    name: 'source_name'
                },
                {
                    data: 'destination_name',
                    name: 'destination_name'
                },
                {
                    data: 'item',
                    name: 'item'
                },
                {
                    data: 'width',
                    name: 'width'
                },
                {
                    data: 'length',
                    name: 'length'
                },
                {
                    data: 'height',
                    name: 'height'
                },
                {
                    data: 'volume',
                    name: 'volume'
                },
                {
                    data: 'weight',
                    name: 'weight'
                },
                {
                    data: 'quantity_in',
                    name: 'quantity_in'
                },
                {
                    data: 'quantity_out',
                    name: 'quantity_out'
                },
                {
                    data: 'remian',
                    name: 'remian'
                },
                {
                    data: 'Density',
                    name: 'Density'
                },
                {
                    data: 'package_weight',
                    name: 'package_weight'
                },
                {
                    data: 'package_volume',
                    name: 'package_volume'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'discount',
                    name: 'discount'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
            ]
        });

        $('#in_stock_items').on('shown.bs.tab', function(event) {
            $('#in_stock_item-table').DataTable({
                scrollCollapse: true,
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("cargoContractOrder.show",$contract->id)}}',
                    data: {
                        type: 'in_stock_item'
                    }
                },
                columns: [{
                        data: 'source_name',
                        name: 'source_name'
                    },
                    {
                        data: 'destination_name',
                        name: 'destination_name'
                    },
                    {
                        data: 'item',
                        name: 'item'
                    },
                    {
                        data: 'width',
                        name: 'width'
                    },
                    {
                        data: 'length',
                        name: 'length'
                    },
                    {
                        data: 'height',
                        name: 'height'
                    },
                    {
                        data: 'volume',
                        name: 'volume'
                    },
                    {
                        data: 'weight',
                        name: 'weight'
                    },
                    {
                        data: 'quantity_in',
                        name: 'quantity_in'
                    },
                    {
                        data: 'Density',
                        name: 'Density'
                    },
                    {
                        data: 'package_weight',
                        name: 'package_weight'
                    },
                    {
                        data: 'package_volume',
                        name: 'package_volume'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'discount',
                        name: 'discount'
                    },
                    {
                        data: 'ex_amount',
                        name: 'ex_amount'
                    },
                    {
                        data: 'ex_description',
                        name: 'ex_description'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                ]
            });
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';

        $('#attachment').DataTable({
            ajax: {
                url: '{{route("cargoContractOrder.show",$contract->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });



    });


    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
            selected_wagon: null,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    $('#profit_and_lost').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    });



    // start loading_app

    new Vue({
        el: '#loading_app',
        data: {
            showModal: false,
            loadingSource: [],
            loadingSourceSel: null,
            loadingDestination: [],
            loadingDestinationSel: null,
            loadingLocation: [],
            loadingLocationSel: null

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#contract_loading').on('click', function(e) {
        $('#loading-modal').click();
        e.preventDefault();
    });


    new Vue({
        el: '#app2',
        data: {
            showModal: false,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample2: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#contract_item_expense_excel').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    });


    new Vue({
        el: '#app3',
        data: {
            showModal: false,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample3: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    var vm1 = new Vue({
        el: '#print-modal1',
        data: {
            is_show1: false,
            pdfRoute: '{!!route("cargoLoading.report") !!}',
            excelRoute: '{!! route("cargoLoading.report") !!}',
        },
        methods: {
            closeModal: function() {
                this.is_show1 = !this.is_show1
            },


        }
    });

    new Vue({
        el: '#anchore-modal1',
        methods: {
            showModal: function() {
                console.log('trr')
                vm1.$data.is_show1 = true;

            }
        }
    });

    $('#contract_item_expense_pdf').on('click', function(e) {
        $('#show-modal3').click();
        e.preventDefault();
    });

    Vue.component('v-select', VueSelect.VueSelect);
</script>


@endpush