@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <!-- new modal -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'cargoOrder'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.ContractNumber') </label>
                            <input type="number" name="number" class="form-control" autocomplete="off">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select class="form-control" name="status">
                                <option value="">@lang('layout.Select')</option>
                                <option value="Active">@lang('layout.Active')</option>
                                <option value="Deactive">@lang('layout.Closed')</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.CargoContractOrder')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoContract-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('CargoContract-create')
                    <a href="{{route('cargoContractOrder.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContractOrder">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Amount')</th>
                        {{-- <th>@lang('layout.Currency')</th> --}}
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>

        function factorPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('cargoContractOrderFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#cargoContractOrder').DataTable({
                ajax: '{{route("cargoContractOrder.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'cargo_contract_order.number'},
                    {data: 'ref_no', name: 'cargo_contract_order.ref_no'},
                    {data: 'Customer', name: 'members.name'},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    // {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'Status', name: 'status', orderable: false, searchable: false},
                    {data: 'description', name: 'cargo_contract_order.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false}
                ]
            });
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route("cargoContractOrder.report") !!}',
                excelRoute: '{!! route("cargoContractOrder.report") !!}',
                selectedMember: null,
                member: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
