@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.CompletedProjectsReport');
?>
@section('content')
<?php
$report = customeReport('invoice', 'index');
?>

<table style="width: 100%; border: 1px solid black;" class="main-table">
  <tr>
    <th>@lang('layout.Customer'): {{$member->name}}</th>
    <th><span>@lang('layout.Phone'): {{$phone}}</span></th>
    <th>@lang('layout.ID'): {{$contract->number}}</th>
  </tr>
  <tr style="font-weight: bold; font-size: 17px">

    <td colspan="2">
      <div class="center">@lang('layout.Date'): {{($contract->date)}}</div>
    </td>
  </tr>
</table>
<table class="main-table">
  <tr>
    <td>
      <div class="center"> #</div>
    </td>
    <th>@lang('layout.Source')</th>
    <th>@lang('layout.Destination')</th>
    <th>@lang('layout.ItemName')</th>
    <th>@lang('layout.Width')</th>
    <th>@lang('layout.Length')</th>
    <th>@lang('layout.Height')</th>
    <th>@lang('layout.Volume')</th>
    <th>@lang('layout.Weight')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Density')</th>
    <th>@lang('layout.Weight') @lang('layout.Package')</th>
    <th>@lang('layout.Volume') @lang('layout.Package')</th>
    <th>@lang('layout.Price')</th>
    <th>@lang('layout.Total')</th>
  </tr>
  <?php
  $count = 0;
  $empty = 0;
  $qtyTotal = 0;
  $discount = 0;
  $ex_amount = 0;
  $total_amount = 0;
  $fullCount = count($data);
  if ($fullCount < 20) {
    $empty = 20 - $fullCount;
  }
  ?>
  @foreach($data AS $record)
  <?php
  $qtyTotal += (float)$record->quantity_in;
  $discount += (float)$record->discount;
  $ex_amount += (float)$record->ex_amount;
  $total_amount += (float)$record->amount;
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->source_name}}</td>
    <td class="center">{{$record->destination_name}}</td>
    <td class="center">{{$record->item_description1}} <br /> {{$record->item_description2}}</td>
    <td class="center">{{$record->width}}</td>
    <td class="center">{{$record->length}}</td>
    <td class="center">{{$record->height}}</td>
    <td class="center">{{$record->volume}}</td>
    <td class="center">{{$record->weight}}</td>
    <td class="center">{{$record->quantity_in}} {{$record->measure}}</td>
    <td class="center">
      <?php
      $package_weight = ($record->weight * $record->quantity_in);
      $package_volume = ($record->volume * $record->quantity_in);
      $Density = 0;
      if ($package_weight && $package_volume) {
        $Density = ($package_weight / $package_volume);
      }
      ?>
      {{myRound($Density)}}
    </td>
    <td class="center">{{myRound($package_weight)}}</td>
    <td class="center">{{myRound($package_volume)}}</td>
    <td class="center">{{$record->price}}</td>
    <td class="center">{{myRound($record->amount)}} {{$contract->currency}}</td>
  </tr>
  @endforeach
  @for($i=0;$i<$empty;$i++) <tr>
    <td class="center">{{++$count}}</td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    <td class="center"></td>
    </tr>

    @endfor

</table>

<table style="width: 100%; border: 1px solid black;" class="main-table">
  <tr>
    <th colspan="2">@lang('layout.TotalQuantity'): {{$qtyTotal}}</th>
  </tr>
  <tr>
    <th>@lang('layout.Discount'): {{$discount}} {{$contract->currency}}</th>
    {{-- <th><span>@lang('layout.Expense'): {{$ex_amount}} {{$contract->currency}}</span></th> --}}
    <th>@lang('layout.Amount'): {{myRound(($total_amount + $ex_amount) - $discount)}} {{$contract->currency}}</th>
  </tr>
</table>
<table style="text-align: center; width: 100%">

  <tr style="font-weight: bold;">
    <td colspan="2" style="text-align: center;">
      <span style="text-align: center;"><span>
          @lang('layout.Address'): {!!company()['country']!!},{!!company()['city']!!},{!!company()['streetAddress']!!}
        </span>
      </span>

    </td>
  </tr>
  <tr style="font-weight: bold;">
    <td>
      <span class="fa fa-book">@lang('layout.Phone'): {!!company()['phone']!!}
      </span>
    </td>
    <td>
      <span>
        @lang('layout.Email'): {!!company()['email']!!}
      </span>
    </td>
  </tr>

</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','invoice') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->


@endsection