@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReport('contract_detail');
    $_name = in_array('name', $report);
    $_symbol = in_array('symbol', $report);
    $_quantity = in_array('quantity', $report);
    $_price = in_array('price', $report);
    $_total = in_array('total', $report);
    ?>
    <h3>@lang('layout.ContructReport')</h3>
    <table style="width: 100%; margin-bottom: 10px;">
        @if($info && $info !=[])

            <tr>
                <td>
                    <span>@lang('layout.Number')</span>:
                    <span>{{$info->number}}</span>
                </td>
                <td>
                    <span>@lang('layout.MemberName')</span>:
                    <span>{{$info->member_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Account')</span>:
                    <span>{{$info->account_name}}</span>
                </td>
                <td>
                    <span>@lang('layout.Amount')</span>:
                    <span>{{$info->amount}}</span>
                </td>
            </tr>
            <tr>

                <td>
                    <span>@lang('layout.Currency')</span>:
                    <span>{{$info->currency}}</span>
                </td>
                <td>
                    <span>@lang('layout.Rate')</span>:
                    <span>{{$info->rate}}</span>
                </td>
                <td>
                    <span>@lang('layout.Discount')</span>:
                    <span>{{$info->discount}}</span>
                </td>

            </tr>
        @endif

    </table>


    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            @if($_name)
                <td>
                    <div class="center"> @lang('layout.Name')</div>
                </td>@endif
            @if($_symbol)
                <td>
                    <div class="center"> @lang('layout.Symbol')</div>
                </td>@endif
            @if($_quantity)
                <td>
                    <div class="center"> @lang('layout.Quantity')</div>
                </td>@endif
            @if($_price)
                <td>
                    <div class="center"> @lang('layout.Price')</div>
                </td>@endif
            @if($_total)
                <td>
                    <div class="center"> @lang('layout.Total')</div>
                </td>@endif

        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <td class="center">{{++$count}}</td>
            @if($_name)
                <td class="center">{{$record->name}}</td>@endif
            @if($_symbol)
                <td class="center">{{$record->symbol}}</td>@endif
            @if($_quantity)
                <td class="center">{{$record->qty}}</td>@endif
            @if($_price)
                <td class="center">{{round($record->price,2)}}</td>@endif
            @if($_total)
                <td class="center">{{$record->Total}}</td>@endif

                </tr>
                @endforeach
                </tbody>
    </table>

    <table>
        <tr>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection