@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

    </style>
@stop
@section('content')
@include("layouts.Cmodal")
@include('inventories.ExModal')  

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CargoContractOrderCreate') </span>
                </div>

            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'cargoContractOrder.store','method' => 'POST','class' => 'form-horizontal','id'=>'contract-form'])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-md-9  col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ContractCode')</label>
                                    {{Form::number('number',$number,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    {{Form::text('ref_no',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Customer')</label>

                                    <div class="input-group">
                                        <v-select class="vue-select2" v-model="selected_customer" label="name" @search="MemberSearch" :options="member">
                                        </v-select>
                                        <input type="hidden" name="member_id" autocomplete="off" v-model.number="(!selected_customer)?null:selected_customer.id" v-validate="'required'" data-vv-as="@lang('layout.Customer')">
                                        <span class="btn btn-success input-group-addon " @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div>
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="col-md-12">&nbsp;</label>
                                            <label class="control-label">CBM @lang('layout.Price')</label>
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="cbm_price" v-model="cbm_price" value="ok">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                </div> 
                            </div> 
                            
                            <div class="row"> 
                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-3' }} col-sm-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" @input="selectedRate" :options="setRates"
                                              v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency" v-validate="'required'"
                                           data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-md-3' : 'col-md-3' }} col-sm-12">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    <input type="number" name="currency_rate" v-validate="'required'"
                                           data-vv-as="@lang('layout.Rate')"
                                           v-model="!selected_currency?0:selected_currency.rate" class="form-control"
                                           :class="{'has-error':rate<=0}">
                                    <span class="required">@{{ errors.first('currency_rate') }}</span> 
                                </div>

                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.DeliveryDate')</label>
                                    <input type="text" class="form-control date" autocomplete="off" name="delivery_date">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input class="form-control date"  name="date" autocomplete="off">
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-2">
                                    <label class="control-label"> &nbsp; </label>
                                    {{-- <div class="col-md-12"> --}}
                                    <a href="#" @click.prevent="showExModal = true" class="col-md-12 btn  btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.Site') 
                                    </a>
                                    {{-- </div> --}}
                                </div>
                                <div class="col-md-7">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div>
                            
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                            <!-- begin total -->
                            <div class="dashboard-stat2" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total'):</small>
                                        </td>
                                        <td class="text-right">
                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                @{{ format_number(Number(subtotal))}}
                                            </span>
                                            <small class="font-green-sharp">
                                                @{{selected_currency.symbol}}
                                            </small>
                                        </td>
                                    </tr>
                                </table>

                            </div>
                            <!-- end total -->

                        </div>


                    </div>

                    <!-- begin item -->
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.Source') / @lang('layout.Destination') </th>
                                <th style="min-width: 100px">@lang('layout.Description') Fa / En</th>
                                <th style="min-width: 100px">@lang('layout.Description') Oth</th>
                                <th style="min-width: 100px">@lang('layout.Width') / @lang('layout.Length') </th>
                                <th style="min-width: 100px">@lang('layout.Height') / @lang('layout.Volume')</th>
                                <th style="min-width: 100px">@lang('layout.Weight') / @lang('layout.Quantity') </th>
                                <th style="min-width: 100px">@lang('layout.Unit') / @lang('layout.Density') </th>
                                <th style="min-width: 100px"> @lang('layout.Weight') @lang('layout.Package') / @lang('layout.Volume') @lang('layout.Package')</th>
                                <th style="min-width: 100px">@lang('layout.Price') / <span v-show="showWhat('sale_discount')=='yes'">@lang('layout.Discount') </span></th>
                                <th style="min-width: 100px">@lang('layout.Total') </th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                
                                <td class="highlight">
                                        <v-select placeholder="@lang('layout.Source') " label="name" @input="selectPrice(index)" :options="sites" @click.native="addNew('inventory',index)" @keyup.native="addNew('inventory',index)" v-model="item.source"></v-select>
                                        <input type="hidden" :name="'source_id['+index+']'" :value="(item.source)?item.source.id:null">
                                    
                                        <v-select placeholder="@lang('layout.Destination') " label="name" @input="selectPrice(index)" :options="sites" @click.native="addNew('inventory',index)" @keyup.native="addNew('inventory',index)" v-model="item.destination"></v-select>
                                        <input type="hidden" :name="'destination_id['+index+']'" :value="(item.destination)?item.destination.id:null">
                                </td>
                                <td class="highlight">
                                    <input class="form-control" type="text" placeholder="@lang('layout.Description') Fa" :name="'item_description1['+index+']'" class="form-control">
                                    <input class="form-control" type="text" placeholder="@lang('layout.Description') En" :name="'item_description2['+index+']'" class="form-control">
                                </td>
                                <td class="highlight">
                                    <input class="form-control" type="text" placeholder="@lang('layout.Description') Oth" :name="'item_description3['+index+']'" class="form-control">
                                </td>
                                <td>
                                    <input type="number" :name="'width['+index+']'" @input="selectVolume(index)" v-model.number="item.width" class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Width')">
                                    <input type="number" :name="'length['+index+']'" @input="selectVolume(index)" v-model.number="item.length" class="form-control " style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;" placeholder="@lang('layout.Length')"> 
                                </td>
                                <td>
                                    <input type="number" :name="'height['+index+']'" @input="selectVolume(index)" v-model.number="item.height" class="form-control " placeholder="@lang('layout.Height')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'volume['+index+']'" v-model.number="item.volume" class="form-control " placeholder="@lang('layout.Volume')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>
                                <td>
                                    <input type="number" :name="'weight['+index+']'" @input="selectPrice(index), selectPackageWeight(index)" v-model.number="item.weight" class="form-control " placeholder="@lang('layout.Weight')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'quantity_in['+index+']'" v-validate=""
                                           data-vv-as="@lang('layout.Quantity')" v-model.number="item.quantity" @input="selectVolume(index), selectPackageWeight(index)"
                                           class="form-control " placeholder="@lang('layout.Quantity')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <span class="required">@{{ errors.first('quantity_in['+index+']') }}</span>
                                </td>
                                <td>
                                    <v-select placeholder="@lang('layout.Unit') " label="measure_name" :options="measure" v-model="item.selected_measure"></v-select>
                                    <input type="hidden" :name="'um_id['+index+']'" :value="(item.selected_measure)?item.selected_measure.measure_id:null">

                                    @{{ (item==null)?null:getDensity(index) }}
                                    <input type="hidden" :name="'density['+index+']'" :value="getDensity(index)" class="form-control " placeholder="@lang('layout.Density')">
                                </td>
                                <td>
                                    <input type="number" :name="'package_weight['+index+']'" v-model.number="item.package_weight" class="form-control " readonly placeholder="@lang('layout.Weight') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                    <input type="number" :name="'package_volume['+index+']'" v-model.number="item.package_volume" class="form-control "  placeholder="@lang('layout.Volume') @lang('layout.Package')" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" :name="'price['+index+']'" placeholder="@lang('layout.Price')"
                                            v-model.number="item.price" @input="setNewRate(index)" class="form-control" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                    
                                    <div class="input-group" v-show="showWhat('sale_discount')=='yes'">
                                        <input type="number" :name="'row_discount['+index+']'"
                                               placeholder="@lang('layout.Discount')"
                                               v-model.number="item.discount"
                                               class="form-control" style="margin-top: 2px; margin-bottom: 2; border: 1px solid #c2cad8 !important;">
                                        <span class="input-group-addon" v-if="discountIsAmount">
                                        @{{selected_currency.symbol}}
                                      </span>
                                        <!-- <span class="input-group-addon" v-if="!discountIsAmount">
                                        %
                                      </span> -->
                                    </div>
                                </td>
                                <td>
                                    @{{ (item==null)?null:getTolal(index) }}
                                    <b>@{{selected_currency.symbol}}</b>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            <tr style="background-color: #ffffff;">
                                <td></td>
                                <td>
                                    <center>
                                        <button type="button" @click="addNew('inventory',100)" class="btn btn-success">
                                            <i class="fa fa-plus"></i></button>
                                    </center>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            </tbody>
                        </table>
                        <hr/>

                        <br/>
                    </div>
                    <span v-if="inventories.length==0">
                         <button type="button" @click="addNew('inventory',0)" class="btn btn-success"><i
                                     class="fa fa-plus"></i></button>
                      </span>
                    <!-- end item -->

                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                    <a href="{{route('cargoContractOrder.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

                <!--Begin Modal -->                                    
                <ex_modal :show="showExModal" @close="showExModal=false">
                    <h3 slot='cheader'>@lang('layout.CreateNewInventorySite')</h3>
                    <div slot="cbody">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang("layout.Name") <span class="required"> * </span></label>
                                    <input type="text" class="form-control" name="site_name" v-model="site_name">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang("layout.Description")</label>
                                    <textarea class="form-control" name="site_description" v-model="site_description">
                                    </textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div slot="cfooter">
                        <button type="button" class="modal-default-button btn btn-success" @click="addExpenseCategory">
                            @lang('layout.Submit')
                        </button>
                    </div>
                </ex_modal>
                <!--End Modal-->

                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);

        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,

                }
            },
            mounted() {
                setTimeout(() => {
                    this.getMemberCode();
                }, 500);
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();
                    let vmc = this;
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': "{{csrf_token()}}"
                        },
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null

                        },
                        dataType: 'json',

                    }).done(function(response) {
                        if (response) {
                            v.selected_customer = response.customer;
                            vmc.getMemberCode();
                        }
                    }).fail(function(error) {
                        console.log('error', error);
                    });

                },
                getMemberCode() {
                    let vmc = this;
                    axios.get('{{route("customer.create")}}').then(
                    response => {
                        vmc.types = response.data.types;
                        if (vmc.types) {
                            for (var i = 0; i < vmc.types.length; i++) {
                                if (vmc.types[i].type == "Customer") {
                                    vmc.selectType = vmc.types[i];
                                }
                            }
                        }
                        vmc.receivables = response.data.receivable;
                        vmc.payables = response.data.payable;
                        vmc.code = response.data.code;
                        vmc.classes = response.data.member_class;
                        if(vmc.receivables.length>0)
                        {
                            vmc.selectReceive=vmc.receivables[0];
                        }
                        if(vmc.payables.length>0)
                        {
                            vmc.selectPay=vmc.payables[0];
                        }

                    }).catch(error => console.log(error));
                }
            }
        });

        Vue.component('ex_modal', {
            template:'#exModal-template',
            props: ['show'],
        });

        var banks = {!! $banks!!}
        var currency = {!! $currency!!}
        var inventorySite = {!! $inventorySite !!};
        // group of company
        let homeCurrency = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
        
        let measureUnitList = {!!$measureUnitList!!};

        var v = new Vue({
            el: '#app',
            data: {
                currency: currency,
                selected_currency: homeCurrency,
                member: [],
                selected_customer: null,
                showModal: false,
                showExModal: false,
                listAccounts: [],
                type: 'bank',
                banks: banks,
                selected_banks: null,
                rate: 0,
                temp_items: [],
                sites: inventorySite,
                inventory_category: inventorySite,
                selected_category: null,
                selected_iventory_category: null,
                measure: measureUnitList,
                selected_measure:null,
                cbm_price:null,
                site_name:null,
                site_description:null,
                selected_index: 0,
                inventories: [
                    {item: null, source: null, destination: null, density: null, height: null, length: null, price: null, quantity: null, selected_measure: null, 
                    volume: null, weight: null, width: null, package_volume: null, package_weight: null, discount: null, expense: null, expense_detail: null}
                ],
                discountFiled: 0,
                discountIsAmount: true,
            },
            computed: {

                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    static_rate: a.static_rate,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                static_rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                    this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    static_rate: r.static_rate,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });

                    return rates;

                },
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].quantity != null && this.inventories[i].price != null) { 
                            if (this.cbm_price) {
                                var quantity = this.inventories[i].package_volume;
                            } else if (this.total_weight_price) {
                                var quantity = this.inventories[i].package_weight;
                            } else {
                                var quantity = this.inventories[i].quantity;
                            }

                            var price = this.inventories[i].price;
                            var temp = (quantity * price);

                            if (this.inventories[i].discount > 0) {
                                var discount = this.inventories[i].discount;
                                temp = (Number.parseFloat(temp) - Number.parseFloat(discount));
                            }

                            if (this.inventories[i].expense > 0) {
                                var expense = this.inventories[i].expense;
                                temp = (Number.parseFloat(temp) + Number.parseFloat(expense));
                            }

                            sum += temp;
                        }
                    }
                    return sum;
                },


                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function() {
                
            },
            methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                //Function to add MemberCLass
                addExpenseCategory:function(){
                    axios.post("{{route('cargoSite.store')}}",{
                        name:v.site_name,
                        description:v.site_description
                    })
                    .then(function(response){
                        axios.get("{{route('cargoSite.create')}}").then(function (response) {
                            v.site_name = null;
                            v.site_description = null;
                            v.sites = response.data;
                        });
                    });
                    v.showExModal = false;
                },


                    // calculate item price based on measure change
                    getTolal(index) {
                        var temp = 0;
                        // console.log(222,this.inventories[index]);
                        if (this.inventories[index].quantity != null && this.inventories[index].price != null) { 
                            if (this.cbm_price) {
                                var quantity = this.inventories[index].package_volume;
                            } else if (this.total_weight_price) {
                                var quantity = this.inventories[index].package_weight;
                            } else {
                                var quantity = this.inventories[index].quantity;
                            }

                            var price = this.inventories[index].price;
                            temp = (quantity * price);

                            if (this.inventories[index].discount > 0) {
                                var discount = this.inventories[index].discount;
                                temp = (Number.parseFloat(temp) - Number.parseFloat(discount));
                            }

                            if (this.inventories[index].expense > 0) {
                                var expense = this.inventories[index].expense;
                                temp = (Number.parseFloat(temp) + Number.parseFloat(expense));
                            }
                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    getDensity(index) {
                        var temp = 0;
                        if (this.inventories[index].package_weight != null && this.inventories[index].package_volume != null) {
                            var package_weight = this.inventories[index].package_weight;
                            var package_volume = this.inventories[index].package_volume;
                            temp = (package_weight / package_volume);
                        }
                        temp = Number.parseFloat(temp).toFixed(precision());
                        return temp;
                    },

                    // calculate item price based on measure change
                    selectVolume(index) {
                        var temp = 0;
                        // console.log(222,this.inventories[index]);

                        if (this.inventories[index].width != null && this.inventories[index].length != null && this.inventories[index].height != null) {
                            var width = this.inventories[index].width;
                            var length = this.inventories[index].length;
                            var height = this.inventories[index].height;
                            var volume = (width * length * height);
                            this.inventories[index].volume = Number.parseFloat(volume).toFixed(precision());

                            if (this.inventories[index].quantity > 0) {
                                var quantity = this.inventories[index].quantity; 
                                this.inventories[index].package_volume = Number.parseFloat(volume * quantity).toFixed(precision());
                            }
                        }
                        // temp = Number.parseFloat(temp).toFixed(precision());
                        // return temp;
                    },

                    // calculate item price based on measure change
                    selectPackageWeight(index) {
                        // console.log(222,this.inventories[index]);

                        if (this.inventories[index].quantity != null && this.inventories[index].weight != null) {
                            var weight = this.inventories[index].weight;
                            var quantity = this.inventories[index].quantity;
                            var package_weight = (weight * quantity);
                            this.inventories[index].package_weight = Number.parseFloat(package_weight).toFixed(precision());
                        }
                    },

                    // set new price
                    setNewRate(index) { 
                        if (this.inventories[index].item) {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            @endif 
                        }
                    },
                    // begin item search

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.member = [];
                                v.member = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: "itemSearchPurchase",
                                keyword: search,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    setIndex(e) {
                        this.selected_index = e;
                    },
                    selectPrice(index) {
                        if (v.inventories[index]['source'] != null && v.inventories[index]['destination'] != null && v.inventories[index]['weight'] > 0) {
                            // console.log(v.inventories[index]);

                            let source_id = v.inventories[index]['source'].id;
                            let destination_id = v.inventories[index]['destination'].id;
                            let weight = v.inventories[index]['weight'];
                            axios.get("{{route('callcargoContract.search')}}", {
                                params: {
                                    method_name: 'selectPrice',
                                    source_id: source_id,
                                    destination_id: destination_id,
                                    weight: weight
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.amount) {
                                        // console.log(312, response.data.amount);
                                        v.inventories[index]['price'] = response.data.amount;
                                    }
                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, source: null, destination: null, density: null, height: null,
                                        length: null, price: null, quantity: null, selected_measure: null, volume: null, weight: null,
                                        width: null, package_volume: null, package_weight: null, discount: null, expense: null,
                                        expense_detail: null});
                                }
                            }
                        }

                    },


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {


                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("contract-form").submit()

                            }
                            else {

                            }
                        });

                    },

                    defaultValue() {

                        this.inventories = [
                            {item: null, source: null, destination: null},
                        ];


                        this.discountFiled = 0;
                        this.temp_items = [];
                    },
                    saveAndNew()
                    {
                        this.$validator.validate()
                        .then(valid =>{
                            if(valid)
                            {
                                var url="{{route('cargoContractOrder.store')}}";
                                form_id='contract-form';
                                var data= $('#'+form_id).serialize();
                                // console.log(444, data);
                                toggleBlock(true);
                                axios.post(url,data)
                                .then(function(response){
                                        toggleBlock(0);
                                        if(response.data.result==1)
                                        {
                                            $('#'+form_id).trigger('reset');
                                            
                                            toastr.success('',response.data.message); 
                                            location.reload();
                                        
                                        }
                                        else
                                        {
                                            var message="{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('',message);
                                        }
                                })
                                .catch(function(error){
                                toggleBlock(0);
                                    console.log(error);
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                });
                            
                            }
                        })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush