@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ProfitAndLost') @lang('layout.Contract')</h3>

    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.ReferenceNumber')</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.Amount')</th>
                <th>@lang('layout.Currency')</th>
                <th>@lang('layout.Rate')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Status')</th>
                <th>@lang('layout.User')</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class=""> {{ $contract->number}} </td>
                <td class=""> {{ $contract->ref_no}} </td>
                <td class=""> {{ $contract->Customer}} </td>
                <td class=""> {{ $contract->amount}}</td>
                <td class=""> {{ $contract->currency}}</td>
                <td class=""> {{ $contract->rate}}</td>
                <td class=""> {{ $contract->date}}</td>
                <td class="">
                    @if($contract->status == "Active")
                    @lang('layout.Active')
                    @else
                    @lang('layout.Closed')
                    @endif
                </td>
                <td class=""> {{ $contract->user}}</td>
            </tr>
        </tbody>
    </table>

    <table class="main-table">
        <thead>
            <tr class="bg">
                <th>@lang('layout.DeliveryDate')</th>
                <th>@lang('layout.Income')</th>
                <th>@lang('layout.Expense')</th>
                <th>@lang('layout.Description')</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class=""> {{ $contract->delivery_date}} </td>
                <td class=""> {{ $contract->Income}} </td>
                <td class=""> {{ $contract->Expense}} </td>
                <td class=""> {{ $contract->description}}</td>
            </tr>
        </tbody>
    </table>
    <hr />
    <h3>@lang('layout.ItemDetails')</h3>
    <table class="main-table">
        <thead>

        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Source')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Volume')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Density')</th>
            <th>@lang('layout.Weight') @lang('layout.Package')</th>
            <th>@lang('layout.Volume') @lang('layout.Package')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Discount')</th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.ExpenseDetails')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>

        <?php
        $count = 0;

        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->source_name}}</td>
                <td class="center">{{$record->destination_name}}</td>
                <td class="center">{{$record->item_description1}} <br/> {{$record->item_description2}} <br/> {{$record->item_description3}}</td>
                <td class="center">{{$record->width}}</td>
                <td class="center">{{$record->length}}</td>
                <td class="center">{{$record->height}}</td>
                <td class="center">{{$record->volume}}</td>
                <td class="center">{{$record->weight}}</td>
                <td class="center">{{$record->quantity_in}}</td>
                <td class="center">
                    <?php
                    $package_weight = ($record->weight * $record->quantity_in);
                    $package_volume = ($record->volume * $record->quantity_in);
                    $Density = 0;
                    if($package_weight && $package_volume){
                        $Density = ($package_weight / $package_volume);
                    }
                    ?>
                    {{myRound($Density)}}
                </td>
                <td class="center">{{myRound($package_weight)}}</td>
                <td class="center">{{myRound($package_volume)}}</td>
                <td class="center">{{$record->price}}</td>
                <td class="center">{{$record->discount}}</td>
                <td class="center">{{myRound($record->ex_amount)}}</td>
                <td class="center">{{$record->ex_description}}</td>
                <td class="center">{{myRound($record->amount)}}</td>
            </tr>
        @endforeach
    </table>


    <hr />
    <h3>@lang('layout.OnHand')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Source')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Volume')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Density')</th>
            <th>@lang('layout.Weight') @lang('layout.Package')</th>
            <th>@lang('layout.Volume') @lang('layout.Package')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>

        <?php
        $count = 0;

        ?>
        @foreach($stock_onHand AS $record1)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record1->source_name}}</td>
                <td class="center">{{$record1->destination_name}}</td>
                <td class="center">{{$record1->item_description1}}</td>
                <td class="center">{{$record1->width}}</td>
                <td class="center">{{$record1->length}}</td>
                <td class="center">{{$record1->height}}</td>
                <td class="center">{{$record1->volume}}</td>
                <td class="center">{{$record1->weight}}</td>
                <td class="center">{{$record1->quantity_in}}</td>
                <td class="center">
                    <?php
                    $package_weight = ($record1->weight * $record1->quantity_in);
                    $package_volume = ($record1->volume * $record1->quantity_in);
                    $Density = 0;
                    if($package_weight && $package_volume){
                        $Density = ($package_weight / $package_volume);
                    }
                    ?>
                    {{myRound($Density)}}
                </td>
                <td class="center">{{myRound($package_weight)}}</td>
                <td class="center">{{myRound($package_volume)}}</td>
                <td class="center">{{$record1->price}}</td>
                <td class="center">{{myRound($record1->amount)}}</td>
            </tr>
        @endforeach
    </table>



    <hr />
    <h3>@lang('layout.TransferAndLoading')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Responsible')</th>
            <th>@lang('menu.Container')</th>
            <th>@lang('menu.Vehicle')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.WayBillNumber')</th>
            <th>@lang('layout.TransitNumber')</th>
            <th>@lang('layout.Site')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <!-- <th>@lang('layout.Price')</th> -->
        </tr>
        </thead>

        <?php
        $count = 0;
        ?>
        @foreach($cargoLoading AS $record2)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center"> {{ $record2->number}}  </td>
                <td class="center"> {{convertDate($record2->date)}}  </td>
                <td class="center"> {!! __('layout.' . ucfirst($record2->type)) !!} </td>
                <td class="center"> {{ $record2->employee}}  </td> 
                <td class="center"> {{ $record2->container}}  </td> 
                <td class="center"> @if($record2->driver_type == 'ForeignDriver') {{ $record2->other_vehicle_name}} @else {{ $record2->vehicle}} @endif </td>
                <td class="center">  @if($record2->driver_type == 'ForeignDriver') {{ $record2->driver}} {{ $record2->other_driver_name}} @else {{ $record2->driver}} @endif </td>
                <td class="center"> {{ $record2->cmr_number}}  </td>
                <td class="center"> {{ $record2->transit_number}}  </td>
                <td class="center">{{$record2->source_site}}</td>
                <td class="center">{{$record2->name}}</td>
                <td class="center">{{$record2->weight}}</td>
                <td class="center">{{$record2->quantity}}</td>
                <!-- <td class="center">{{$record2->price}}</td> -->
            </tr>
        @endforeach
    </table>


    <hr />
    <h3>@lang('menu.Delivery')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('menu.Container')</th>
            <th>@lang('layout.TransitNumber')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.Item')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Price') </th>
            <th>@lang('layout.Volume')</th>
        </tr>
        </thead>

        <?php
        $count = 0;
        ?>
        @foreach($cargoDeliveryDetail AS $record3)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center"> {{ $record3->number}}  </td>
                <td class="center"> {{convertDate($record3->date)}}  </td>
                <td class="center"> {{ $record3->container}}  </td>
                <td class="center"> {{ $record3->transit_number}}  </td>
                <td class="center"> {{ $record3->description}}  </td>
                <td class="center">{{$record3->name}}</td>
                <td class="center">{{$record3->site}}</td>
                <td class="center">{{$record3->width}}</td>
                <td class="center">{{$record3->height}}</td>
                <td class="center">{{$record3->length}}</td>
                <td class="center">{{$record3->weight}}</td>
                <td class="center">{{$record3->quantity}}</td>
                <td class="center">{{$record3->price}}</td>
                <td class="center">{{$record3->volume}}</td>
            </tr>
        @endforeach
    </table>


    <hr />
    <h3>@lang('layout.ItemExpense')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.ItemName') </th>
            <th>@lang('layout.SiteName') </th>
            <th>@lang('layout.Weight') </th>
            <th>@lang('layout.Quantity') </th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.TotalExpenses')</th>
        </tr>
        </thead>

        <?php
        $count = 0;
        ?>
        @foreach($itemExpense AS $record4)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record4->name}}</td>
                <td class="center">{{$record4->destination}}</td>
                <td class="center">{{$record4->weight}}</td>
                <td class="center">{{$record4->quantity}}</td>
                <td class="center">{{$record4->currency}}</td>
                <td class="center">{{$record4->rate}}</td>
                <td class="center">{{myRound($record4->totalAmount)}}</td>
            </tr>
        @endforeach
        @if($itemExpenseAmount)
            <tr>
                <td class="center" colspan="3" >@lang('layout.Total')</td>
                <td class="center" colspan="4" > {{myRound($itemExpenseAmount->totalAmount)}} {{ $contract->currency}} </td>
            </tr>
        @endif

    </table>

    <hr />
    <h3>@lang('layout.AdjustmentList')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Number') </th>
            <th>@lang('layout.Date') </th>
            <th>@lang('layout.ItemName') </th>
            <th>@lang('layout.SiteName') </th>
            <th>@lang('layout.Weight') </th>
            <th>@lang('layout.Quantity') </th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Total')</th>
            <th>@lang('layout.Description')</th>
        </tr>
        </thead>

        <?php
        $count = 0;
        $adjustment = 0; 
        ?>
        @foreach($cargoWastages AS $record5)
            <?php
            $adjustment += $record5->amount;
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record5->number}}</td>
                <td class="center">{{convertDate($record5->date)}}</td>
                <td class="center">{{$record5->item_description1}}</td>
                <td class="center">{{$record5->site}}</td>
                <td class="center">{{$record5->weight}}</td>
                <td class="center">{{$record5->quantity}}</td>
                <td class="center">{{$record5->currency}}</td>
                <td class="center">{{$record5->rate}}</td>
                <td class="center">{{myRound($record5->price)}}</td>
                <td class="center">{{myRound($record5->price * $record5->quantity)}}</td>
                <td class="center">{{$record5->description}}</td>
            </tr>
        @endforeach
        @if($adjustment)
            <tr>
                <td class="center" colspan="4" >@lang('layout.Total')</td>
                <td class="center" colspan="6" > {{myRound($adjustment * $contract->rate)}} {{ $contract->currency}} </td>
            </tr>
        @endif

    </table>


    <hr />
    <h3>@lang('layout.Total')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">
            <th>@lang('layout.Currency') </th>
            <th>@lang('layout.Amount') </th>
            <th>@lang('layout.Adjustment') </th>
            <th>@lang('layout.TotalExpenses') </th>
            <th>@lang('layout.Income') </th>
        </tr>
        </thead>

        <?php
        $itemExpenseAmount = ($itemExpenseAmount)?$itemExpenseAmount->totalAmount:0; 
        ?>
            <tr>
                <td class="center"> {{ $contract->currency}}</td>
                <td class="center"> {{ myRound($contract->amount)}}</td>
                <td class="center" > {{myRound($adjustment * $contract->rate)}} </td>
                <td class="center" > {{myRound($itemExpenseAmount)}} </td>
                <td class="center" > {{myRound($contract->amount - ($adjustment * $contract->rate) - $itemExpenseAmount)}} </td>
                
            </tr>

    </table>





@endsection