@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.CargoContractReport')</h3>

    <br>
    <table class="main-table">
        <thead>
            <tr class="bg">
                <th>@lang('layout.Number')</th>
                <th>@lang('layout.ReferenceNumber')</th>
                <th>@lang('layout.Customer')</th>
                <th>@lang('layout.Amount')</th>
                <th>@lang('layout.Currency')</th>
                <th>@lang('layout.Rate')</th>
                <th>@lang('layout.Date')</th>
                <th>@lang('layout.Status')</th>
                <th>@lang('layout.User')</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class=""> {{ $contract->number}} </td>
                <td class=""> {{ $contract->ref_no}} </td>
                <td class=""> {{ $contract->Customer}} </td>
                <td class=""> {{ $contract->amount}}</td>
                <td class=""> {{ $contract->currency}}</td>
                <td class=""> {{ $contract->rate}}</td>
                <td class=""> {{ $contract->date}}</td>
                <td class="">
                    @if($contract->status == "Active")
                    @lang('layout.Active')
                    @else
                    @lang('layout.Closed')
                    @endif
                </td>
                <td class=""> {{ $contract->user}}</td>
            </tr>
        </tbody>
    </table>

    <table class="main-table">
        <thead>
            <tr class="bg">
                <th>@lang('layout.DeliveryDate')</th>
                <th>@lang('layout.Description')</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class=""> {{ $contract->delivery_date}} </td>
                <td class=""> {{ $contract->description}}</td>
            </tr>
        </tbody>
    </table>
    <br/>
    <table class="main-table">
        <thead>

        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Source')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Width')</th>
            <th>@lang('layout.Length')</th>
            <th>@lang('layout.Height')</th>
            <th>@lang('layout.Volume')</th>
            <th>@lang('layout.Weight')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.QutOut')</th>
            <th>@lang('layout.RemainQuantity')</th>
            <th>@lang('layout.Density')</th>
            <th>@lang('layout.Weight') @lang('layout.Package')</th>
            <th>@lang('layout.Volume') @lang('layout.Package')</th>
            <th>@lang('layout.Price')</th>
            <th>@lang('layout.Discount')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        </thead>

        <?php
        $count = 0;

        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->source_name}}</td>
                <td class="center">{{$record->destination_name}}</td>
                <td class="center">{{$record->item_description1}} <br/> {{$record->item_description2}} <br/> {{$record->item_description3}}</td>
                <td class="center">{{$record->width}}</td>
                <td class="center">{{$record->length}}</td>
                <td class="center">{{$record->height}}</td>
                <td class="center">{{$record->volume}}</td>
                <td class="center">{{$record->weight}}</td>
                <td class="center">{{$record->quantity_in}}</td>
                <td class="center">{{$record->quantity_out}}</td>
                <td class="center">{{($record->quantity_in - $record->quantity_out)}}</td>
                <td class="center">
                    <?php
                    $package_weight = ($record->weight * $record->quantity_in);
                    $package_volume = ($record->volume * $record->quantity_in);
                    $Density = 0;
                    if($package_weight && $package_volume){
                        $Density = ($package_weight / $package_volume);
                    }
                    ?>
                    {{myRound($Density)}}
                </td>
                <td class="center">{{myRound($package_weight)}}</td>
                <td class="center">{{myRound($package_volume)}}</td>
                <td class="center">{{$record->price}}</td>
                <td class="center">{{$record->discount}}</td>
                <td class="center">{{myRound($record->amount)}}</td>
            </tr>
        @endforeach
    </table>





@endsection