@extends('layouts.app')

@section('content')
    <!-- END PAGE HEADER-->

    <!-- new modal -->

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'inStock'"  @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Customer') </label>
                                    <v-select label="name" :options="member" v-model="selectedMember" @search="MemberSearch" placeholder="@lang('layout.Customer')" ></v-select>
                                    <input type="hidden" name="member_id" :value="!selectedMember?null:selectedMember.id" >
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.ContractNumber') </label>
                                    <input type="number" name="number" class="form-control" autocomplete="off">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Site') </label>
                                    <v-select label="name" :options="inventorySite" v-model="selectedSite" placeholder="@lang('layout.Site')" >
                                    </v-select>
                                    <input type="hidden" name="site_id" :value="!selectedSite?null:selectedSite.id" >
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label ">@lang('layout.Destination') </label>
                                    <v-select label="name" :options="destinationSite" v-model="selectedDestination" placeholder="@lang('layout.Destination')" ></v-select>
                                    <input type="hidden" name="destination_id" :value="!selectedDestination?null:selectedDestination.id" >
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Date')</label>
                                        <div slot="date">
                                            <div class="input-group">
                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="projectMainProfitAndLost">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding-right: 3px !important; padding-left:3px !important; margin-right:0 !important;" v-for="(row,itemIndex) in cust_repcontractesMain">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div> 
                                        <div style="margin-top-10; margin-bottom:30px; margin-right:10px;">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCutomReForm(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- /new modal -->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InStock')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('CargoLoading-create')
                    <a href="{{route('cargoLoading.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.LoadingDetail')
                        </button>
                    </a>
                    @endpermission
                    @permission('CargoContract-list')
                    <a href="{{route('cargoContract.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.CargoContract')
                        </button>
                    </a>
                    @endpermission
                    @permission('CargoContract-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                    @permission('CargoLoading-create')
                    <a href="{{route('cargoLoading.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Loading')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <div class="row" id="app">
                    <div class="col-md-3">
                        <label class="control-label ">@lang('layout.Site') </label> 
                        <select name="site_id" @input="getData()"  v-model="site_id" class="form-control">
                            <option value="">@lang('layout.SelectSite')</option>
                            @foreach($inventorySite as $row)
                            <option value="{{$row['id']}}">{{$row['name']}} </option>
                            @endforeach
                        </select> 

                    </div>
                </div>

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="cargoContracts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Destination')</th>
                        <th>@lang('layout.ItemName')</th>
                        <th>@lang('layout.Width')</th>
                        <th>@lang('layout.Length')</th>
                        <th>@lang('layout.Height')</th>
                        <th>@lang('layout.Volume')</th>
                        <th>@lang('layout.Weight')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Density')</th>
                        <th>@lang('layout.Weight') @lang('layout.Package')</th>
                        <th>@lang('layout.Volume') @lang('layout.Package')</th>
                        <th>@lang('layout.Price')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Expense')</th>
                        <th>@lang('layout.ExpenseDetails')</th>
                        <th>@lang('layout.Total')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->


    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')


    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        var cust_repcontractmain = {!!customeReportNewData('projectMainProfitAndLost')!!};

        let data_table;

        let data_table_max;


        function getRecord() { 
                data_table_max = $('#cargoContracts').DataTable({
                ajax: {
                    ajax: '{{route("cargoContract.indexStock")}}',
                    data: {
                        site_id: vtr.site_id                    
                    }
                },

                // pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:8}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy:true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [{
                    data: 'number',
                    name: 'number'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'Customer',
                    name: 'Customer'
                },{
                    data: 'source_name',
                    name: 'source_name'
                },
                {
                    data: 'destination_name',
                    name: 'destination_name'
                },
                {
                    data: 'item',
                    name: 'item'
                },
                {
                    data: 'width',
                    name: 'width'
                },
                {
                    data: 'length',
                    name: 'length'
                },
                {
                    data: 'height',
                    name: 'height'
                },
                {
                    data: 'volume',
                    name: 'volume'
                },
                {
                    data: 'weight',
                    name: 'weight'
                },
                {
                    data: 'quantity_in',
                    name: 'quantity_in'
                },
                {
                    data: 'Density',
                    name: 'Density'
                },
                {
                    data: 'package_weight',
                    name: 'package_weight'
                },
                {
                    data: 'package_volume',
                    name: 'package_volume'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'discount',
                    name: 'discount'
                },
                {
                    data: 'ex_amount',
                    name: 'ex_amount'
                },
                {
                    data: 'ex_description',
                    name: 'ex_description'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
            ]
            });
    }



        $(document).ready(function() {
        getRecord();
        });


        var inventorySite = {!! $inventorySite !!};
 
        var vtr = new Vue({
            el: '#app',
            data: {
                site_id : 0
            },
            methods: {
                getData() {
                    // console.log(322, this.site_id);
                    setTimeout(() => {
                        getRecord();
                    }, 200);
                }
            }
        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("cargoContract.report") !!}',
                excelRoute: '{!! route("cargoContract.report") !!}',
                inventorySite: inventorySite,
                destinationSite: inventorySite,
                selectedSite: null,
                selectedDestination: null,
                selectedMember: null,
                member: null,
                cust_repcontractesMain:[
                    {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_repcontractmain.record)?'checked':'',column_percentage:(cust_repcontractmain.record___percent)?cust_repcontractmain.record___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_repcontractmain.number)?'checked':'',column_percentage:(cust_repcontractmain.number___percent)?cust_repcontractmain.number___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_repcontractmain.date)?'checked':'',column_percentage:(cust_repcontractmain.date___percent)?cust_repcontractmain.date___percent:''},
                    {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_repcontractmain.customer)?'checked':'',column_percentage:(cust_repcontractmain.customer___percent)?cust_repcontractmain.customer___percent:''},
                    {Name: '@lang("layout.Source")', column_name: 'source',checkedColumn:(cust_repcontractmain.source)?'checked':'',column_percentage:(cust_repcontractmain.source___percent)?cust_repcontractmain.source___percent:''},
                    {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_repcontractmain.destination)?'checked':'',column_percentage:(cust_repcontractmain.destination___percent)?cust_repcontractmain.destination___percent:''},
                    {Name: '@lang("layout.ItemName")', column_name: 'itemName',checkedColumn:(cust_repcontractmain.itemName)?'checked':'',column_percentage:(cust_repcontractmain.itemName___percent)?cust_repcontractmain.itemName___percent:''},
                    {Name: '@lang("layout.Width")', column_name: 'width',checkedColumn:(cust_repcontractmain.width)?'checked':'',column_percentage:(cust_repcontractmain.width___percent)?cust_repcontractmain.width___percent:''},
                    {Name: '@lang("layout.Length")', column_name: 'length',checkedColumn:(cust_repcontractmain.length)?'checked':'',column_percentage:(cust_repcontractmain.length___percent)?cust_repcontractmain.length___percent:''},
                    {Name: '@lang("layout.Height")', column_name: 'height',checkedColumn:(cust_repcontractmain.height)?'checked':'',column_percentage:(cust_repcontractmain.height___percent)?cust_repcontractmain.height___percent:''},
                    {Name: '@lang("layout.Volume")', column_name: 'volume',checkedColumn:(cust_repcontractmain.volume)?'checked':'',column_percentage:(cust_repcontractmain.volume___percent)?cust_repcontractmain.volume___percent:''},
                    {Name: '@lang("layout.Weight")', column_name: 'weight',checkedColumn:(cust_repcontractmain.weight)?'checked':'',column_percentage:(cust_repcontractmain.weight___percent)?cust_repcontractmain.weight___percent:''},
                    {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_repcontractmain.quantity)?'checked':'',column_percentage:(cust_repcontractmain.quantity___percent)?cust_repcontractmain.quantity___percent:''},
                    {Name: '@lang("layout.Weight") @lang("layout.Package")', column_name: 'weightPackage',checkedColumn:(cust_repcontractmain.weightPackage)?'checked':'',column_percentage:(cust_repcontractmain.weightPackage___percent)?cust_repcontractmain.weightPackage___percent:''},
                    {Name: '@lang("layout.Volume") @lang("layout.Package")', column_name: 'volumePackage',checkedColumn:(cust_repcontractmain.volumePackage)?'checked':'',column_percentage:(cust_repcontractmain.volumePackage___percent)?cust_repcontractmain.volumePackage___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_repcontractmain.currency)?'checked':'',column_percentage:(cust_repcontractmain.currency___percent)?cust_repcontractmain.currency___percent:''},
                    {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_repcontractmain.price)?'checked':'',column_percentage:(cust_repcontractmain.price___percent)?cust_repcontractmain.price___percent:''},
                    {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_repcontractmain.discount)?'checked':'',column_percentage:(cust_repcontractmain.discount___percent)?cust_repcontractmain.discount___percent:''},
                    {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(cust_repcontractmain.expense)?'checked':'',column_percentage:(cust_repcontractmain.expense___percent)?cust_repcontractmain.expense___percent:''},
                    {Name: '@lang("layout.ExpenseDetails")', column_name: 'expenseDetails',checkedColumn:(cust_repcontractmain.expenseDetails)?'checked':'',column_percentage:(cust_repcontractmain.expenseDetails___percent)?cust_repcontractmain.expenseDetails___percent:''},
                    {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_repcontractmain.total)?'checked':'',column_percentage:(cust_repcontractmain.total___percent)?cust_repcontractmain.total___percent:''},
                    {Name: '@lang("layout.PerCurrency")', column_name: 'perCurrency',checkedColumn:(cust_repcontractmain.perCurrency)?'checked':'',column_percentage:(cust_repcontractmain.perCurrency___percent)?cust_repcontractmain.perCurrency___percent:''},
                ],
                cust_repcontractmain:cust_repcontractmain,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // register modal component

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush
